<?php
/**
 * Happyden Team Widget.
 *
 *
 * @since 1.0.0
 */

namespace Elementor;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\Widget_Base;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Css_Filter;
use Elementor\Icons_Manager;
use Elementor\Utils;
use Elementor\Repeater;
use Elementor\URL;
use \Elementor\Control_Media;

if (!defined('ABSPATH')) {
    exit;
}
// If this file is called directly, abort.
class AdinaIconBoxThree extends Widget_Base {
    public function get_name() {
        return 'adina_iconbox_three';
    }
    public function get_title() {
        return __('IconBox Three', 'adina');
    }
    public function get_icon() {
        return ('eicon-person');
    }
    public function get_categories() {
        return ['adina-addons'];
    }
    public function get_keywords() {
        return ['iconbox', 'steps', 'process'];
    }
    protected function register_controls() {
        $this->start_controls_section('general_section',
            [
                'label' => __('General ', 'adina'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'iconbox_layout',
            [
                'label' => esc_html__('Select Layout', 'adina'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'layout-01' => esc_html__('Style 1', 'adina'),
                    'layout-02' => esc_html__('Style 2', 'adina'),
                ],
                'default' => 'layout-01',
            ]
        );
        $this->add_control(
			'icon_shape',
			[
				'label' => esc_html__( 'Shape', 'adina' ),
				'type' =>  Controls_Manager::MEDIA,
                'condition' => [
                    'iconbox_layout' => 'layout-01'
                ],
			]
		);
        $this->add_control(
			'icon_class',
			[
				'label' => esc_html__( 'Here you can use Fontawsome Class', 'adina' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'icon-enter-product-details', 'adina' ),
				'label_block' => true,
			]
		);
        $this->add_control(
			'icon_sub_title',
			[
				'label' => esc_html__( 'Sub Title', 'adina' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'STEP-1', 'adina' ),
				'label_block' => true,
                'condition' => [
                    'iconbox_layout' => 'layout-01'
                ],
			]
		);
        $this->add_control(
			'icon_title',
			[
				'label' => esc_html__( 'Icon Title', 'adina' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Enter Product Details', 'adina' ),
				'label_block' => true,
                'condition' => [
                    'iconbox_layout' => 'layout-01'
                ],
			]
		);
        $this->add_control(
			'icon_content',
			[
				'label' => esc_html__( 'Icon Content', 'adina' ),
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'Once you place your order via mail or fax our field staff will collect the documents
                and consignments from.', 'adina' ),
				'label_block' => true,
			]
		);
        $this->add_responsive_control(
			'content_align',
			[
				'label' => esc_html__( 'Alignment', 'adina' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'adina' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'adina' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'adina' ),
						'icon' => 'eicon-text-align-right',
					],
				],
                'condition' => [
                    'iconbox_layout' => 'layout-01'
                ],
				'default' => 'center',
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .work-process-two__single' => 'text-align: {{VALUE}};',
				],
			]
		);

        $this->end_controls_section();


        // ICON STYLE
        $this->start_controls_section('icon_style',
            [
                'label' => __('Icon', 'adina'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs(
            'icon_styles'
        );

        $this->start_controls_tab(
            'icon_normal_style',
            [
                'label' => esc_html__( 'Normal', 'adina' ),
            ]
        );

        $this->add_control(
            'icon_color',
            [
                'label' => __( 'icon Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .work-process-two__single-icon .inner span, .services-details-page__content-text2-single .icon-box span' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'icon_bg_color',
            [
                'label' => __('Background Color', 'adina'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .work-process-two__single-icon .inner, .services-details-page__content-text2-single .icon-box' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
			'icon_width',
			[
				'label' => esc_html__( 'Size', 'adina' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 58,
				],
				'selectors' => [
					'{{WRAPPER}} .work-process-two__single-icon .inner span' => 'width: {{SIZE}}{{UNIT}};',
				],
                'condition' => [
                    'iconbox_layout' => 'layout-01'
                ],
			]
		);
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'icon_border',
                'selector' => '{{WRAPPER}} .work-process-two__single-icon::before, .services-details-page__content-text2-single .icon-box',
            ]
        );
        $this->add_control(
            'icon_border_radius',
            [
                'label' => esc_html__( 'Border Radius', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'selectors' => [
                    '{{WRAPPER}} .work-process-two__single-icon .inner, .services-details-page__content-text2-single .icon-box' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_tab();


        $this->start_controls_tab(
            'icon_hover_style',
            [
                'label' => esc_html__( 'Hover', 'adina' ),
            ]
        );

        $this->add_control(
            'icon_hover_color',
            [
                'label' => __( 'Icon Hover Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .work-process-two__single:hover .work-process-two__single-icon .inner span, .services-details-page__content-text2-single:hover .icon-box span' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'icon_bg_hover_color',
            [
                'label' => __('Background Color', 'adina'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .work-process-two__single-icon .inner::before, .services-details-page__content-text2-single:hover .icon-box:before' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();
        $this->end_controls_section();

        // Sub Title STYLE
        $this->start_controls_section('sub_title_style',
            [
                'label' => __('Sub Title', 'adina'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'iconbox_layout' => 'layout-01'
                ],
            ]
        );

        $this->add_control(
            'sub_title_colors',
            [
                'label' => __( 'Sub Title Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .work-process-two__single-text h3' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'sub_title_typography',
                'selector' => '{{WRAPPER}} .work-process-two__single-text h3',
            ]
        );
        $this->add_responsive_control(
            'sub_title_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .work-process-two__single-text h3' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'sub_title_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .work-process-two__single-text h3' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        // Title STYLE
        $this->start_controls_section('title_style',
            [
                'label' => __('Title', 'adina'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'iconbox_layout' => 'layout-01'
                ],
            ]
        );

        $this->add_control(
            'title_colors',
            [
                'label' => __( 'Title Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .work-process-two__single-text h2' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'selector' => '{{WRAPPER}} .work-process-two__single-text h2',
            ]
        );
        $this->add_responsive_control(
            'title_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .work-process-two__single-text h2' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'title_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .work-process-two__single-text h2' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        // Content STYLE
        $this->start_controls_section('content_style',
            [
                'label' => __('Content', 'adina'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'content_colors',
            [
                'label' => __( 'Content Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .work-process-two__single-text p, .services-details-page__content-text2-single .text h4' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'content_typography',
                'selector' => '{{WRAPPER}} .work-process-two__single-text p, .services-details-page__content-text2-single .text h4',
            ]
        );
        $this->add_responsive_control(
            'content_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .work-process-two__single-text p, .services-details-page__content-text2-single .text h4' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'content_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .work-process-two__single-text p, .services-details-page__content-text2-single .text h4' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $layout = $settings['iconbox_layout'];

    ?>

        <?php
            if ( $layout) {
                include('iconbox-03/'.$layout.'.php');
            }
        ?> 

    <?php
}
}
$widgets_manager->register(new \Elementor\AdinaIconBoxThree());