<?php
/**
 * Happyden Team Widget.
 *
 *
 * @since 1.0.0
 */

namespace Elementor;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\Widget_Base;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Css_Filter;
use Elementor\Icons_Manager;
use Elementor\Utils;
use Elementor\Repeater;
use Elementor\URL;
use \Elementor\Control_Media;

if (!defined('ABSPATH')) {
    exit;
}
// If this file is called directly, abort.
class AdinaIconBoxTwo extends Widget_Base {
    public function get_name() {
        return 'adina_iconbox';
    }
    public function get_title() {
        return __('IconBox Two', 'adina');
    }
    public function get_icon() {
        return ('eicon-person');
    }
    public function get_categories() {
        return ['adina-addons'];
    }
    public function get_keywords() {
        return ['iconbox', 'choose', 'services', 'features'];
    }
    protected function register_controls() {
        $this->start_controls_section('general_section',
            [
                'label' => __('General ', 'adina'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
			'icon_class',
			[
				'label' => esc_html__( 'Here you can use Fontawsome Class', 'adina' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'icon-global-network', 'adina' ),
				'label_block' => true,
			]
		);

        $this->add_control(
			'icon_title',
			[
				'label' => esc_html__( 'Icon Title', 'adina' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Global Network', 'adina' ),
				'label_block' => true,
			]
		);
        $this->add_control(
			'title_url',
			[
				'label' => esc_html__( 'Title Url', 'adina' ),
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__( '#', 'adina' ),
				'label_block' => true,
			]
		);

        $this->add_control(
			'icon_content',
			[
				'label' => esc_html__( 'Icon Content', 'adina' ),
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'Freight Consolidators connects your business with international hubs across the world such as the USA.', 'adina' ),
				'label_block' => true,
			]
		);

        $this->end_controls_section();

        // ICON BOX STYLE
        $this->start_controls_section('iconbox_style',
            [
                'label' => __('Icon Box', 'adina'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->start_controls_tabs(
            'iconbox_styles'
        );
        $this->start_controls_tab(
            'iconbox_normal_style',
            [
                'label' => esc_html__( 'Normal', 'adina' ),
            ]
        );

        $this->add_control(
            'iconbox_bg_color',
            [
                'label' => __('Background Color', 'adina'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .choose-us-one__single::before' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'iconbox_border',
                'selector' => '{{WRAPPER}} .choose-us-one__single::after',
            ]
        );
        $this->add_control(
            'iconbox_border_radius',
            [
                'label' => esc_html__( 'Border Radius', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'selectors' => [
                    '{{WRAPPER}} .choose-us-one__single::before' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();


        $this->start_controls_tab(
            'iconbox_hover_style',
            [
                'label' => esc_html__( 'Hover', 'adina' ),
            ]
        );

        $this->add_control(
            'iconbox_hover_bg_color',
            [
                'label' => __('Background Color', 'adina'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .choose-us-one__single:hover .choose-us-one__single-overlay-bg, .choose-us-one__single .content-box .title-box .icon-box::before' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'icon_hover_color',
            [
                'label' => __( 'Icon Hover Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .choose-us-one__single:hover .content-box .title-box .icon-box span' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();


        // CONTENT BOX STYLE
        $this->start_controls_section('content_box_style',
            [
                'label' => __('Content Box', 'adina'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'content_box_bg_color',
            [
                'label' => __('Background Color', 'adina'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .choose-us-one__single .content-box:before' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'content_box_readius',
            [
                'label' => __('Content Box Radius', 'adina'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .choose-us-one__single .content-box:before' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();


        // ICON STYLE
        $this->start_controls_section('icon_style',
            [
                'label' => __('Icon', 'adina'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'icon_color',
            [
                'label' => __( 'Icon Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .choose-us-one__single .content-box .title-box .icon-box span' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'icon_bg_color',
            [
                'label' => __('Background Color', 'adina'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .choose-us-one__single .content-box .title-box .icon-box' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'icon_typography',
                'selector' => '{{WRAPPER}} .choose-us-one__single .content-box .title-box .icon-box span',
            ]
        );
        $this->add_responsive_control(
            'icon_readius',
            [
                'label' => __('Icon Radius', 'adina'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .choose-us-one__single .content-box .title-box .icon-box' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        // Title STYLE
        $this->start_controls_section('title_style',
            [
                'label' => __('Title', 'adina'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->start_controls_tabs(
            'title_styles'
        );

        $this->start_controls_tab(
            'iconbox_title_style',
            [
                'label' => esc_html__( 'Normal', 'adina' ),
            ]
        );

        $this->add_control(
            'title_colors',
            [
                'label' => __( 'Title Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .choose-us-one__single .content-box .title-box h3 a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'selector' => '{{WRAPPER}} .choose-us-one__single .content-box .title-box h3',
            ]
        );
        $this->add_responsive_control(
            'title_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .choose-us-one__single .content-box .title-box h3' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'title_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .choose-us-one__single .content-box .title-box h3' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab(
            'title_hover_style',
            [
                'label' => esc_html__( 'Hover', 'adina' ),
            ]
        );

        $this->add_control(
            'title_hover_colors',
            [
                'label' => __( 'Content Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .choose-us-one__single .content-box .title-box h3 a:hover' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();
        $this->end_controls_section();

        // Content STYLE
        $this->start_controls_section('content_style',
            [
                'label' => __('Content', 'adina'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'content_colors',
            [
                'label' => __( 'Content Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .choose-us-one__single .content-box .text-box p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'content_typography',
                'selector' => '{{WRAPPER}} .choose-us-one__single .content-box .text-box p',
            ]
        );
        $this->add_responsive_control(
            'content_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .choose-us-one__single .content-box .text-box p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'content_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .choose-us-one__single .content-box .text-box p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

    }

    protected function render() {
        $settings = $this->get_settings_for_display();
 
        ?>
            
            <div class="choose-us-one__single">
                <div class="choose-us-one__single-overlay-bg"></div>
                <div class="content-box">
                    <div class="title-box">
                        <?php if ( !empty($settings['icon_class']) ) : ?>
                            <div class="icon-box">
                                <span class="<?php echo esc_attr( $settings['icon_class'] ); ?>"></span>
                            </div>
                        <?php endif; ?>
                        <?php if ( !empty($settings['icon_title']) ) : ?>
                            <h3><a href="<?php echo esc_url( $settings['title_url'] ); ?>"><?php echo esc_html( $settings['icon_title'] ); ?></a></h3>
                        <?php endif; ?>
                    </div>
                    <?php if ( !empty($settings['icon_content']) ) : ?>
                        <div class="text-box">
                            <p><?php echo esc_html( $settings['icon_content'] ); ?></p>
                        </div>
                    <?php endif; ?>
                </div>
            </div>

        <?php
    }
}
$widgets_manager->register(new \Elementor\AdinaIconBoxTwo());