<?php
/**
 * Happyden Team Widget.
 *
 *
 * @since 1.0.0
 */
namespace Elementor;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\Widget_Base;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Css_Filter;
use Elementor\Icons_Manager;
use Elementor\Utils;
use Elementor\Repeater;
use Elementor\URL;
use \Elementor\Control_Media;

if (!defined('ABSPATH')) {
    exit;
}
// If this file is called directly, abort.
class AdinaMap extends Widget_Base {
    public function get_name() {
        return 'adina-map';
    }
    public function get_title() {
        return __('Map', 'adina');
    }
    public function get_icon() {
        return ('eicon-person');
    }
    public function get_categories() {
        return ['adina-addons'];
    }
    public function get_keywords() {
        return ['map', 'faq', 'accordion'];
    }

    protected function register_controls() {

        $this->start_controls_section(
            'map_section',
            [
                'label' => __('Map', 'adina'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
			'map_iframe',
			[
				'label' => esc_html__( 'Map Iframe', 'adina' ),
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__( '', 'adina' ),
				'label_block' => true,
			]
		);
        $this->add_control(
			'title',
			[
				'label' => esc_html__( 'Title', 'adina' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Contact With Us', 'adina' ),
				'label_block' => true,
			]
		);
        $map_faq = new Repeater();

        $map_faq->add_control(
            'faq_active',
            [
                'label' => __('Active', 'adina'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'adina'),
                'label_off' => __('No', 'adina'),
                'return_value' => 'yes',
                'default' => '',
            ]
        );
        $map_faq->add_control(
			'faq_title',
			[
				'label' => esc_html__( 'Accordion Title', 'adina' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'New York Office', 'adina' ),
				'label_block' => true,
			]
		);
        $map_faq->add_control(
			'faq_location',
			[
				'label' => esc_html__( 'Location', 'adina' ),
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'Jones Street, New York, USA', 'adina' ),
				'label_block' => true,
			]
		);
        $map_faq->add_control(
			'faq_mail',
			[
				'label' => esc_html__( 'Mail', 'adina' ),
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'Info@example.com', 'adina' ),
				'label_block' => true,
			]
		);
        $map_faq->add_control(
			'faq_nmbr',
			[
				'label' => esc_html__( 'Number', 'adina' ),
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__( '+70 264 566 579', 'adina' ),
				'label_block' => true,
			]
		);
        $map_faq->add_control(
			'mail_link',
			[
				'label' => esc_html__( 'Mail Url', 'adina' ),
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__( '#', 'adina' ),
				'label_block' => true,
			]
		);
        $map_faq->add_control(
			'nmbr_link',
			[
				'label' => esc_html__( 'Number Url', 'adina' ),
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__( '#', 'adina' ),
				'label_block' => true,
			]
		);
        $this->add_control(
			'map_faq',
			[
				'label' => esc_html__( 'Accordion', 'adina' ),
				'type' =>  Controls_Manager::REPEATER,
				'fields' => $map_faq->get_controls(),
				'default' => [
					[
						'faq_title'     => esc_html__( 'New York Office', 'adina' ),
                        'faq_location'  => esc_html__( 'Jones Street, New York, USA', 'adina' ),
                        'faq_mail'      => esc_html__( 'Info@example.com', 'adina' ),
                        'faq_nmbr'      => esc_html__( '+70 264 566 579', 'adina' ),
                        'mail_link'     => esc_html__( '#', 'adina' ),
                        'nmbr_link'     => esc_html__( '#', 'adina' ),
					],
                    [
						'faq_title'     => esc_html__( 'New York Office', 'adina' ),
                        'faq_location'  => esc_html__( 'Jones Street, New York, USA', 'adina' ),
                        'faq_mail'      => esc_html__( 'Info@example.com', 'adina' ),
                        'faq_nmbr'      => esc_html__( '+70 264 566 579', 'adina' ),
                        'mail_link'     => esc_html__( '#', 'adina' ),
                        'nmbr_link'     => esc_html__( '#', 'adina' ),
					],
                    [
						'faq_title'     => esc_html__( 'New York Office', 'adina' ),
                        'faq_location'  => esc_html__( 'Jones Street, New York, USA', 'adina' ),
                        'faq_mail'      => esc_html__( 'Info@example.com', 'adina' ),
                        'faq_nmbr'      => esc_html__( '+70 264 566 579', 'adina' ),
                        'mail_link'     => esc_html__( '#', 'adina' ),
                        'nmbr_link'     => esc_html__( '#', 'adina' ),
					],
				],
			]
		);

        $this->end_controls_section();

        ///////////////////// Map  Styles ///////////////////////////
        $this->start_controls_section(
            'map_styles',
            [
                'label' => __( 'Map Container', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'iframe_height',
            [
                'label'          => __('Map Height', 'adina'),
                'type'           => Controls_Manager::SLIDER,
                'size_units'     => ['px','%','vh'],
                'range'          => [
                    'px' => [
                        'min' => 1,
                        'max' => 1000,
                    ],
					'%'  => [
                        'min' => 1,
                        'max' => 100,
                    ],
                    'vh' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                ],
                'selectors'      => [
                    '{{WRAPPER}} .google-map-one__map' => 'height: {{SIZE}}{{UNIT}} !important;',
                ],
            ]
        );

        $this->end_controls_section();

        ///////////////////// Title  Styles ///////////////////////////
        $this->start_controls_section(
            'title_styles',
            [
                'label' => __( 'Title', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .google-map-one__content .inner-box .title-box h2' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'title_bg_color',
            [
                'label' => __('Background Color', 'adina'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .google-map-one__content .inner-box .title-box' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'selector' => '{{WRAPPER}} .google-map-one__content .inner-box .title-box h2',
			]
		);
        $this->add_responsive_control(
            'title_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .google-map-one__content .inner-box .title-box' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'title_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .google-map-one__content .inner-box .title-box' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        ///////////////////// Faq Title  Styles ///////////////////////////
        $this->start_controls_section(
            'faq_title_styles',
            [
                'label' => __( 'Faq Title', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'faq_title_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .google-map__accrodion .accrodion .accrodion-title h2' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'faq_title_typography',
				'selector' => '{{WRAPPER}} .google-map__accrodion .accrodion .accrodion-title h2',
			]
		);
        $this->add_responsive_control(
            'faq_title_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .google-map__accrodion .accrodion .accrodion-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'faq_title_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .google-map__accrodion .accrodion .accrodion-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        ///////////////////// Text Styles ///////////////////////////
        $this->start_controls_section(
            'text_styles',
            [
                'label' => __( 'Text', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'text_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .accrodion-content-list>li>p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'text_hover_color',
            [
                'label' => __( 'Hover Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .accrodion-content-list>li>p>a:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'text_typography',
				'selector' => '{{WRAPPER}} .accrodion-content-list>li>p',
			]
		);
        $this->add_responsive_control(
            'text_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .accrodion-content-list>li' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'text_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .accrodion-content-list>li' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        ///////////////////// Icon Styles ///////////////////////////
        $this->start_controls_section(
            'icon_styles',
            [
                'label' => __( 'Icon', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'faq_icon_color',
            [
                'label' => __( 'Faq Icon Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .google-map__accrodion .accrodion.active .accrodion-title h2::before' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'text_icon_color',
            [
                'label' => __( 'Text Icon Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .accrodion-content-list>li .icon-box span' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_section();


    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $faqs = $settings[ 'map_faq' ];
        
        ?>

            <section class="google-map-one">
                <div class="container clearfix">
                    <div class="google-map-one__content clearfix">
                        <div class="inner-box">
                            <div class="title-box text-center">
                                <h2><?php echo esc_html( $settings['title'] ); ?></h2>
                            </div>
                            <ul class="accrodion-grp2 google-map__accrodion" data-grp-name="faq-one-accrodion">

                                <!-- Start Google Map Faq Single-->
                                <?php foreach( $faqs as $faq ) :
                                    $active = '';

                                    if($faq['faq_active'] == 'yes'){
                                        $active = 'active';
                                    }else{
                                        $active = '';
                                    }
                                    
                                    ?>

                                    <li class="accrodion <?php echo esc_attr( $active ); ?>">
                                        <div class="accrodion-title">
                                            <h2><?php echo esc_html( $faq['faq_title'] ); ?></h2>
                                        </div>
                                        <div class="accrodion-content">
                                            <div class="inner">
                                                <ul class="accrodion-content-list">
                                                    <li>
                                                        <div class="icon-box">
                                                            <span class="icon-pin"></span>
                                                        </div>
                                                        <p><?php echo esc_html( $faq['faq_location'] ); ?></p>
                                                    </li>

                                                    <li>
                                                        <div class="icon-box">
                                                            <span class="icon-paper-plane"></span>
                                                        </div>
                                                        <p><a href="<?php echo esc_url( $faq['mail_link'] ); ?>"><?php echo esc_html( $faq['faq_mail'] ); ?></a></p>
                                                    </li>

                                                    <li>
                                                        <div class="icon-box">
                                                            <span class="icon-out-call"></span>
                                                        </div>
                                                        <p><a href="<?php echo esc_url( $faq['nmbr_link'] ); ?>"><?php echo esc_html( $faq['faq_nmbr'] ); ?></a></p>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                    </li>
                                <?php endforeach; ?>
                                <!-- End Google Map Faq Single-->
                            </ul>
                        </div>
                    </div>
                </div>

                <iframe
                    src="<?php echo adina_kses( $settings['map_iframe'] ); ?>"
                    class="google-map-one__map" allowfullscreen>
                </iframe>
            </section>

        <?php
    }
}
$widgets_manager->register(new \Elementor\AdinaMap());

