<?php
/**
 * Happyden Team Widget.
 *
 *
 * @since 1.0.0
 */

namespace Elementor;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\Widget_Base;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Css_Filter;
use Elementor\Icons_Manager;
use Elementor\Utils;
use Elementor\Repeater;
use Elementor\URL;
use \Elementor\Control_Media;

if (!defined('ABSPATH')) {
    exit;
}
// If this file is called directly, abort.
class AdinaPricing extends Widget_Base {
    public function get_name() {
        return 'adina_pricing';
    }
    public function get_title() {
        return __('Pricing', 'adina');
    }
    public function get_icon() {
        return ('eicon-person');
    }
    public function get_categories() {
        return ['adina-addons'];
    }
    public function get_keywords() {
        return ['pricing', 'price'];
    }
    protected function register_controls() {

        $this->start_controls_section('general_section',
            [
                'label' => __('Pricing Section', 'adina'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
			'normal_image',
			[
				'label' => esc_html__( 'Image', 'adina' ),
				'type' =>  Controls_Manager::MEDIA,
				'default' => [
					'url' =>  Utils::get_placeholder_image_src(),
				],
			]
		);
        $this->add_control(
			'pricing_title',
			[
				'label' => esc_html__( 'Pricing Title', 'adina' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Roade Freight', 'adina' ),
				'label_block' => true,
			]
		);
        $this->add_control(
			'price_title',
			[
				'label' => esc_html__( 'Price', 'adina' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( '$39', 'adina' ),
				'label_block' => true,
			]
		);
        $this->add_control(
			'transfer_weight',
			[
				'label' => esc_html__( 'Transfer Weight', 'adina' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( '/ 256kg', 'adina' ),
				'label_block' => true,
			]
		);
        ////Pricing services repeter///
        $pricing_repeater = new Repeater();

        $pricing_repeater->add_control(
			'pricing_services_text',
			[
				'label' => esc_html__( 'Services Text', 'adina' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Single Truck', 'adina' ),
				'label_block' => true,
			]
		);
        $this->add_control(
			'adina_pricing_services',
			[
				'label' => esc_html__( 'Pricing Services', 'adina' ),
				'type' =>  Controls_Manager::REPEATER,
				'fields' => $pricing_repeater->get_controls(),
				'default' => [
					[
						'pricing_services_text' => esc_html__( 'Single Truck', 'adina' ),
					],
                    [
						'pricing_services_text' => esc_html__( 'Single Truck', 'adina' ),
					],
                    [
						'pricing_services_text' => esc_html__( 'Single Truck', 'adina' ),
					],
				],
			]
		);
        ////// Button/////////
        $this->add_control(
			'btn_text',
			[
				'label' => esc_html__( 'Button Text', 'adina' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Get a Quote', 'adina' ),
				'label_block' => true,
			]
		);
        $this->add_control(
			'btn_url',
			[
				'label' => esc_html__( 'Button Url', 'adina' ),
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__( '#', 'adina' ),
				'label_block' => true,
			]
		);
        $this->end_controls_section();

           /********* Start Style Controls /*********/

        $this->start_controls_section('Pricing_style',
            [
                'label' => __('Priching Box', 'adina'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        // /////// Box Normal//////////////////////
        $this->start_controls_tabs(
            'style_tabs'
        );
        $this->start_controls_tab(
            'priching_box_normal',
            [
                'label' => esc_html__( 'Normal', 'adina' ),
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'background',
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} .about-two__content-bottom .btn-box .thm-btn:after',
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'normal_text_border',
                'selector' => '{{WRAPPER}} .about-two__content-bottom .btn-box .thm-btn:after',
            ]
        );
        $this->add_control(
            'Normal_text_border_radius',
            [
                'label' => esc_html__( 'Border Radius', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'selectors' => [
                    '{{WRAPPER}} .about-two__content-bottom .btn-box .thm-btn:after' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'box_shadow',
				'selector' => '{{WRAPPER}} .your-class',
			]
		);
        $this->add_responsive_control(
            'normal_text_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .about-two__content-bottom .btn-box .thm-btn:after' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'normal_text_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .about-two__content-bottom .btn-box .thm-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();

        // ////////  Box Hover ///////////////////
        $this->start_controls_tab(
            'priching_box_hover',
            [
                'label' => esc_html__( 'Hover', 'adina' ),
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'hover-background',
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} .pricing-one__single-bg',
            ]
        );
        $this->add_control(
            'hover_box_color',
            [
                'label' => __( 'All Text Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .pricing-one__single:hover .table-content .table-content__top h3, .pricing-one__single:hover .table-content .table-content__top h2, .pricing-one__single:hover .table-content .table-content__top h2 span, .pricing-one__single:hover .table-content ul li p, .pricing-one__single:hover .table-content ul li p span, .pricing-one__single .table-footer .btn-box .thm-btn' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tabs();
        $this->end_controls_section();

        ///////////Pricing title/////////////////////
        $this->start_controls_section(
            '_pricing_title',
            [
                'label' => __( 'Pricing Title', 'tocore' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'pricing_title_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .pricing-one__single .table-content .table-content__top h3' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'pricing_title_typography',
                'selector' => '{{WRAPPER}} .pricing-one__single .table-content .table-content__top h3',
            ]
        );
        $this->add_responsive_control(
            'pricing_title_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .pricing-one__single .table-content .table-content__top h3' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'pricing_title_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .pricing-one__single .table-content .table-content__top h3' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        //////////////Price/////////////////////
        $this->start_controls_section(
            '_price_title',
            [
                'label' => __( 'Price', 'tocore' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'price_title_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .pricing-one__single .table-content .table-content__top h2' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'price_title_typography',
                'selector' => '{{WRAPPER}} .pricing-one__single .table-content .table-content__top h2',
            ]
        );
        $this->add_responsive_control(
            'price_title_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .pricing-one__single .table-content .table-content__top h2' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'price_title_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .pricing-one__single .table-content .table-content__top h2' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        //////////////Transfer Weight/////////////////////
        $this->start_controls_section(
            '_transfer_weight',
            [
                'label' => __( 'Transfer Weight', 'tocore' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'transfer_weight_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .pricing-one__single .table-content .table-content__top h2 span' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'transfer_weight_typography',
                'selector' => '{{WRAPPER}} .pricing-one__single .table-content .table-content__top h2 span',
            ]
        );
        $this->add_responsive_control(
            'transfer_weight_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .pricing-one__single .table-content .table-content__top h2 span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'transfer_weight_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .pricing-one__single .table-content .table-content__top h2 span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        /////////////Pricing services/////////////////////
        $this->start_controls_section(
            '_pricing_services',
            [
                'label' => __( 'Pricing Services', 'tocore' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            '_pricing_services_icon_color',
            [
                'label' => __( 'Services Icon Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .pricing-one__single .table-content ul li p span' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            '_pricing_services_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .pricing-one__single .table-content ul li p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'pricing_services_border',
                'selector' => '{{WRAPPER}} .pricing-one__single .table-content ul li',
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => '_pricing_services_typography',
                'selector' => '{{WRAPPER}} .pricing-one__single .table-content ul li p',
            ]
        );
        $this->add_responsive_control(
            '_pricing_services_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .pricing-one__single .table-content ul li p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            '_pricing_services_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .pricing-one__single .table-content ul li p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        // /////Pricing Button/////////////////
        $this->start_controls_section(
            '_pricing_btnvormal',
            [
                'label' => __( 'Button', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        /////////Button Normal part/////////
        $this->start_controls_tabs(
            'style_tabsss'
        );
        $this->start_controls_tab(
            'pricing_btn_normal',
            [
                'label' => esc_html__( 'Normal', 'adina' ),
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'pricing_btn_normal_background',
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} .pricing-one__single .table-footer .btn-box .thm-btn',
            ]
        );
        $this->add_control(
            'pricing_btn_normal_color',
            [
                'label' => __( 'Text Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .pricing-one__single .table-footer .btn-box .thm-btn' => 'color: {{VALUE}}',
                ],
            ]
        );
       
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'pricing_btn_normal_typography',
                'selector' => '{{WRAPPER}}  .pricing-one__single .table-footer .btn-box .thm-btn',
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'pricing_btn_normal_border',
                'selector' => '{{WRAPPER}} .pricing-one__single .table-footer .btn-box .thm-btn',
            ]
        );
        $this->add_control(
            'pricing_btn_normal_border_radius',
            [
                'label' => esc_html__( 'Border Radius', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'selectors' => [
                    '{{WRAPPER}} .pricing-one__single .table-footer .btn-box .thm-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'pricing_btn_normal_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .pricing-one__single .table-footer .btn-box .thm-btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'pricing_btn_normal_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .pricing-one__single .table-footer .btn-box .thm-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();
            
        
        ////////////// Button Hover part in here ////////////////////////
        $this->start_controls_tab(
            'style_hover_tabsse',
            [
                'label' => esc_html__( 'Hover', 'adina' ),
            ]
        );
        $this->add_control(
            'btn_bg_color',
            [
                'label' => __('Button background Color', 'adina'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .pricing-one__single:hover .table-footer .btn-box .thm-btn' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'p_b_h_color',
            [
                'label' => __( 'Text Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .about-two__content-bottom .btn-box .thm-btn:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'p_b_h_typography',
                'selector' => '{{WRAPPER}} .about-two__content-bottom .btn-box .thm-btn .txt',
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'p_b_h_border',
                'selector' => '{{WRAPPER}} .about-two__content-bottom .btn-box .thm-btn::before',
            ]
        );
        $this->add_control(
            'p_b_h_border_radius',
            [
                'label' => esc_html__( 'Border Radius', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'selectors' => [
                    '{{WRAPPER}} .about-two__content-bottom .btn-box .thm-btn::before' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tabs();
        $this->end_controls_section();
        

    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $pricing = $settings[ 'adina_pricing_services' ];

    ?>

            <!--Start Pricing One -->
            <div class="pricing-one__single text-center">

                <!-- Bacvkground image  -->
                 <div class="pricing-one__single-bg"></div>

                <div class="table-header">
                    <!-- Normal image  -->
                   <?php if( !empty( $settings[ 'normal_image' ]['url'] ) ): ?>
                    <div class="img-box">
                        <img src="<?php echo esc_url( $settings[ 'normal_image' ]['url'] ); ?>" alt="">
                    </div>
                    <?php endif; ?>
                </div>

                <div class="table-content">
                    <div class="table-content__top">
                        <!-- Pricing title -->
                        <?php if( !empty( $settings[ 'pricing_title' ] ) ): ?>
                          <h3><?php echo adina_kses( $settings[ 'pricing_title' ] ); ?></h3>
                        <?php endif; ?>

                        <!-- price -->
                        <?php if( !empty( $settings[ 'price_title' ] ) ): ?>
                          <h2><?php echo adina_kses( $settings[ 'price_title' ] ); ?><span><?php echo adina_kses( $settings[ 'transfer_weight' ] ); ?></span></h2>
                        <?php endif; ?>
                    </div>

                    <ul>
                        <!-- foreach loop -->
                       <?php foreach( $pricing as $price  ):
                        
                        ?>
                        <li>
                            <?php if( !empty( $price[ 'pricing_services_text' ] ) ): ?>
                             <p><span class="icon-check"></span><?php echo adina_kses( $price[ 'pricing_services_text' ] ); ?></p>
                            <?php endif; ?>
                        </li>
                        <?php endforeach; ?>
                    </ul>
                </div>
                <!-- Button -->
                <div class="table-footer">
                    <div class="btn-box">
                        <a class="thm-btn" href="<?php echo esc_url( $settings['btn_url'] ); ?>">
                            <span class="txt"><?php echo adina_kses( $settings[ 'btn_text' ] ); ?></span> <i class="icon-right-arrow"></i>
                        </a>
                    </div>
                </div>
            </div>

                    <!--End Pricing One Single-->











        


    <?php
}
}
$widgets_manager->register(new \Elementor\AdinaPricing());