<?php
/**
 * Happyden Team Widget.
 *
 *
 * @since 1.0.0
 */

namespace Elementor;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\Widget_Base;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Css_Filter;
use Elementor\Icons_Manager;
use Elementor\Utils;
use Elementor\Repeater;
use Elementor\URL;
use \Elementor\Control_Media;

if (!defined('ABSPATH')) {
    exit;
}
// If this file is called directly, abort.
class AdinaProgressBar extends Widget_Base {
    public function get_name() {
        return 'adina_progress_bar';
    }
    public function get_title() {
        return __('Progress Bar', 'adina');
    }
    public function get_icon() {
        return ('eicon-person');
    }
    public function get_categories() {
        return ['adina-addons'];
    }
    public function get_keywords() {
        return ['bar', 'progress'];
    }
    protected function register_controls() {

        $this->start_controls_section('general_section',
            [
                'label' => __('General ', 'adina'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
			'progress_title',
			[
				'label' => esc_html__( 'Title', 'adina' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Success Rate 90%', 'adina' ),
				'label_block' => true,
			]
		);
        $this->add_control(
			'success_rate',
			[
				'label' => esc_html__( 'Success Rate', 'adina' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( '90%', 'adina' ),
				'label_block' => true,
			]
		);

        $this->end_controls_section();


        ///////////////////// Title  Styles ///////////////////////////
        $this->start_controls_section(
            'title_styles',
            [
                'label' => __( 'Title', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'title_colors',
            [
                'label' => __( 'Title Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .why-choose-two__progress-single .title h4' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'selector' => '{{WRAPPER}} .why-choose-two__progress-single .title h4',
            ]
        );
        $this->add_responsive_control(
            'title_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .why-choose-two__progress-single .title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'title_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .why-choose-two__progress-single .title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();


        ///////////////////// Progress Bar  Styles ///////////////////////////
        $this->start_controls_section(
            'bar_styles',
            [
                'label' => __( 'Progress Bar', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'bar_bg_color',
            [
                'label' => __('Background Color', 'adina'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .why-choose-two__progress .bar-inner' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'bar_typography',
                'selector' => '{{WRAPPER}} .why-choose-two__progress-single .title h4',
            ]
        );
        $this->add_responsive_control(
            'bar_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .why-choose-two__progress .bar' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'bar_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .why-choose-two__progress .bar' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();


        ///////////////////// Success Rate  Styles ///////////////////////////
        $this->start_controls_section(
            'rate_styles',
            [
                'label' => __( 'Success Rate', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'rate_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .why-choose-two__progress .count-text' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'rate_typography',
                'selector' => '{{WRAPPER}} .why-choose-two__progress .count-text',
            ]
        );

        $this->end_controls_section();


        

    }

    protected function render() {
        $settings = $this->get_settings_for_display();

        ?>

            <div class="why-choose-two__progress">
                <div class="why-choose-two__progress-single">
                    <div class="title">
                        <h4><?php echo esc_html( $settings['progress_title']); ?></h4>
                    </div>
                    <div class="bar">
                        <div class="bar-inner count-bar" data-percent="90%">
                            <div class="count-text"><?php echo esc_html( $settings['success_rate']); ?></div>
                        </div>
                    </div>
                </div>
            </div>

        <?php
    }
}
$widgets_manager->register(new \Elementor\AdinaProgressBar());
