<?php
/**
 * Happyden Team Widget.
 *
 *
 * @since 1.0.0
 */

namespace Elementor;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\Widget_Base;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Css_Filter;
use Elementor\Icons_Manager;
use Elementor\Utils;
use Elementor\Repeater;
use Elementor\URL;
use \Elementor\Control_Media;

if (!defined('ABSPATH')) {
    exit;
}
// If this file is called directly, abort.
class AdinaProjectInfo extends Widget_Base {
    public function get_name() {
        return 'adina_project_info';
    }
    public function get_title() {
        return __('Project Info', 'adina');
    }
    public function get_icon() {
        return ('eicon-person');
    }
    public function get_categories() {
        return ['adina-addons'];
    }
    public function get_keywords() {
        return ['project', 'info', 'side-info'];
    }
    protected function register_controls() {

        $this->start_controls_section(
            'project_info',
            [
                'label' => __('Project Info', 'adina'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
        $project_info_repeater = new Repeater();

        $project_info_repeater->add_control(
			'info_title',
			[
				'label' => esc_html__( 'Title', 'adina' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Client', 'adina' ),
				'label_block' => true,
			]
		);
        $project_info_repeater->add_control(
			'info_text',
			[
				'label' => esc_html__( 'Text', 'adina' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Rebecca Tylor', 'adina' ),
				'label_block' => true,
			]
		);
        $this->add_control(
			'info_controls',
			[
				'label' => esc_html__( 'info list', 'adina' ),
				'type' =>  Controls_Manager::REPEATER,
				'fields' => $project_info_repeater->get_controls(),
				'default' => [
					[
						'info_title'        => esc_html__( 'Client', 'adina' ),
						'info_text'  => esc_html__( 'Rebecca Tylor', 'adina' ),
					],
                    [
						'info_title'        => esc_html__( 'Client', 'adina' ),
						'info_text'  => esc_html__( 'Rebecca Tylor', 'adina' ),
					],
                    [
						'info_title'        => esc_html__( 'Client', 'adina' ),
						'info_text'  => esc_html__( 'Rebecca Tylor', 'adina' ),
					],
				],
			]
		);
        $this->end_controls_section();

        $this->start_controls_section('title_style',
            [
                'label' => __('Title', 'adina'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'title_colors',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .project-details__sidebar-project-info ul li .title-box p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'selector' => '{{WRAPPER}} .project-details__sidebar-project-info ul li .title-box p',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section('text_style',
            [
                'label' => __('Text', 'adina'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'text_colors',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .project-details__sidebar-project-info ul li .text-box p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'text_typography',
                'selector' => '{{WRAPPER}} .project-details__sidebar-project-info ul li .text-box p',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section('box_style',
            [
                'label' => __('List Box', 'adina'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'box_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .project-details__sidebar-project-info ul li' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'box_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .project-details__sidebar-project-info ul li' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();
        
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $lists = $settings[ 'info_controls' ];

    ?>
        <div class="project-details__sidebar-project-info">
            <ul>
                <?php foreach( $lists as $list ): ?>
                    <li>
                        <div class="title-box">
                            <p><?php echo adina_kses( $list['info_title'] ); ?></p>
                        </div>
                        <div class="text-box">
                            <p><?php echo esc_html( $list['info_text'] ); ?></p>
                        </div>
                    </li>
                <?php endforeach; ?>
            </ul>
        </div>

    <?php
}
}
$widgets_manager->register(new \Elementor\AdinaProjectInfo());