<?php
/**
 * Happyden project Widget.
 *
 *
 * @since 1.0.0
 */
namespace Elementor;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\Widget_Base;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Css_Filter;
use Elementor\Icons_Manager;
use Elementor\Utils;
use Elementor\Repeater;
use Elementor\URL;
use \Elementor\Control_Media;

if (!defined('ABSPATH')) {
    exit;
}
// If this file is called directly, abort.
class AdinaProject extends Widget_Base {
    public function get_name() {
        return 'adina-project';
    }
    public function get_title() {
        return __('Project', 'adina');
    }
    public function get_icon() {
        return ('eicon-person');
    }
    public function get_categories() {
        return ['adina-addons'];
    }
    public function get_keywords() {
        return ['project', 'Slider', 'projects'];
    }

    protected function register_controls() {

        $this->start_controls_section(
            'project_settings',
            [
                'label' => __('Project Settings', 'adina'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'show_slider_settings',
            [
                'label' => __('Slider Active', 'adina'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'adina'),
                'label_off' => __('No', 'adina'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );


        $this->add_responsive_control('per_line', [
            'label'              => __('Columns per row', 'adina'),
            'type'               => Controls_Manager::SELECT,
            'default'            => '3',
            'tablet_default'     => '6',
            'mobile_default'     => '12',
            'options'            => [
                '12' => '1',
                '6'  => '2',
                '4'  => '3',
                '3'  => '4',
            ],
            'frontend_available' => true,
            'condition'   => [ 'show_slider_settings' => '', ]
        ]);


        $this->add_responsive_control(
            'gap_bottom',
            [
                'label'          => __('Gap Bottom', 'adina'),
                'type'           => Controls_Manager::SLIDER,
                'size_units'     => ['px', '%'],
                'range'          => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors'      => [
                    '{{WRAPPER}} .project-one__single, .project-two__single, .project-three__single' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        //Slider Setting
        $this->start_controls_section('slider_settings',
        [
            'label' => __('Slider Settings', 'adina'),
            'tab'   => Controls_Manager::TAB_CONTENT,
            'condition' => [ 'show_slider_settings' => 'yes',  ]
            ]
        );

        $this->add_responsive_control(
            'per_coulmn',
            [
                'label' => __( 'Slider Items', 'adina' ),
                'type' => Controls_Manager::SELECT,
                'default'            => 3,
                'tablet_default'     => 2,
                'mobile_default'     => 1,
                'options'            => [
                    '1' => '1',
                    '2' => '2',
                    '3' => '3',
                    '4' => '4',
                    '5' => '5',
                    '6' => '6',
                ],
                'frontend_available' => true,
            ]
        );
        $this->add_responsive_control(
			'gap_right_left',
			[
				'label'          => __('Row Gap(Right-Left)', 'adina'),
				'type'           => Controls_Manager::SLIDER,
				'size_units'     => ['px', '%'],
				'range'          => [
					'px' => [
						'min' => 0,
						'max' => 1000,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors'      => [
					'{{WRAPPER}} .project-one__single, .project-two__single, .project-three__single' => 'margin-right: {{SIZE}}{{UNIT}}; margin-left: {{SIZE}}{{UNIT}};',
				],
			]
		);
        $this->add_control(
            'dots',
            [
                'label' => __( 'Dots?', 'adina' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'adina' ),
                'label_off' => __( 'Hide', 'adina' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'drag',
            [
                'label' => __( 'Drag?', 'adina' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'adina' ),
                'label_off' => __( 'Hide', 'adina' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'autoplay',
            [
                'label' => __( 'Auto Play?', 'adina' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'adina' ),
                'label_off' => __( 'Hide', 'adina' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'autoplaytimeout',
            [
                'label' => __( 'Autoplay Timeout', 'adina' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'label_block' => true,
                'default' => '5000',
                'options' => [
                    '1000'  => __( '1 Second', 'adina' ),
                    '2000'  => __( '2 Second', 'adina' ),
                    '3000'  => __( '3 Second', 'adina' ),
                    '4000'  => __( '4 Second', 'adina' ),
                    '5000'  => __( '5 Second', 'adina' ),
                    '6000'  => __( '6 Second', 'adina' ),
                    '7000'  => __( '7 Second', 'adina' ),
                    '8000'  => __( '8 Second', 'adina' ),
                    '9000'  => __( '9 Second', 'adina' ),
                    '10000' => __( '10 Second', 'adina' ),
                    '11000' => __( '11 Second', 'adina' ),
                    '12000' => __( '12 Second', 'adina' ),
                    '13000' => __( '13 Second', 'adina' ),
                    '14000' => __( '14 Second', 'adina' ),
                    '15000' => __( '15 Second', 'adina' ),
                ],
                'condition' => [
                    'autoplay' => 'yes',
                ],
            ]
        );
        $this->end_controls_section();
		// End Slider settings

        // Start Project Section
        $this->start_controls_section(
            'project_content',
            [
                'label' => __('Project Section', 'adina'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'project_layout',
            [
                'label' => esc_html__('Select Layout', 'adina'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'layout-1' => esc_html__('Layout 1', 'adina'),
                    'layout-2' => esc_html__('Layout 2', 'adina'),
                    'layout-3' => esc_html__('Layout 3', 'adina'),
                ],
                'default' => 'layout-1',
            ]
        );
        $project_repeater = new Repeater();

        $project_repeater->add_control(
			'project_image',
			[
				'label' => esc_html__( 'Image', 'adina' ),
				'type' =>  Controls_Manager::MEDIA,
				'default' => [
					'url' =>  Utils::get_placeholder_image_src(),
				],
			]
		);
        $project_repeater->add_control(
			'icon',
			[
				'label' => esc_html__( 'Use Fontawsome or Icomoon class(use layout 2 & 3)', 'adina' ),
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'icon-right-arrow-5', 'adina' ),
				'label_block' => true,
			]
		);
        $project_repeater->add_control(
			'project_no',
			[
				'label' => esc_html__( 'Project Number', 'adina' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'N.01', 'adina' ),
				'label_block' => true,
			]
		);
        $project_repeater->add_control(
			'project_subtitle',
			[
				'label' => esc_html__( 'SubTitle', 'adina' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Large Warehouse', 'adina' ),
				'label_block' => true,
			]
		);
        $project_repeater->add_control(
			'project_title',
			[
				'label' => esc_html__( 'Title', 'adina' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Warehouse & Services', 'adina' ),
				'label_block' => true,
			]
		);
        $project_repeater->add_control(
			'project_text',
			[
				'label' => esc_html__( 'Content', 'adina' ),
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'Freight Consolidators connects your business with international.', 'adina' ),
				'label_block' => true,
			]
		);
        $project_repeater->add_control(
			'project_btn',
			[
				'label' => esc_html__( 'Button Text', 'adina' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'View Details', 'adina' ),
				'label_block' => true,
			]
		);
        $project_repeater->add_control(
			'project_link',
			[
				'label' => esc_html__( 'Details Link', 'adina' ),
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__( '#', 'adina' ),
				'label_block' => true,
			]
		);

        $this->add_control(
			'project_slides',
			[
				'label' => esc_html__( 'project List', 'adina' ),
				'type' =>  Controls_Manager::REPEATER,
				'fields' => $project_repeater->get_controls(),
				'default' => [
					[
                        'project_image'    => Utils::get_placeholder_image_src(),
						'icon'             => esc_html__( 'icon-right-arrow-5', 'adina' ),
						'project_no'       => esc_html__( 'N.01', 'adina' ),
                        'project_subtitle' => esc_html__( 'Large Warehouse', 'adina' ),
                        'project_title'    => esc_html__( 'Warehouse & Services', 'adina' ),
                        'project_text'     => esc_html__( 'Freight Consolidators connects your business with international.', 'adina' ),
                        'project_btn'      => esc_html__( 'View Details', 'adina' ),
                        'project_link'     => esc_html__( '#', 'adina' ),

					],
                    [
                        'project_image'    => Utils::get_placeholder_image_src(),
						'icon'             => esc_html__( 'icon-right-arrow-5', 'adina' ),
						'project_no'       => esc_html__( 'N.01', 'adina' ),
                        'project_subtitle' => esc_html__( 'Large Warehouse', 'adina' ),
                        'project_title'    => esc_html__( 'Warehouse & Services', 'adina' ),
                        'project_text'     => esc_html__( 'Freight Consolidators connects your business with international.', 'adina' ),
                        'project_btn'      => esc_html__( 'View Details', 'adina' ),
                        'project_link'     => esc_html__( '#', 'adina' ),

					],
                    [
                        'project_image'    => Utils::get_placeholder_image_src(),
						'icon'             => esc_html__( 'icon-right-arrow-5', 'adina' ),
						'project_no'       => esc_html__( 'N.01', 'adina' ),
                        'project_subtitle' => esc_html__( 'Large Warehouse', 'adina' ),
                        'project_title'    => esc_html__( 'Warehouse & Services', 'adina' ),
                        'project_text'     => esc_html__( 'Freight Consolidators connects your business with international.', 'adina' ),
                        'project_btn'      => esc_html__( 'View Details', 'adina' ),
                        'project_link'     => esc_html__( '#', 'adina' ),

					],
				],
			]
		);

        $this->end_controls_section();

        /********* Image Style *********/
        $this->start_controls_section(
            'project_img_style',
            [
                'label' => __( 'Image', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'width',
            [
                'label'          => __('Width', 'adina'),
                'type'           => Controls_Manager::SLIDER,
                'size_units'     => ['%', 'px','vw'],
                'range'          => [
                    '%'  => [
                        'min' => 1,
                        'max' => 100,
                    ],
                    'px' => [
                        'min' => 1,
                        'max' => 1000,
                    ],
                    'vw' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                ],
                'selectors'      => [
                    '{{WRAPPER}} .project-one__single-img .inner img, .project-two__single-img .inner img, .project-three__single-img .inner img' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'height',
            [
                'label'          => __('Height', 'adina'),
                'type'           => Controls_Manager::SLIDER,
                'size_units'     => ['px','%','vh'],
                'range'          => [
                    'px' => [
                        'min' => 1,
                        'max' => 1000,
                    ],
					'%'  => [
                        'min' => 1,
                        'max' => 100,
                    ],
                    'vh' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                ],
                'selectors'      => [
                    '{{WRAPPER}} .project-one__single-img .inner img, .project-two__single-img .inner img, .project-three__single-img .inner img' => 'height: {{SIZE}}{{UNIT}} !important;',
                ],
            ]
        );
        $this->add_responsive_control(
            'img_object-fit',
            [
                'label'     => __('Object Fit', 'adina'),
                'type'      => Controls_Manager::SELECT,
                'condition' => [
                    'height[size]!' => '',
                ],
                'options'   => [
                    ''        => __('Default', 'adina'),
                    'fill'    => __('Fill', 'adina'),
                    'cover'   => __('Cover', 'adina'),
                    'contain' => __('Contain', 'adina'),
                ],
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .project-one__single-img .inner img, .project-two__single-img .inner img, .project-three__single-img .inner img' => 'object-fit: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'img_object-position',
            [
                'label'     => __('Object Position', 'adina'),
                'type'      => Controls_Manager::SELECT,
                'condition' => [
                    'height[size]!' => '',
                ],
                'options'   => [
                    ''        => __('Default', 'adina'),
                    'center top' => __('Center Top', 'adina'),
                    'center bottom'   => __('Center Bottom', 'adina'),
                    'center left' => __('Center Left', 'adina'),
                    'center right' => __('Center Right', 'adina'),
                ],
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .project-one__single-img .inner img, .project-two__single-img .inner img, .project-three__single-img .inner img' => 'object-position: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        /********* Icon Style *********/
        $this->start_controls_section(
            'icon_style',
            [
                'label' => __( 'Icon', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'project_layout' => [
                        'layout-2',
                        'layout-3'
                    ]
                ],
            ]
        );
        $this->start_controls_tabs(
            'icon_style_tabs'
        );

        $this->start_controls_tab(
            'icon_normal_tab',
            [
                'label' => esc_html__( 'Normal', 'adina' ),
            ]
        );

        $this->add_control(
            'icon_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .project-two__single-img .inner .btn-box a, .project-three__single-img .inner .overlay-content .icon-box a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'icon_bg_color',
            [
                'label' => __('Background Color', 'adina'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .project-two__single-img .inner .btn-box a, .project-three__single-img .inner .overlay-content .icon-box a' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'icon_radius',
            [
                'label' => esc_html__( 'Border Radius', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'selectors' => [
                    '{{WRAPPER}} .project-two__single-img .inner .btn-box a, .project-three__single-img .inner .overlay-content .icon-box a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'icon_width',
            [
                'label'          => __('Width', 'adina'),
                'type'           => Controls_Manager::SLIDER,
                'size_units'     => ['%', 'px','vw'],
                'range'          => [
                    '%'  => [
                        'min' => 1,
                        'max' => 100,
                    ],
                    'px' => [
                        'min' => 1,
                        'max' => 1000,
                    ],
                    'vw' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                ],
                'selectors'      => [
                    '{{WRAPPER}} .project-two__single-img .inner .btn-box a, .project-three__single-img .inner .overlay-content .icon-box a' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'icon_height',
            [
                'label'          => __('Height', 'adina'),
                'type'           => Controls_Manager::SLIDER,
                'size_units'     => ['px', 'vh'],
                'range'          => [
                    'px' => [
                        'min' => 1,
                        'max' => 1000,
                    ],
                    'vh' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                ],
                'selectors'      => [
                    '{{WRAPPER}} .project-two__single-img .inner .btn-box a, .project-three__single-img .inner .overlay-content .icon-box a' => 'height: {{SIZE}}{{UNIT}} !important;',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'icon_hover_tab',
            [
                'label' => esc_html__( 'Hover', 'adina' ),
            ]
        );

        $this->add_control(
            'icon_hover_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .project-two__single-img .inner .btn-box a:hover, .project-three__single-img .inner .overlay-content .icon-box a:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'icon_hover_bg_color',
            [
                'label' => __('Background Color', 'adina'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .project-two__single-img .inner .btn-box a:hover, .project-three__single-img .inner .overlay-content .icon-box a:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();


        /********* NO. Style *********/
        $this->start_controls_section(
            'project_no_style',
            [
                'label' => __( 'Number', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'project_layout' => 'layout-1',
                ],
            ]
        );

        $this->add_control(
            'no_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .project-one__single-img .overlay-box span' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'no_bg_color',
            [
                'label' => __('Background Color', 'adina'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .project-one__single-img .overlay-box' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'no_typography',
				'selector' => '{{WRAPPER}} .project-one__single-img .overlay-box span',
			]
		);

        $this->end_controls_section();

        /********* Subtitle Style *********/
        $this->start_controls_section(
            'subtitle_style',
            [
                'label' => __( 'Subtitle', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'subtitle_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .project-one__single-content .categories, .project-two__single-img .inner .overlay-content p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'subtitle_typography',
				'selector' => '{{WRAPPER}} .project-one__single-content .categories, .project-two__single-img .inner .overlay-content p',
			]
		);
        $this->add_responsive_control(
            'subtitle_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .project-one__single-content .categories, .project-two__single-img .inner .overlay-content p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'subtitle_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .project-one__single-content .categories, .project-two__single-img .inner .overlay-content p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        /********* Title Style *********/
        $this->start_controls_section(
            'title_style',
            [
                'label' => __( 'Title', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->start_controls_tabs(
            'title_style_tabs'
        );

        $this->start_controls_tab(
            'title_normal_tab',
            [
                'label' => esc_html__( 'Normal', 'adina' ),
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .project-one__single-content h3 a, .project-two__single-img .inner .overlay-content h2 a, .project-three__single-img .inner .overlay-content .text-box h2 a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'selector' => '{{WRAPPER}} .project-one__single-content h3, .project-two__single-img .inner .overlay-content h2, .project-three__single-img .inner .overlay-content .text-box h2',
			]
		);
        $this->add_responsive_control(
            'title_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .project-one__single-content h3, .project-two__single-img .inner .overlay-content h2, .project-three__single-img .inner .overlay-content .text-box h2' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'title_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .project-one__single-content h3, .project-two__single-img .inner .overlay-content h2, .project-three__single-img .inner .overlay-content .text-box h2' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'title_hover_tab',
            [
                'label' => esc_html__( 'Hover', 'adina' ),
            ]
        );

        $this->add_control(
            'title_hover_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .project-one__single-content h3 a:hover, .project-two__single-img .inner .overlay-content h2 a:hover, .project-three__single-img .inner .overlay-content .text-box h2 a:hover' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();

        /********* Text Style *********/
        $this->start_controls_section(
            'text_style',
            [
                'label' => __( 'Content', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'project_layout' => 'layout-1',
                ],
            ]
        );

        $this->add_control(
            'text_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .project-one__single-content-bottom .text-box p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'text_typography',
				'selector' => '{{WRAPPER}} .project-one__single-content-bottom .text-box p',
			]
		);
        $this->add_responsive_control(
            'text_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .project-one__single-content-bottom .text-box p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'text_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .project-one__single-content-bottom .text-box p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        /********* Button Style *********/
        $this->start_controls_section(
            'btn_style',
            [
                'label' => __( 'Button', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'project_layout' => 'layout-1',
                ],
            ]
        );
        $this->start_controls_tabs(
            'btn_style_tabs'
        );

        $this->start_controls_tab(
            'btn_normal_tab',
            [
                'label' => esc_html__( 'Normal', 'adina' ),
            ]
        );

        $this->add_control(
            'btn_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .project-one__single-content-bottom .btn-box .thm-btn' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'btn_bg_color',
            [
                'label' => __('Background Color', 'adina'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .project-one__single-content-bottom .btn-box .thm-btn:after' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'btn_typography',
				'selector' => '{{WRAPPER}} .project-one__single-content-bottom .btn-box .thm-btn',
			]
		);
        $this->add_responsive_control(
            'btn_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .project-one__single-content-bottom .btn-box' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'btn_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .project-one__single-content-bottom .btn-box .thm-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();

        $this->start_controls_tab(
            'btn_hover_tab',
            [
                'label' => esc_html__( 'Hover', 'adina' ),
            ]
        );

        $this->add_control(
            'btn__hover_bg_color',
            [
                'label' => __('Background Color', 'adina'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .project-one__single-content-bottom .btn-box .thm-btn::before' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();

        /********* Content Box Style *********/
        $this->start_controls_section(
            'content_box_style',
            [
                'label' => __( 'Content Box', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'project_layout' => [
                        'layout-1',
                        'layout-3'
                    ]
                ],
            ]
        );
        $this->start_controls_tabs(
            'content_box_style_tabs'
        );
        $this->start_controls_tab(
            'content_box_normal_tab',
            [
                'label' => esc_html__( 'Normal', 'adina' ),
            ]
        );

        $this->add_control(
            'content_box_bg_color',
            [
                'label' => __('Background Color', 'adina'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .project-one__single-content::before, .project-three__single-img .inner .overlay-content' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'content_box_border',
                'selector' => '{{WRAPPER}} .project-one__single-content::after, .project-three__single-img .inner .overlay-content',
            ]
        );
        $this->add_control(
            'content_box_radius',
            [
                'label' => esc_html__( 'Border Radius', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'selectors' => [
                    '{{WRAPPER}} .project-one__single-content::after, .project-three__single-img .inner .overlay-content' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'content_box_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .project-one__single-content, .project-three__single-img .inner .overlay-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'content_box_hover_tab',
            [
                'label' => esc_html__( 'Hover', 'adina' ),
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'content_box_hover_border',
                'selector' => '{{WRAPPER}} .project-one__single:hover .project-one__single-content::after, .project-three__single-img .inner .overlay-content:hover',
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();

        /********* Box Style *********/
        $this->start_controls_section(
            'box_style',
            [
                'label' => __( 'Box', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'project_layout' => 'layout-1',
                ],
            ]
        );
        $this->start_controls_tabs(
            'box_style_tabs'
        );
        $this->start_controls_tab(
            'box_normal_tab',
            [
                'label' => esc_html__( 'Normal', 'adina' ),
            ]
        );
        $this->add_control(
            'box_bg_color',
            [
                'label' => __('Background Color', 'adina'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .project-one__single::before' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();

        $this->start_controls_tab(
            'box_hover_tab',
            [
                'label' => esc_html__( 'Hover', 'adina' ),
            ]
        );
        $this->add_control(
            'box_hover_bg_color',
            [
                'label' => __('Background Color', 'adina'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .project-one__single-overlay-bg' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
        
    }

    protected function render() {
        $settings = $this->get_settings_for_display();

        //this code course slider option
		$slider_extraSetting = array(
	        'autoplay' => (!empty($settings['autoplay']) && 'yes' === $settings['autoplay']) ? true : false,
            'drag' => (!empty($settings['drag']) && 'yes' === $settings['drag']) ? true : false,
            'dots' => (!empty($settings['dots']) && 'yes' === $settings['dots']) ? true : false,
        	'autoplaytimeout' => !empty($settings['autoplaytimeout']) ? $settings['autoplaytimeout'] : '5000',

        	//this a responsive layout
            'per_coulmn' =>        (!empty($settings['per_coulmn'])) ? $settings['per_coulmn'] : 3,
            'per_coulmn_tablet' => (!empty($settings['per_coulmn_tablet'])) ? $settings['per_coulmn_tablet'] : 2,
            'per_coulmn_mobile' => (!empty($settings['per_coulmn_mobile'])) ? $settings['per_coulmn_mobile'] : 1
        );
		$jasondecode = wp_json_encode($slider_extraSetting);

        if ( ( 'yes' == $settings['show_slider_settings'] ) ) {
            $this->add_render_attribute('project_version', 'class', ['row project-slider']);
            $this->add_render_attribute('project_version', 'data-settings', $jasondecode);
            $this->add_render_attribute('project_gride_classes', 'class', ['item']);
        } else {
            $this->add_render_attribute('project_version', 'class', ['row']);
            //gride class
            $grid_classes = [];
            $grid_classes[] = 'col-xl-' . $settings['per_line'];
            $grid_classes[] = 'col-md-' . $settings['per_line_tablet'];
            $grid_classes[] = 'col-sm-' . $settings['per_line_mobile'];
            $grid_classes = implode(' ', $grid_classes);
            $this->add_render_attribute('project_gride_classes', 'class', [$grid_classes]);
        }

        $layout = $settings['project_layout'];
        $slides = $settings[ 'project_slides' ];
        
        ?>       

            <?php
                if ( $layout) {
                    include('project/'.$layout.'.php');
                }
            ?> 

        <?php
    }
}
$widgets_manager->register(new \Elementor\Adinaproject());

