<?php
/**
 * Happyden Team Widget.
 *
 *
 * @since 1.0.0
 */

namespace Elementor;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\Widget_Base;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Css_Filter;
use Elementor\Icons_Manager;
use Elementor\Utils;
use Elementor\Repeater;
use Elementor\URL;
use \Elementor\Control_Media;

if (!defined('ABSPATH')) {
    exit;
}
// If this file is called directly, abort.
class AdinaServiceList extends Widget_Base {
    public function get_name() {
        return 'adina_service_list';
    }
    public function get_title() {
        return __('Service List', 'adina');
    }
    public function get_icon() {
        return ('eicon-person');
    }
    public function get_categories() {
        return ['adina-addons'];
    }
    public function get_keywords() {
        return ['list', 'service', 'button'];
    }
    protected function register_controls() {

        $this->start_controls_section('general_section',
            [
                'label' => __('General ', 'adina'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
        $list_repeater = new Repeater();

        $list_repeater->add_control(
            'list_active',
            [
                'label' => __('Active', 'adina'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'adina'),
                'label_off' => __('No', 'adina'),
                'return_value' => 'yes',
                'default' => '',
            ]
        );
        $list_repeater->add_control(
			'service_name',
			[
				'label' => esc_html__( 'Service Name', 'adina' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Road Transport', 'adina' ),
				'label_block' => true,
			]
		);
        $list_repeater->add_control(
			'btn_url',
			[
				'label' => esc_html__( 'Url', 'adina' ),
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__( '#', 'adina' ),
				'label_block' => true,
			]
		);
        $this->add_control(
			'list_repeater',
			[
				'label' => esc_html__( 'Service List', 'adina' ),
				'type' =>  Controls_Manager::REPEATER,
				'fields' => $list_repeater->get_controls(),
				'default' => [
					[
						'service_name'   => esc_html__( 'Road Transport', 'adina' ),
                        'btn_url'        => esc_html__( '#', 'adina' ),
					],
                    [
						'service_name'   => esc_html__( 'Air Transport', 'adina' ),
                        'btn_url'        => esc_html__( '#', 'adina' ),
					],
                    [
						'service_name'   => esc_html__( 'Cargo Transport', 'adina' ),
                        'btn_url'        => esc_html__( '#', 'adina' ),
					],
                    [
						'service_name'   => esc_html__( 'Ocean Freight', 'adina' ),
                        'btn_url'        => esc_html__( '#', 'adina' ),
					],
                    [
						'service_name'   => esc_html__( 'Rail Transport', 'adina' ),
                        'btn_url'        => esc_html__( '#', 'adina' ),
					],
                    [
						'service_name'   => esc_html__( 'Warehousing', 'adina' ),
                        'btn_url'        => esc_html__( '#', 'adina' ),
					],
				],
			]
		);

        $this->end_controls_section();

        // Text STYLE
        $this->start_controls_section('text_style',
            [
                'label' => __('Text', 'adina'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'text_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .sidebar__services-list li a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'text_typography',
                'selector' => '{{WRAPPER}} .sidebar__services-list li a',
            ]
        );

        $this->end_controls_section();

        // Icon STYLE
        $this->start_controls_section('icon_style',
            [
                'label' => __('Icon', 'adina'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'icon_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .sidebar__services-list li a span' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'icon_bg_color',
            [
                'label' => __('Background Color', 'adina'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .sidebar__services-list li a span' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'active_icon_color',
            [
                'label' => __( 'Active Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .sidebar__services-list:hover .btn-box a span, .sidebar__services-list.active .btn-box a span' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'active_icon_bg_color',
            [
                'label' => __('Active Background Color', 'adina'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .sidebar__services-list:hover .btn-box a, .sidebar__services-list.active .btn-box a' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'icon_border',
                'selector' => '{{WRAPPER}} .sidebar__services-list li a span',
            ]
        );
        $this->add_responsive_control(
            'icon_radius',
            [
                'label' => __('Radius', 'adina'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .sidebar__services-list li a span' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'icon_width',
            [
                'label'          => __('Width', 'adina'),
                'type'           => Controls_Manager::SLIDER,
                'size_units'     => ['%', 'px','vw'],
                'range'          => [
                    '%'  => [
                        'min' => 1,
                        'max' => 100,
                    ],
                    'px' => [
                        'min' => 1,
                        'max' => 1000,
                    ],
                    'vw' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                ],
                'selectors'      => [
                    '{{WRAPPER}} .sidebar__services-list li a span' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'icon_height',
            [
                'label'          => __('Height', 'adina'),
                'type'           => Controls_Manager::SLIDER,
                'size_units'     => ['px','%','vh'],
                'range'          => [
                    'px' => [
                        'min' => 1,
                        'max' => 1000,
                    ],
					'%'  => [
                        'min' => 1,
                        'max' => 100,
                    ],
                    'vh' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                ],
                'selectors'      => [
                    '{{WRAPPER}} .sidebar__services-list li a span' => 'height: {{SIZE}}{{UNIT}} !important;',
                ],
            ]
        );
        $this->add_control(
            'icon_size',
            [
                'label' => __( 'Font Size', 'adina' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', 'em', '%' ],
                'default' => [
                    'unit' => 'px',
                    'size' => 40,
                ],
				'selectors'      => [
                    '{{WRAPPER}} .sidebar__services-list li a span' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        // Box STYLE
        $this->start_controls_section('box_style',
            [
                'label' => __('Box', 'adina'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->start_controls_tabs(
            'box_styles'
        );

        $this->start_controls_tab(
            'box_normal_style',
            [
                'label' => esc_html__( 'Normal', 'adina' ),
            ]
        );

        $this->add_control(
            'box_bg_color',
            [
                'label' => __('Background Color', 'adina'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .sidebar__services-list li a' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'box_border',
                'selector' => '{{WRAPPER}} .sidebar__services-list li a',
            ]
        );
        $this->add_responsive_control(
            'box_radius',
            [
                'label' => __('Radius', 'adina'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .sidebar__services-list li a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'box_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .sidebar__services-list li' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'box_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .sidebar__services-list li a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'box_hover_style',
            [
                'label' => esc_html__( 'Hover', 'adina' ),
            ]
        );
        $this->add_control(
            'box_bg_hover_color',
            [
                'label' => __('Box Background Color', 'adina'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .sidebar__services-list li a::before' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'text_hover_color',
            [
                'label' => __( 'Text Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .sidebar__services-list li a:hover, .sidebar__services-list li a.active' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'icon_hover_color',
            [
                'label' => __( 'Icon Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .sidebar__services-list li a:hover span, .sidebar__services-list li a.active span' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'icon_bg_hover_color',
            [
                'label' => __('Icon Background Color', 'adina'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .sidebar__services-list li a:hover span, .sidebar__services-list li a.active span' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
        
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $list_repeater = $settings[ 'list_repeater' ];

    ?>
        <ul class="sidebar__services-list">
            <?php foreach( $list_repeater as $list_repeaters ) :
                    $active = '';

                    if($list_repeaters['list_active'] == 'yes'){
                        $active = 'active';
                    }else{
                        $active = '';
                }
                ?>
                <li>
                    <a class="<?php echo esc_attr( $active ); ?>" href="<?php echo esc_url( $list_repeaters['btn_url'] ); ?>">
                        <?php echo esc_html(  $list_repeaters[ 'service_name' ] ); ?>
                        <span class="icon-right-arrow-5"></span>
                    </a>
                </li>
            <?php endforeach; ?>
        </ul>

    <?php
}
}
$widgets_manager->register(new \Elementor\AdinaServiceList());