<?php
/**
 * Happyden Team Widget.
 *
 *
 * @since 1.0.0
 */
namespace Elementor;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\Widget_Base;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Css_Filter;
use Elementor\Icons_Manager;
use Elementor\Utils;
use Elementor\Repeater;
use Elementor\URL;
use \Elementor\Control_Media;

if (!defined('ABSPATH')) {
    exit;
}
// If this file is called directly, abort.
class AdinaService extends Widget_Base {
    public function get_name() {
        return 'adina-service';
    }
    public function get_title() {
        return __('Service', 'adina');
    }
    public function get_icon() {
        return ('eicon-person');
    }
    public function get_categories() {
        return ['adina-addons'];
    }
    public function get_keywords() {
        return ['service', 'Slider', 'Services'];
    }

    protected function register_controls() {

        $this->start_controls_section(
            'service_settings',
            [
                'label' => __('Service Settings', 'adina'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'show_slider_settings',
            [
                'label' => __('Slider Active', 'adina'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'adina'),
                'label_off' => __('No', 'adina'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );


        $this->add_responsive_control('per_line', [
            'label'              => __('Columns per row', 'adina'),
            'type'               => Controls_Manager::SELECT,
            'default'            => '3',
            'tablet_default'     => '6',
            'mobile_default'     => '12',
            'options'            => [
                '12' => '1',
                '6'  => '2',
                '4'  => '3',
                '3'  => '4',
            ],
            'frontend_available' => true,
            'condition'   => [ 'show_slider_settings' => '', ]
        ]);


        $this->add_responsive_control(
            'gap_bottom',
            [
                'label'          => __('Gap Bottom', 'adina'),
                'type'           => Controls_Manager::SLIDER,
                'size_units'     => ['px', '%'],
                'range'          => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors'      => [
                    '{{WRAPPER}} .service-one__single, .services-two__single, .services-three__single' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        //Slider Setting
        $this->start_controls_section('slider_settings',
        [
            'label' => __('Slider Settings', 'adina'),
            'tab'   => Controls_Manager::TAB_CONTENT,
            'condition' => [ 'show_slider_settings' => 'yes',  ]
            ]
        );

        $this->add_responsive_control(
            'per_coulmn',
            [
                'label' => __( 'Slider Items', 'adina' ),
                'type' => Controls_Manager::SELECT,
                'default'            => 3,
                'tablet_default'     => 2,
                'mobile_default'     => 1,
                'options'            => [
                    '1' => '1',
                    '2' => '2',
                    '3' => '3',
                    '4' => '4',
                    '5' => '5',
                    '6' => '6',
                ],
                'frontend_available' => true,
            ]
        );
        $this->add_responsive_control(
			'gap_right_left',
			[
				'label'          => __('Row Gap(Right-Left)', 'adina'),
				'type'           => Controls_Manager::SLIDER,
				'size_units'     => ['px', '%'],
				'range'          => [
					'px' => [
						'min' => 0,
						'max' => 1000,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors'      => [
					'{{WRAPPER}} .service-one__single, .services-two__single, .services-three__single' => 'margin-right: {{SIZE}}{{UNIT}}; margin-left: {{SIZE}}{{UNIT}};',
				],
			]
		);	
        $this->add_control(
            'dots',
            [
                'label' => __( 'Dots?', 'adina' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'adina' ),
                'label_off' => __( 'Hide', 'adina' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'drag',
            [
                'label' => __( 'Drag?', 'adina' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'adina' ),
                'label_off' => __( 'Hide', 'adina' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'autoplay',
            [
                'label' => __( 'Auto Play?', 'adina' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'adina' ),
                'label_off' => __( 'Hide', 'adina' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'autoplaytimeout',
            [
                'label' => __( 'Autoplay Timeout', 'adina' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'label_block' => true,
                'default' => '5000',
                'options' => [
                    '1000'  => __( '1 Second', 'adina' ),
                    '2000'  => __( '2 Second', 'adina' ),
                    '3000'  => __( '3 Second', 'adina' ),
                    '4000'  => __( '4 Second', 'adina' ),
                    '5000'  => __( '5 Second', 'adina' ),
                    '6000'  => __( '6 Second', 'adina' ),
                    '7000'  => __( '7 Second', 'adina' ),
                    '8000'  => __( '8 Second', 'adina' ),
                    '9000'  => __( '9 Second', 'adina' ),
                    '10000' => __( '10 Second', 'adina' ),
                    '11000' => __( '11 Second', 'adina' ),
                    '12000' => __( '12 Second', 'adina' ),
                    '13000' => __( '13 Second', 'adina' ),
                    '14000' => __( '14 Second', 'adina' ),
                    '15000' => __( '15 Second', 'adina' ),
                ],
                'condition' => [
                    'autoplay' => 'yes',
                ],
            ]
        );
        $this->end_controls_section();
        // End Slider settings

        // Start Service Section
        $this->start_controls_section(
            'service_content',
            [
                'label' => __('Service Section', 'adina'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'service_layout',
            [
                'label' => esc_html__('Select Layout', 'adina'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'layout-1' => esc_html__('Layout 1', 'adina'),
                    'layout-2' => esc_html__('Layout 2', 'adina'),
                    'layout-3' => esc_html__('Layout 3', 'adina'),
                ],
                'default' => 'layout-1',
            ]
        );
        $service_repeater = new Repeater();

        $service_repeater->add_control(
			'service_image',
			[
				'label' => esc_html__( 'Image', 'adina' ),
				'type' =>  Controls_Manager::MEDIA,
				'default' => [
					'url' =>  Utils::get_placeholder_image_src(),
				],
			]
		);
        $service_repeater->add_control(
			'overlay_icon',
			[
				'label' => esc_html__( 'Overlay Icon(only Use layout 1)', 'adina' ),
				'type' =>  Controls_Manager::MEDIA,
				'default' => [
					'url' =>  Utils::get_placeholder_image_src(),
				],
			]
		);
        $service_repeater->add_control(
			'icon_class',
			[
				'label' => esc_html__( 'Icon(only Use layout 3)', 'adina' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'icon-road-transport', 'adina' ),
				'label_block' => true,
			]
		);
        $service_repeater->add_control(
			'service_nmbr',
			[
				'label' => esc_html__( 'Service Number(only use layout 02)', 'adina' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( '01', 'adina' ),
				'label_block' => true,
			]
		);
        $service_repeater->add_control(
			'service_title',
			[
				'label' => esc_html__( 'Title', 'adina' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Air Freight', 'adina' ),
				'label_block' => true,
			]
		);
        $service_repeater->add_control(
			'service_text',
			[
				'label' => esc_html__( 'Description', 'adina' ),
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'Following the quality of our service thus having gained trust', 'adina' ),
				'label_block' => true,
			]
		);
        $service_repeater->add_control(
			'btn_text',
			[
				'label' => esc_html__( 'Button Text', 'adina' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Read More', 'adina' ),
				'label_block' => true,
			]
		);
        $service_repeater->add_control(
			'service_link',
			[
				'label' => esc_html__( 'Details Link', 'adina' ),
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__( '#', 'adina' ),
				'label_block' => true,
			]
		);
        $service_repeater->add_control(
			'nmbr_overlay',
			[
				'label' => esc_html__( 'Number Overlay(Use layout 2 & 3)', 'adina' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( '01', 'adina' ),
				'label_block' => true,
			]
		);
        $this->add_control(
			'service_slides',
			[
				'label' => esc_html__( 'Service List', 'adina' ),
				'type' =>  Controls_Manager::REPEATER,
				'fields' => $service_repeater->get_controls(),
				'default' => [
					[
                        'service_image'   => Utils::get_placeholder_image_src(),
						'overlay_icon'    => Utils::get_placeholder_image_src(),
						'icon_class'      => esc_html__( 'icon-road-transport', 'adina' ),
						'service_nmbr'    => esc_html__( '01', 'adina' ),
                        'service_title'   => esc_html__( 'Air Freight', 'adina' ),
                        'service_text'    => esc_html__( 'Following the quality of our service thus having gained trust', 'adina' ),
						'btn_text'        => esc_html__( 'Read More', 'adina' ),
						'service_link'    => esc_html__( '#', 'adina' ),
						'nmbr_overlay'    => esc_html__( '01', 'adina' ),
					],
                    [
                        'service_image'   => Utils::get_placeholder_image_src(),
						'overlay_icon'    => Utils::get_placeholder_image_src(),
						'icon_class'      => esc_html__( 'icon-road-transport', 'adina' ),
						'service_nmbr'    => esc_html__( '01', 'adina' ),
                        'service_title'   => esc_html__( 'Air Freight', 'adina' ),
                        'service_text'    => esc_html__( 'Following the quality of our service thus having gained trust', 'adina' ),
						'btn_text'        => esc_html__( 'Read More', 'adina' ),
						'service_link'    => esc_html__( '#', 'adina' ),
						'nmbr_overlay'    => esc_html__( '01', 'adina' ),
					],
                    [
                        'service_image'   => Utils::get_placeholder_image_src(),
						'overlay_icon'    => Utils::get_placeholder_image_src(),
						'icon_class'      => esc_html__( 'icon-road-transport', 'adina' ),
						'service_nmbr'    => esc_html__( '01', 'adina' ),
                        'service_title'   => esc_html__( 'Air Freight', 'adina' ),
                        'service_text'    => esc_html__( 'Following the quality of our service thus having gained trust', 'adina' ),
						'btn_text'        => esc_html__( 'Read More', 'adina' ),
						'service_link'    => esc_html__( '#', 'adina' ),
						'nmbr_overlay'    => esc_html__( '01', 'adina' ),
					],
				],
			]
		);

        $this->end_controls_section();

        /********* Image Style /*********/
        $this->start_controls_section(
            'service_img_style',
            [
                'label' => __( 'Image', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'img_width',
            [
                'label'          => __('Width', 'adina'),
                'type'           => Controls_Manager::SLIDER,
                'size_units'     => ['%', 'px','vw'],
                'range'          => [
                    '%'  => [
                        'min' => 1,
                        'max' => 100,
                    ],
                    'px' => [
                        'min' => 1,
                        'max' => 1000,
                    ],
                    'vw' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                ],
                'selectors'      => [
                    '{{WRAPPER}} .service-one__single-img .inner img, .services-two__single-img .inner img, .services-three__single-img .inner img' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'img_height',
            [
                'label'          => __('Height', 'adina'),
                'type'           => Controls_Manager::SLIDER,
                'size_units'     => ['px','%', 'vh'],
                'range'          => [
                    'px' => [
                        'min' => 1,
                        'max' => 1000,
                    ],
                    '%'  => [
                        'min' => 1,
                        'max' => 100,
                    ],
                    'vh' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                ],
                'selectors'      => [
                    '{{WRAPPER}} .service-one__single-img .inner img, .services-two__single-img .inner img, .services-three__single-img .inner img' => 'height: {{SIZE}}{{UNIT}} !important;',
                ],
            ]
        );
        $this->add_responsive_control(
            'img_object-fit',
            [
                'label'     => __('Object Fit', 'adina'),
                'type'      => Controls_Manager::SELECT,
                'condition' => [
                    'height[size]!' => '',
                ],
                'options'   => [
                    ''        => __('Default', 'adina'),
                    'fill'    => __('Fill', 'adina'),
                    'cover'   => __('Cover', 'adina'),
                    'contain' => __('Contain', 'adina'),
                ],
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .service-one__single-img .inner img, .services-two__single-img .inner img, .services-three__single-img .inner img' => 'object-fit: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'img_object-position',
            [
                'label'     => __('Object Position', 'adina'),
                'type'      => Controls_Manager::SELECT,
                'condition' => [
                    'height[size]!' => '',
                ],
                'options'   => [
                    ''        => __('Default', 'adina'),
                    'center top' => __('Center Top', 'adina'),
                    'center bottom'   => __('Center Bottom', 'adina'),
                    'center left' => __('Center Left', 'adina'),
                    'center right' => __('Center Right', 'adina'),
                ],
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .service-one__single-img .inner img, .services-two__single-img .inner img, .services-three__single-img .inner img' => 'object-position: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        /********* Number Style /*********/
        $this->start_controls_section(
            'nmbr_style',
            [
                'label' => __( 'Number', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'service_layout' => 'layout-2',
                ],
            ]
        );

        $this->add_control(
            'nmbr_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .services-two__single-img .number-box' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'nmbr_bg_color',
            [
                'label' => __('Background Color', 'adina'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .services-two__single-img .number-box' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'nmbr_border',
                'selector' => '{{WRAPPER}} .services-two__single-img .number-box',
            ]
        );
        $this->add_control(
            'nmbr_border_radius',
            [
                'label' => esc_html__( 'Border Radius', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'selectors' => [
                    '{{WRAPPER}} .services-two__single-img .number-box' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'nmbr_width',
            [
                'label'          => __('Width', 'adina'),
                'type'           => Controls_Manager::SLIDER,
                'size_units'     => ['%', 'px','vw'],
                'range'          => [
                    '%'  => [
                        'min' => 1,
                        'max' => 100,
                    ],
                    'px' => [
                        'min' => 1,
                        'max' => 1000,
                    ],
                    'vw' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                ],
                'selectors'      => [
                    '{{WRAPPER}} .services-two__single-img .number-box' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'nmbr_height',
            [
                'label'          => __('Height', 'adina'),
                'type'           => Controls_Manager::SLIDER,
                'size_units'     => ['px', 'vh'],
                'range'          => [
                    'px' => [
                        'min' => 1,
                        'max' => 1000,
                    ],
                    'vh' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                ],
                'selectors'      => [
                    '{{WRAPPER}} .services-two__single-img .number-box' => 'height: {{SIZE}}{{UNIT}} !important;',
                ],
            ]
        );

        $this->end_controls_section();

        /********* Icon Style /*********/
        $this->start_controls_section(
            'icon_style',
            [
                'label' => __( 'Icon', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'service_layout' => 'layout-3',
                ],
            ]
        );

        $this->add_control(
            'icon_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .services-three__single-img .inner .icon-box span' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'icon_size',
            [
                'label' => __( 'Font Size', 'adina' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', 'em', '%' ],
                'default' => [
                    'unit' => 'px',
                    'size' => 40,
                ],
				'selectors'      => [
                    '{{WRAPPER}} .services-three__single-img .inner .icon-box span' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        /********* Ttile Style /*********/
        $this->start_controls_section(
            'service_title_style',
            [
                'label' => __( 'Title', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->start_controls_tabs(
            'title_style_tabs'
        );
        $this->start_controls_tab(
            'title_normal_tab',
            [
                'label' => esc_html__( 'Normal', 'adina' ),
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .service-one__single-content h3 a, .services-two__single-content-inner h3 a, .services-three__single-content-inner h2 a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'selector' => '{{WRAPPER}} .service-one__single-content h3, .services-two__single-content-inner h3, .services-three__single-content-inner h2',
			]
		);
        $this->add_responsive_control(
            'title_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .service-one__single-content h3, .services-two__single-content-inner h3, .services-three__single-content-inner h2' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'title_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .service-one__single-content h3, .services-two__single-content-inner h3, .services-three__single-content-inner h2' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();

        $this->start_controls_tab(
            'title_hover_tab',
            [
                'label' => esc_html__( 'Hover', 'adina' ),
            ]
        );

        $this->add_control(
            'title_hover_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .service-one__single-content h3 a:hover, .services-two__single-content-inner h3 a:hover, .services-three__single-content-inner h2 a:hover' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();

        /********* DEscription Style /*********/
        $this->start_controls_section(
            'description_style',
            [
                'label' => __( 'Description', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'description_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .service-one__single-content p, .services-two__single-content-inner p, .services-three__single-content-inner p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'description_typography',
				'selector' => '{{WRAPPER}} .service-one__single-content p, .services-two__single-content-inner p, .services-three__single-content-inner p',
			]
		);
        $this->add_responsive_control(
            'description_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .service-one__single-content p, .services-two__single-content-inner p, .services-three__single-content-inner p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'description_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .service-one__single-content p, .services-two__single-content-inner p, .services-three__single-content-inner p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        /********* Button Style /*********/
        $this->start_controls_section(
            'btn_style',
            [
                'label' => __( 'Button', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->start_controls_tabs(
            'btn_style_tabs'
        );
        $this->start_controls_tab(
            'btn_normal_tab',
            [
                'label' => esc_html__( 'Normal', 'adina' ),
            ]
        );

        $this->add_control(
            'btn_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .service-one__single-content .btn-box a, .services-two__single-content .btn-box .thm-btn, .services-three__single-content-inner .btn-box a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'btn_bg_color',
            [
                'label' => __('Background Color', 'adina'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .service-one__single-content .btn-box a, .services-two__single-content .btn-box .thm-btn::after, .services-three__single-content-inner .btn-box' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'btn_typography',
				'selector' => '{{WRAPPER}} .service-one__single-content .btn-box a, .services-two__single-content .btn-box .thm-btn, .services-three__single-content-inner .btn-box a',
			]
		);
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'btn_border',
                'selector' => '{{WRAPPER}} .service-one__single-content .btn-box a, .services-two__single-content .btn-box .thm-btn, .services-three__single-content-inner .btn-box',
            ]
        );
        $this->add_control(
            'btn_border_radius',
            [
                'label' => esc_html__( 'Border Radius', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'selectors' => [
                    '{{WRAPPER}} .service-one__single-content .btn-box a, .services-two__single-content .btn-box .thm-btn, .services-three__single-content-inner .btn-box' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'btn_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .service-one__single-content .btn-box, .services-two__single-content .btn-box .thm-btn, .services-three__single-content-inner .btn-box' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'btn_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .service-one__single-content .btn-box a, .services-two__single-content .btn-box .thm-btn, .services-three__single-content-inner .btn-box' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'btn_hover_tab',
            [
                'label' => esc_html__( 'Hover', 'adina' ),
            ]
        );

        $this->add_control(
            'btn_hover_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .service-one__single-content .btn-box a:hover, .services-two__single-content .btn-box .thm-btn:hover, .services-three__single-content-inner .btn-box a:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'btn_hover_bg_color',
            [
                'label' => __('Background Color', 'adina'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .service-one__single-content .btn-box a:hover, .services-two__single-content .btn-box .thm-btn::before, .services-three__single-content-inner .btn-box:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'btn_hover_border',
                'selector' => '{{WRAPPER}} .service-one__single-content .btn-box a:hover, .services-two__single-content .btn-box .thm-btn:hover, .services-three__single-content-inner .btn-box:hover',
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();

        /********* Content Box Style *********/
        $this->start_controls_section(
            'content_box_style',
            [
                'label' => __( 'Content Box', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->start_controls_tabs(
            'content_box_style_tabs'
        );
        $this->start_controls_tab(
            'content_box_normal_tab',
            [
                'label' => esc_html__( 'Normal', 'adina' ),
            ]
        );

        $this->add_control(
            'content_box_bg_color',
            [
                'label' => __('Background Color', 'adina'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .service-one__single-content, .services-two__single-content-inner::before, .services-three__single-content-inner' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'content_box_border',
                'selector' => '{{WRAPPER}} .service-one__single::before, .services-two__single-content-inner, .services-three__single-content-inner',
            ]
        );
        $this->add_control(
            'content_box_radius',
            [
                'label' => esc_html__( 'Border Radius', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'selectors' => [
                    '{{WRAPPER}} .service-one__single-content, .services-two__single-content-inner, .services-three__single-content-inner' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'content_box_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .service-one__single-content, .services-two__single-content-inner, .services-three__single-content-inner' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'content_box_hover_tab',
            [
                'label' => esc_html__( 'Hover', 'adina' ),
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'content_box_hover_border',
                'selector' => '{{WRAPPER}} .service-one__single:hover::before, .services-two__single-content-inner:hover, .services-three__single-content-inner:hover',
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();

        /********* Box Style /*********/
        $this->start_controls_section(
            'box_style',
            [
                'label' => __( 'Box', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'service_layout' => 'layout-1',
                ],
            ]
        );
        $this->start_controls_tabs(
            'box_style_tabs'
        );
        $this->start_controls_tab(
            'box_normal_tab',
            [
                'label' => esc_html__( 'Normal', 'adina' ),
            ]
        );

        $this->add_control(
            'box_bg_color',
            [
                'label' => __('background Color', 'adina'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .service-one__single:after' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'box_hover_tab',
            [
                'label' => esc_html__( 'Hover', 'adina' ),
            ]
        );

        $this->add_control(
            'box_hover_bg_color',
            [
                'label' => __('background Color', 'adina'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .service-one__single:hover:after' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();

        /********* Overlay Number Style /*********/
        $this->start_controls_section(
            'overlay_nmbr_style',
            [
                'label' => __( 'Overlay Number', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'service_layout' => [
                        'layout-2', 
                        'layout-3'
                    ],
                ],
            ]
        );

        $this->add_control(
            'overlay_nmbr_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .services-two__single-content-inner .count-box, .services-three__single-content-inner .count-box, .services-three__single-content-inner .btn-box .number-box' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'overlay_nmbr_typography',
				'selector' => '{{WRAPPER}} .services-two__single-content-inner .count-box, .services-three__single-content-inner .count-box, .services-three__single-content-inner .btn-box .number-box',
			]
		);

        $this->end_controls_section();
       
    }

    protected function render() {
        $settings = $this->get_settings_for_display();

         //this code course slider option
		$slider_extraSetting = array(
	        'autoplay' => (!empty($settings['autoplay']) && 'yes' === $settings['autoplay']) ? true : false,
            'drag' => (!empty($settings['drag']) && 'yes' === $settings['drag']) ? true : false,
            'dots' => (!empty($settings['dots']) && 'yes' === $settings['dots']) ? true : false,
        	'autoplaytimeout' => !empty($settings['autoplaytimeout']) ? $settings['autoplaytimeout'] : '5000',

        	//this a responsive layout
            'per_coulmn' =>        (!empty($settings['per_coulmn'])) ? $settings['per_coulmn'] : 3,
            'per_coulmn_tablet' => (!empty($settings['per_coulmn_tablet'])) ? $settings['per_coulmn_tablet'] : 2,
            'per_coulmn_mobile' => (!empty($settings['per_coulmn_mobile'])) ? $settings['per_coulmn_mobile'] : 1
        );
        $jasondecode = wp_json_encode($slider_extraSetting);


        if ( ( 'yes' == $settings['show_slider_settings'] ) ) {
            $this->add_render_attribute('service_version', 'class', ['row service-slider']);
            $this->add_render_attribute('service_version', 'data-settings', $jasondecode);
            $this->add_render_attribute('service_gride_classes', 'class', ['item']);
        } else {
            $this->add_render_attribute('service_version', 'class', ['row']);
            //gride class
            $grid_classes = [];
            $grid_classes[] = 'col-xl-' . $settings['per_line'];
            $grid_classes[] = 'col-md-' . $settings['per_line_tablet'];
            $grid_classes[] = 'col-sm-' . $settings['per_line_mobile'];
            $grid_classes = implode(' ', $grid_classes);
            $this->add_render_attribute('service_gride_classes', 'class', [$grid_classes]);
        }

        $layout = $settings['service_layout'];
        $slides = $settings[ 'service_slides' ];
        
        ?>       

            <?php
                if ( $layout) {
                    include('service/'.$layout.'.php');
                }
            ?> 

            <!-- <div class="services-two__wrap">
                <div class="swiper-counter">
                    <div id="current2">1</div>
                    <div id="total2"></div>
                </div>
            </div>

            <div class="swiper-nav-style1">
                <div class="swiper-button-prev" id="services-two__swiper-button-next">
                    <i class="icon-left-arrow-5" aria-hidden="true"></i>
                </div>
                <div class="swiper-button-next" id="services-two__swiper-button-prev">
                    <i class="icon-right-arrow-5" aria-hidden="true"></i>
                </div>
            </div> -->

        <?php
    }
}
$widgets_manager->register(new \Elementor\AdinaService());

