<?php
/**
 * Happyden Team Widget.
 *
 *
 * @since 1.0.0
 */

namespace Elementor;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\Widget_Base;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Css_Filter;
use Elementor\Icons_Manager;
use Elementor\Utils;
use Elementor\Repeater;
use Elementor\URL;
use \Elementor\Control_Media;

if (!defined('ABSPATH')) {
    exit;
}
// If this file is called directly, abort.
class AdinaSidebarConatct extends Widget_Base {
    public function get_name() {
        return 'adina_sidebar_contact';
    }
    public function get_title() {
        return __('Sidebar Conatct', 'adina');
    }
    public function get_icon() {
        return ('eicon-person');
    }
    public function get_categories() {
        return ['adina-addons'];
    }
    public function get_keywords() {
        return ['sidebar', 'contact', 'call'];
    }
    protected function register_controls() {

        $this->start_controls_section('general_section',
            [
                'label' => __('General ', 'adina'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
			'contact_title',
			[
				'label' => esc_html__( 'Title', 'adina' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Any Question?', 'adina' ),
				'label_block' => true,
			]
		);
        $this->add_control(
			'contact_icon',
			[
				'label' => esc_html__( 'Contact Icon', 'adina' ),
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'icon-out-call', 'adina' ),
				'label_block' => true,
			]
		);
        $this->add_control(
			'contact_text',
			[
				'label' => esc_html__( 'Text', 'adina' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Call Us Now', 'adina' ),
				'label_block' => true,
			]
		);
        $this->add_control(
			'contact_nmbr',
			[
				'label' => esc_html__( 'Contact Number', 'adina' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( '+70 264 566 579', 'adina' ),
				'label_block' => true,
			]
		);
        $this->add_control(
			'contact_url',
			[
				'label' => esc_html__( 'Url', 'adina' ),
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__( '#', 'adina' ),
				'label_block' => true,
			]
		);

        $this->end_controls_section();

        // Title STYLE
        $this->start_controls_section('title_style',
            [
                'label' => __('Title', 'adina'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .sidebar__contact-box .title h2' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'title_bg_color',
            [
                'label' => __('Background Color', 'adina'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .sidebar__contact-box .title::before' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'title_height',
            [
                'label'          => __('Background Color Height', 'adina'),
                'type'           => Controls_Manager::SLIDER,
                'size_units'     => ['px','%','vh'],
                'range'          => [
                    'px' => [
                        'min' => 1,
                        'max' => 1000,
                    ],
					'%'  => [
                        'min' => 1,
                        'max' => 100,
                    ],
                    'vh' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                ],
                'selectors'      => [
                    '{{WRAPPER}} .sidebar__contact-box .title::before' => 'height: {{SIZE}}{{UNIT}} !important;',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'selector' => '{{WRAPPER}} .sidebar__contact-box .title h2',
            ]
        );
        $this->add_responsive_control(
            'title_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .sidebar__contact-box .title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'title_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .sidebar__contact-box .title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        // Icon STYLE
        $this->start_controls_section('icon_style',
            [
                'label' => __('Icon', 'adina'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'icon_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .sidebar__contact-box-bottom .icon-box span' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'icon_bg_color',
            [
                'label' => __('Background Color', 'adina'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .sidebar__contact-box-bottom .icon-box' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'icon_size',
            [
                'label' => __( 'Font Size', 'adina' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', 'em', '%' ],
                'default' => [
                    'unit' => 'px',
                    'size' => 40,
                ],
				'selectors'      => [
                    '{{WRAPPER}} .sidebar__contact-box-bottom .icon-box span' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'icon_width',
            [
                'label'          => __('Width', 'adina'),
                'type'           => Controls_Manager::SLIDER,
                'size_units'     => ['%', 'px','vw'],
                'range'          => [
                    '%'  => [
                        'min' => 1,
                        'max' => 100,
                    ],
                    'px' => [
                        'min' => 1,
                        'max' => 1000,
                    ],
                    'vw' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                ],
                'selectors'      => [
                    '{{WRAPPER}} .sidebar__contact-box-bottom .icon-box' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'icon_height',
            [
                'label'          => __('Height', 'adina'),
                'type'           => Controls_Manager::SLIDER,
                'size_units'     => ['px','%','vh'],
                'range'          => [
                    'px' => [
                        'min' => 1,
                        'max' => 1000,
                    ],
					'%'  => [
                        'min' => 1,
                        'max' => 100,
                    ],
                    'vh' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                ],
                'selectors'      => [
                    '{{WRAPPER}} .sidebar__contact-box-bottom .icon-box' => 'height: {{SIZE}}{{UNIT}} !important;',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'icon_border',
                'selector' => '{{WRAPPER}} .sidebar__contact-box-bottom .icon-box',
            ]
        );
        $this->add_responsive_control(
            'icon_radius',
            [
                'label' => __('Radius', 'adina'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .sidebar__contact-box-bottom .icon-box' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'icon_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .sidebar__contact-box-bottom .icon-box' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        // Text STYLE
        $this->start_controls_section('text_style',
            [
                'label' => __('Text', 'adina'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'text_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .sidebar__contact-box-bottom .text-box p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'text_typography',
                'selector' => '{{WRAPPER}} .sidebar__contact-box-bottom .text-box p',
            ]
        );
        $this->add_responsive_control(
            'text_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .sidebar__contact-box-bottom .text-box p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        
        $this->end_controls_section();

        // Number STYLE
        $this->start_controls_section('nmbr_style',
            [
                'label' => __('Number', 'adina'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'nmbr_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .sidebar__contact-box-bottom .text-box h2 a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'nmbr_typography',
                'selector' => '{{WRAPPER}} .sidebar__contact-box-bottom .text-box h2 a',
            ]
        );

        $this->end_controls_section();

    }

    protected function render() {
        $settings = $this->get_settings_for_display();

    ?>

        <div class="sidebar__contact-box">
            <div class="title">
                <h2><?php echo esc_html(  $settings[ 'contact_title' ] ); ?></h2>
            </div>

            <div class="sidebar__contact-box-bottom">
                <div class="icon-box">
                    <span class="<?php echo esc_attr(  $settings[ 'contact_icon' ] ); ?>"></span>
                </div>

                <div class="text-box">
                    <p><?php echo esc_html(  $settings[ 'contact_text' ] ); ?></p>
                    <h2><a href="<?php echo esc_url(  $settings[ 'contact_url' ] ); ?>"><?php echo esc_html(  $settings[ 'contact_nmbr' ] ); ?></a></h2>
                </div>
            </div>
        </div>

    <?php
}
}
$widgets_manager->register(new \Elementor\AdinaSidebarConatct());