<?php
/**
 * Happyden Team Widget.
 *
 *
 * @since 1.0.0
 */
namespace Elementor;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\Widget_Base;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Css_Filter;
use Elementor\Icons_Manager;
use Elementor\Utils;
use Elementor\Repeater;
use Elementor\URL;
use \Elementor\Control_Media;

if (!defined('ABSPATH')) {
    exit;
}
// If this file is called directly, abort.
class AdinaTab extends Widget_Base {
    public function get_name() {
        return 'adina-tab';
    }
    public function get_title() {
        return __('Tab', 'adina');
    }
    public function get_icon() {
        return ('eicon-person');
    }
    public function get_categories() {
        return ['adina-addons'];
    }
    public function get_keywords() {
        return ['tab', 'tab form', 'form'];
    }

    protected function register_controls() {

        $this->start_controls_section('general_section',
            [
                'label' => __('General', 'adina'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
			'tab01_text',
			[
				'label' => esc_html__( 'Tab One Text', 'adina' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Request A Quote', 'adina' ),
				'label_block' => true,
			]
		);
        $this->add_control(
            'adina_tab01_builder',
            [
                'label'     => __( 'Select Tab 01', 'adina' ),
                'type'      => Controls_Manager::SELECT,
                'options'   => $this->adina_tab_builder(),
                'default'	=> ''
            ]
        );
        $this->add_control(
			'tab02_text',
			[
				'label' => esc_html__( 'Tab Two Text', 'adina' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'cost calculation', 'adina' ),
				'label_block' => true,
			]
		);
        $this->add_control(
            'adina_tab02_builder',
            [
                'label'     => __( 'Select Tab 02', 'adina' ),
                'type'      => Controls_Manager::SELECT,
                'options'   => $this->adina_tab_builder(),
                'default'	=> ''
            ]
        );
        $this->end_controls_section();

        // Tab 01 STYLE
        $this->start_controls_section('tab01_style',
            [
                'label' => __('Tab', 'adina'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'tab01_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .request-services-one__form-tab .tab-buttons .tab-btn span' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'tab01_typography',
                'selector' => '{{WRAPPER}} .request-services-one__form-tab .tab-buttons .tab-btn span',
            ]
        );
        $this->add_control(
            'tab01_bg_color',
            [
                'label' => __('Background Color', 'adina'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .request-services-one__form-tab .tab-buttons .tab-btn' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'tab01_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .request-services-one__form-tab .tab-buttons .tab-btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'tab01_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .request-services-one__form-tab .tab-buttons .tab-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        // Active Tab STYLE
        $this->start_controls_section('tab02_style',
            [
                'label' => __('Active Tab', 'adina'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'tab02_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .request-services-one__form-tab .tab-buttons .tab-btn.active-btn span' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'tab02_typography',
                'selector' => '{{WRAPPER}} .request-services-one__form-tab .tab-buttons .tab-btn.active-btn span',
            ]
        );
        $this->add_control(
            'tab02_bg_color',
            [
                'label' => __('Background Color', 'adina'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .request-services-one__form-tab .tab-buttons .tab-btn.active-btn' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'tab02_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .request-services-one__form-tab .tab-buttons .tab-btn.active-btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'tab02_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .request-services-one__form-tab .tab-buttons .tab-btn.active-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();


    }

    public function adina_tab_builder(){

        $adina_post_query = new \WP_Query( array(
            'post_type'				=> 'adina_tab_build',
            'posts_per_page'	    => -1,
        ) );

        $adina_tab_builder_title_title = array();
        $adina_tab_builder_title_title[''] = __( 'Select a Title','adina');

        while( $adina_post_query->have_posts() ) {
            $adina_post_query->the_post();
            $adina_tab_builder_title_title[ get_the_ID() ] =  get_the_title();
        }
        wp_reset_postdata();
        return $adina_tab_builder_title_title;
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        
        ?>

            <div class="request-services-one__form-box">
                <div class="request-services-one__form-tab tabs-box">
                    <ul class="tab-buttons clearfix list-unstyled">
                        <li data-tab="#quote" class="tab-btn active-btn"><span><?php echo esc_html( $settings[ 'tab01_text' ] ); ?></span></li>
                        <li data-tab="#track" class="tab-btn"><span><?php echo esc_html( $settings[ 'tab02_text' ] ); ?></span></li>
                    </ul>

                    <div class="tabs-content">


                        <div class="tab active-tab" id="quote">
                            <?php  $elementor = \Elementor\Plugin::instance();
                                echo $elementor->frontend->get_builder_content_for_display($settings['adina_tab01_builder']); 
                            ?>
                        </div>

                        <div class="tab" id="track">
                            <?php  $elementor = \Elementor\Plugin::instance();
                                echo $elementor->frontend->get_builder_content_for_display($settings['adina_tab02_builder']); 
                            ?>
                        </div>

                    </div>
                </div>
            </div>

        <?php
    }
}
$widgets_manager->register(new \Elementor\AdinaTab());

