<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Repeater;
/**
 *
 * Check List Widget .
 *
 */
class Adina_Check_List extends Widget_Base {

	public function get_name() {
		return 'adinachecklist';
	}

	public function get_title() {
		return __( 'Check List', 'adina' );
	}


	public function get_icon() {
		return 'eicon-code';
    }


	public function get_categories() {
		return [ 'adina' ];
	}


	protected function register_controls() {

		$this->start_controls_section(
			'check_list_section',
			[
				'label' 	=> __( 'Check List', 'adina' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

        $repeater = new Repeater();

		$repeater->add_control(
			'checklist_text',
			[
				'label' 	=> __( 'Text', 'adina' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'default'  	=> __( 'Comprehensive reporting on individual achievement', 'adina' )
			]
        );
        


		$this->add_control(
			'check_lists',
			[
				'label' 		=> __( 'Check Lists', 'adina' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'checklist_text'    => __( 'Comprehensive reporting on individual achievement', 'adina' ),

					]
                ],
                'title_field' 	=> '{{{ checklist_text }}}',
			]
		);
        $this->end_controls_section();

        // Style
        $this->start_controls_section(
			'check_lists_style',
			[
				'label' 	=> __( 'Style', 'adina' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 			=> 'text_typography',
				'label' 		=> __( 'Typography', 'adina' ),
                'selector' 		=> '{{WRAPPER}} .list-style1 li',
			]
		);

        $this->add_control(
			'text_color',
			[
				'label'     => __( 'Color', 'adina' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .list-style1 li' => 'color: {{VALUE}}!important',
                ],
			]
        );
		$this->add_responsive_control(
			'checklist_margin',
			[
				'label'         => __( 'List Margin', 'adina' ),
				'type'          => Controls_Manager::DIMENSIONS,
				'size_units'    => [ 'px', '%', 'em' ],
				'selectors'     => [
					'{{WRAPPER}} .list-style1 li' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );
		
		$this->add_responsive_control(
			'checklist_wraper_margin',
			[
				'label'         => __( 'Wraper Margin', 'adina' ),
				'type'          => Controls_Manager::DIMENSIONS,
				'size_units'    => [ 'px', '%', 'em' ],
				'selectors'     => [
					'{{WRAPPER}} .list-style1' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );
        $this->end_controls_section();



	}

	protected function render() {

        $settings = $this->get_settings_for_display(); 
        
        ?>
            <div class="row justify-content-center justify-content-xl-start ">
				<div class="col-auto">
					<div class="list-style1">
						<ul class="list-unstyled">
							<?php foreach( $settings[ 'check_lists' ] as $list ): ?>
								<li><?php echo esc_html( $list[ 'checklist_text' ] ); ?></li>
							<?php endforeach; ?>
						</ul>
					</div>
				</div>
            </div>
        <?php
	}
}
$widgets_manager->register( new \Adina_check_list() );