<?php
/**
 * Happyden Team Widget.
 *
 *
 * @since 1.0.0
 */
namespace Elementor;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\Widget_Base;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Css_Filter;
use Elementor\Icons_Manager;
use Elementor\Utils;
use Elementor\Repeater;
use Elementor\URL;
use \Elementor\Control_Media;

if (!defined('ABSPATH')) {
    exit;
}
// If this file is called directly, abort.
class AdinaTeam extends Widget_Base {
    public function get_name() {
        return 'adina-team';
    }
    public function get_title() {
        return __('Team', 'adina');
    }
    public function get_icon() {
        return ('eicon-person');
    }
    public function get_categories() {
        return ['adina-addons'];
    }
    public function get_keywords() {
        return ['team', 'Slider', 'workers'];
    }

    protected function register_controls() {

		$this->start_controls_section(
            'team_settings',
            [
                'label' => __('Team Settings', 'adina'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'show_slider_settings',
            [
                'label' => __('Slider Active', 'adina'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'adina'),
                'label_off' => __('No', 'adina'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );


        $this->add_responsive_control('per_line', [
            'label'              => __('Columns per row', 'adina'),
            'type'               => Controls_Manager::SELECT,
            'default'            => '3',
            'tablet_default'     => '6',
            'mobile_default'     => '12',
            'options'            => [
                '12' => '1',
                '6'  => '2',
                '4'  => '3',
                '3'  => '4',
            ],
            'frontend_available' => true,
            'condition'   => [ 'show_slider_settings' => '' ]
        ]);


        $this->add_responsive_control(
            'gap_bottom',
            [
                'label'          => __('Gap Bottom', 'adina'),
                'type'           => Controls_Manager::SLIDER,
                'size_units'     => ['px', '%'],
                'range'          => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors'      => [
                    '{{WRAPPER}} .team-one__single, .team-two__single, .team-three__single' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

		//Slider Setting
        $this->start_controls_section('slider_settings',
        [
            'label' => __('Slider Settings', 'adina'),
            'tab'   => Controls_Manager::TAB_CONTENT,
            'condition' => [ 'show_slider_settings' => 'yes',  ]
            ]
        );

        $this->add_responsive_control(
            'per_coulmn',
            [
                'label' => __( 'Slider Items', 'adina' ),
                'type' => Controls_Manager::SELECT,
                'default'            => 3,
                'tablet_default'     => 2,
                'mobile_default'     => 1,
                'options'            => [
                    '1' => '1',
                    '2' => '2',
                    '3' => '3',
                    '4' => '4',
                    '5' => '5',
                    '6' => '6',
                ],
                'frontend_available' => true,
            ]
        );
		$this->add_responsive_control(
			'gap_right_left',
			[
				'label'          => __('Row Gap(Right-Left)', 'adina'),
				'type'           => Controls_Manager::SLIDER,
				'size_units'     => ['px', '%'],
				'range'          => [
					'px' => [
						'min' => 0,
						'max' => 1000,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors'      => [
					'{{WRAPPER}} .team-one__single, .team-two__single, .team-three__single' => 'margin-right: {{SIZE}}{{UNIT}}; margin-left: {{SIZE}}{{UNIT}};',
				],
			]
		);		
        $this->add_control(
            'dots',
            [
                'label' => __( 'Dots?', 'adina' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'adina' ),
                'label_off' => __( 'Hide', 'adina' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'drag',
            [
                'label' => __( 'Drag?', 'adina' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'adina' ),
                'label_off' => __( 'Hide', 'adina' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'autoplay',
            [
                'label' => __( 'Auto Play?', 'adina' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'adina' ),
                'label_off' => __( 'Hide', 'adina' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'autoplaytimeout',
            [
                'label' => __( 'Autoplay Timeout', 'adina' ),
                'type' => Controls_Manager::SELECT,
                'label_block' => true,
                'default' => '5000',
                'options' => [
                    '1000'  => __( '1 Second', 'adina' ),
                    '2000'  => __( '2 Second', 'adina' ),
                    '3000'  => __( '3 Second', 'adina' ),
                    '4000'  => __( '4 Second', 'adina' ),
                    '5000'  => __( '5 Second', 'adina' ),
                    '6000'  => __( '6 Second', 'adina' ),
                    '7000'  => __( '7 Second', 'adina' ),
                    '8000'  => __( '8 Second', 'adina' ),
                    '9000'  => __( '9 Second', 'adina' ),
                    '10000' => __( '10 Second', 'adina' ),
                    '11000' => __( '11 Second', 'adina' ),
                    '12000' => __( '12 Second', 'adina' ),
                    '13000' => __( '13 Second', 'adina' ),
                    '14000' => __( '14 Second', 'adina' ),
                    '15000' => __( '15 Second', 'adina' ),
                ],
                'condition' => [
                    'autoplay' => 'yes',
                ],
            ]
        );
        $this->end_controls_section();
		// End Slider settings

        // Start Team Section
        $this->start_controls_section(
            'team_content',
            [
                'label' => __('Team Section', 'adina'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
		$this->add_control(
            'team_layout',
            [
                'label' => esc_html__('Select Layout', 'adina'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'layout-1' => esc_html__('Layout 1', 'adina'),
                    'layout-2' => esc_html__('Layout 2', 'adina'),
                    'layout-3' => esc_html__('Layout 3', 'adina'),
                ],
                'default' => 'layout-1',
            ]
        );
        $team_repeat = new Repeater();

        $team_repeat->add_control(
			'team_image',
			[
				'label' => esc_html__( 'Image', 'adina' ),
				'type' =>  Controls_Manager::MEDIA,
				'default' => [
					'url' =>  Utils::get_placeholder_image_src(),
				],
			]
		);
		$team_repeat->add_control(
			'team_bg_image',
			[
				'label' => esc_html__( 'Background Image(only use layout-2)', 'adina' ),
				'type' =>  Controls_Manager::MEDIA,
				'default' => [
					'url' =>  Utils::get_placeholder_image_src(),
				],
			]
		);
        $team_repeat->add_control(
			'team_title',
			[
				'label' => esc_html__( 'Title', 'adina' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Rebecca Tylor', 'adina' ),
				'label_block' => true,
			]
		);
        $team_repeat->add_control(
			'workers_designation',
			[
				'label' => esc_html__( 'Designation', 'adina' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'SEO - Founder', 'adina' ),
				'label_block' => true,
			]
		);
        $team_repeat->add_control(
			'team_link',
			[
				'label' => esc_html__( 'Details Link', 'adina' ),
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__( '#', 'adina' ),
				'label_block' => true,
			]
		);
        $team_repeat->start_controls_tabs(
            'social_icon_tabs'
        );
        $team_repeat->start_controls_tab(
            'social_icons_tab',
            [
                'label' => esc_html__( 'Social Icons', 'adina' ),
            ]
        );

        $team_repeat->add_control(
            'icon01_select',
            [
                'label' => __('Icon select', 'adina'),
                'type' => Controls_Manager::SELECT2,
                'options' => adina_icon_list_options(),
                'default' => 'facebook',
                'label_block' => true,

            ]
        );
        $team_repeat->add_control(
            'icon02_select',
            [
                'label' => __('Icon select', 'adina'),
                'type' => Controls_Manager::SELECT2,
                'options' => adina_icon_list_options(),
                'default' => 'twitter',
                'label_block' => true,

            ]
        );
        $team_repeat->add_control(
            'icon03_select',
            [
                'label' => __('Icon select', 'adina'),
                'type' => Controls_Manager::SELECT2,
                'options' => adina_icon_list_options(),
                'default' => 'instagram',
                'label_block' => true,

            ]
        );
        $team_repeat->add_control(
            'icon04_select',
            [
                'label' => __('Icon select', 'adina'),
                'type' => Controls_Manager::SELECT2,
                'options' => adina_icon_list_options(),
                'default' => 'linkedin',
                'label_block' => true,

            ]
        );

        $team_repeat->end_controls_tab();

        $team_repeat->start_controls_tab(
            'social_icon_url_tab',
            [
                'label' => esc_html__( 'Url', 'adina' ),
            ]
        );

        $team_repeat->add_control(
			'fb_url',
			[
				'label' => esc_html__( 'Facebook', 'adina' ),
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__( '#', 'adina' ),
				'label_block' => true,
			]
		);
        $team_repeat->add_control(
			'tw_url',
			[
				'label' => esc_html__( 'Twitter', 'adina' ),
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__( '#', 'adina' ),
				'label_block' => true,
			]
		);
        $team_repeat->add_control(
			'insta_url',
			[
				'label' => esc_html__( 'Instagram', 'adina' ),
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__( '#', 'adina' ),
				'label_block' => true,
			]
		);
        $team_repeat->add_control(
			'linkedin_url',
			[
				'label' => esc_html__( 'Linkedin', 'adina' ),
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__( '#', 'adina' ),
				'label_block' => true,
			]
		);

        $team_repeat->end_controls_tab();
        $team_repeat->end_controls_tabs();

		$team_repeat->add_control(
			'contact_icon',
			[
				'label' => esc_html__( 'Here you can use Fontawsome or Icomoon Class(only use layout-2)', 'adina' ),
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'icon-out-call', 'adina' ),
				'label_block' => true,
			]
		);
		$team_repeat->add_control(
			'contact_nmbr',
			[
				'label' => esc_html__( 'Contact Number(only use layout-2)', 'adina' ),
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__( '+70 264 566 579', 'adina' ),
				'label_block' => true,
			]
		);
        $team_repeat->add_control(
			'contact_url',
			[
				'label' => esc_html__( 'Contact Link(only use layout-2)', 'adina' ),
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__( '#', 'adina' ),
				'label_block' => true,
			]
		);

        $this->add_control(
			'team_slider',
			[
				'label' => esc_html__( 'team List', 'adina' ),
				'type' =>  Controls_Manager::REPEATER,
				'fields' => $team_repeat->get_controls(),
				'default' => [
					[
                        'team_image'          => Utils::get_placeholder_image_src(),
                        'team_bg_image'       => Utils::get_placeholder_image_src(),
						'team_title'          => esc_html__( 'Rebecca Tylor', 'adina' ),
                        'workers_designation' => esc_html__( 'SEO - Founder', 'adina' ),
                        'team_link'           => esc_html__( '#', 'adina' ),
                        'icon01_select'       => esc_html__( 'facebook', 'adina' ),
                        'icon02_select'       => esc_html__( 'twitter', 'adina' ),
                        'icon03_select'       => esc_html__( 'instagram', 'adina' ),
                        'icon04_select'       => esc_html__( 'linkedin', 'adina' ),
                        'fb_url'              => esc_html__( '#', 'adina' ),
                        'tw_url'              => esc_html__( '#', 'adina' ),
                        'insta_url'           => esc_html__( '#', 'adina' ),
                        'linkedin_url'        => esc_html__( '#', 'adina' ),
                        'contact_icon'        => esc_html__( 'icon-out-call', 'adina' ),
                        'contact_nmbr'        => esc_html__( '+70 264 566 579', 'adina' ),
                        'contact_url'         => esc_html__( '#', 'adina' ),

					],
                    [
                        'team_image'          => Utils::get_placeholder_image_src(),
                        'team_bg_image'       => Utils::get_placeholder_image_src(),
						'team_title'          => esc_html__( 'Rebecca Tylor', 'adina' ),
                        'workers_designation' => esc_html__( 'SEO - Founder', 'adina' ),
                        'team_link'           => esc_html__( '#', 'adina' ),
                        'icon01_select'       => esc_html__( 'facebook', 'adina' ),
                        'icon02_select'       => esc_html__( 'twitter', 'adina' ),
                        'icon03_select'       => esc_html__( 'instagram', 'adina' ),
                        'icon04_select'       => esc_html__( 'linkedin', 'adina' ),
                        'fb_url'              => esc_html__( '#', 'adina' ),
                        'tw_url'              => esc_html__( '#', 'adina' ),
                        'insta_url'           => esc_html__( '#', 'adina' ),
                        'linkedin_url'        => esc_html__( '#', 'adina' ),
                        'contact_icon'        => esc_html__( 'icon-out-call', 'adina' ),
                        'contact_nmbr'        => esc_html__( '+70 264 566 579', 'adina' ),
                        'contact_url'         => esc_html__( '#', 'adina' ),

					],
                    [
                        'team_image'          => Utils::get_placeholder_image_src(),
                        'team_bg_image'       => Utils::get_placeholder_image_src(),
						'team_title'          => esc_html__( 'Rebecca Tylor', 'adina' ),
                        'workers_designation' => esc_html__( 'SEO - Founder', 'adina' ),
                        'team_link'           => esc_html__( '#', 'adina' ),
                        'icon01_select'       => esc_html__( 'facebook', 'adina' ),
                        'icon02_select'       => esc_html__( 'twitter', 'adina' ),
                        'icon03_select'       => esc_html__( 'instagram', 'adina' ),
                        'icon04_select'       => esc_html__( 'linkedin', 'adina' ),
                        'fb_url'              => esc_html__( '#', 'adina' ),
                        'tw_url'              => esc_html__( '#', 'adina' ),
                        'insta_url'           => esc_html__( '#', 'adina' ),
                        'linkedin_url'        => esc_html__( '#', 'adina' ),
                        'contact_icon'        => esc_html__( 'icon-out-call', 'adina' ),
                        'contact_nmbr'        => esc_html__( '+70 264 566 579', 'adina' ),
                        'contact_url'         => esc_html__( '#', 'adina' ),

					],
				],
			]
		);

        $this->end_controls_section();

        /********* Image Style *********/
        $this->start_controls_section(
            'team_img_style',
            [
                'label' => __( 'Image', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

		$this->add_responsive_control(
            'width',
            [
                'label'          => __('Width', 'adina'),
                'type'           => Controls_Manager::SLIDER,
                'size_units'     => ['%', 'px','vw'],
                'range'          => [
                    '%'  => [
                        'min' => 1,
                        'max' => 100,
                    ],
                    'px' => [
                        'min' => 1,
                        'max' => 1000,
                    ],
                    'vw' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                ],
                'selectors'      => [
                    '{{WRAPPER}} .team-one__single-img .inner img, .team-three__single-img img, .team-two__single-img .inner img' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'height',
            [
                'label'          => __('Height', 'adina'),
                'type'           => Controls_Manager::SLIDER,
                'size_units'     => ['px','%', 'vh'],
                'range'          => [
                    'px' => [
                        'min' => 1,
                        'max' => 1000,
                    ],
					'%'  => [
                        'min' => 1,
                        'max' => 100,
                    ],
                    'vh' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                ],
                'selectors'      => [
                    '{{WRAPPER}} .team-one__single-img .inner img, .team-three__single-img img, .team-two__single-img .inner img' => 'height: {{SIZE}}{{UNIT}} !important;',
                ],
            ]
        );
        $this->add_responsive_control(
            'img_object-fit',
            [
                'label'     => __('Object Fit', 'adina'),
                'type'      => Controls_Manager::SELECT,
                'condition' => [
                    'height[size]!' => '',
                ],
                'options'   => [
                    ''        => __('Default', 'adina'),
                    'fill'    => __('Fill', 'adina'),
                    'cover'   => __('Cover', 'adina'),
                    'contain' => __('Contain', 'adina'),
                ],
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .team-one__single-img .inner img, .team-three__single-img img, .team-two__single-img .inner img' => 'object-fit: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'img_object-position',
            [
                'label'     => __('Object Position', 'adina'),
                'type'      => Controls_Manager::SELECT,
                'condition' => [
                    'height[size]!' => '',
                ],
                'options'   => [
                    ''        => __('Default', 'adina'),
                    'center top' => __('Center Top', 'adina'),
                    'center bottom'   => __('Center Bottom', 'adina'),
                    'center left' => __('Center Left', 'adina'),
                    'center right' => __('Center Right', 'adina'),
                ],
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .team-one__single-img .inner img, .team-three__single-img img, .team-two__single-img .inner img' => 'object-position: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

		/********* Title Style *********/
        $this->start_controls_section(
            'title_style',
            [
                'label' => __( 'Title', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
		$this->start_controls_tabs(
            'title_style_tabs'
        );
		$this->start_controls_tab(
            'title_normal_tab',
            [
                'label' => esc_html__( 'Normal', 'adina' ),
            ]
        );

		$this->add_control(
            'title_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .team-one__single-content h3, .team-three__single-content h3 a, .team-two__single-content h3 a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'selector' => '{{WRAPPER}} .team-one__single-content h3, .team-three__single-content h3, .team-two__single-content h3',
			]
		);
        $this->add_responsive_control(
            'title_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .team-one__single-content h3, .team-three__single-content h3, .team-two__single-content h3' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'title_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .team-one__single-content h3, .team-three__single-content h3, .team-two__single-content h3' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();

		$this->start_controls_tab(
            'title_hover_tab',
            [
                'label' => esc_html__( 'Hover', 'adina' ),
				'condition' => [
                    'height[size]!' => '',
                ],
            ]
        );
		$this->add_control(
            'title_hover_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .team-one__single-content h3 a:hover, .team-three__single-content h3 a:hover, .team-two__single-content h3 a:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();

		/********* Designation Style *********/
        $this->start_controls_section(
            'designation_style',
            [
                'label' => __( 'Designation', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

		$this->add_control(
            'designation_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .team-one__single-content p, .team-three__single-content p, .team-two__single-content p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'designation_typography',
				'selector' => '{{WRAPPER}} .team-one__single-content p, .team-three__single-content p, .team-two__single-content p',
			]
		);
        $this->add_responsive_control(
            'designation_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .team-one__single-content p, .team-three__single-content p, .team-two__single-content p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'designation_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .team-one__single-content p, .team-three__single-content p, .team-two__single-content p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

		/********* Social Icon Style *********/
        $this->start_controls_section(
            'social_icon_style',
            [
                'label' => __( 'Social Icon', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
		$this->start_controls_tabs(
            'social_icon_style_tabs'
        );
		$this->start_controls_tab(
            'social_icon_normal_style',
            [
                'label' => esc_html__( 'Normal', 'adina' ),
            ]
        );

		$this->add_control(
            'social_icon_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .team-one__single-img .inner .social-links a, .team-three__single-content .social-links a, .team-two__single-img .inner .social-links a' => 'color: {{VALUE}}',
                ],
            ]
        );
		$this->add_control(
            'social_icon_bg_color',
            [
                'label' => __('Background Color(layout 1 & 2)', 'adina'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .team-one__single-img .inner .social-links::before, .team-three__single-content .social-links' => 'background-color: {{VALUE}}',
                ],
            ]
        );
		$this->add_control(
            'social_icon_font_size',
            [
                'label' => __( 'Font Size', 'adina' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', 'em', '%' ],
                'default' => [
                    'unit' => 'px',
                    'size' => 15,
                ],
				'selectors'      => [
                    '{{WRAPPER}} .team-one__single-img .inner .social-links a span, .team-three__single-content .social-links a, .team-two__single-img .inner .social-links a' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_tab();

        $this->start_controls_tab(
            'social_icon_hover_tab',
            [
                'label' => esc_html__( 'Hover', 'adina' ),
            ]
        );
		$this->add_control(
            'social_icon_hover_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .team-one__single-img .inner .social-links a:hover, .team-three__single-content .social-links a:hover, .team-two__single-img .inner .social-links a:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
		$this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();

		/********* Content Box Style *********/
        $this->start_controls_section(
            'content_box_style',
            [
                'label' => __( 'Content Box', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->start_controls_tabs(
            'content_box_style_tabs'
        );
        $this->start_controls_tab(
            'content_box_normal_tab',
            [
                'label' => esc_html__( 'Normal', 'adina' ),
            ]
        );

        $this->add_control(
            'content_box_bg_color',
            [
                'label' => __('Background Color', 'adina'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .team-one__single-content::before, .team-three__single-content, .team-two__single' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'content_box_border',
                'selector' => '{{WRAPPER}} .team-one__single::after, .team-three__single-content, .team-two__single-content',
            ]
        );
        $this->add_control(
            'content_box_radius',
            [
                'label' => esc_html__( 'Border Radius', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'selectors' => [
                    '{{WRAPPER}} .team-one__single::after, .team-three__single-content, .team-two__single-content' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'content_box_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .team-one__single-content, .team-three__single-content, .team-two__single-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'content_box_hover_tab',
            [
                'label' => esc_html__( 'Hover', 'adina' ),
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'content_box_hover_border',
                'selector' => '{{WRAPPER}} .team-one__single:hover::after, .team-three__single:hover .team-three__single-content, .team-two__single-content:hover',
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();

		/********* Box Style *********/
        $this->start_controls_section(
            'box_style',
            [
                'label' => __( 'Box', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
				'condition' => [
                    'team_layout' => 'layout-1',
                ],
            ]
        );
        $this->start_controls_tabs(
            'box_style_tabs'
        );
        $this->start_controls_tab(
            'box_normal_tab',
            [
                'label' => esc_html__( 'Normal', 'adina' ),
            ]
        );
        $this->add_control(
            'box_bg_color',
            [
                'label' => __('Background Color', 'adina'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .team-one__single::before' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();

        $this->start_controls_tab(
            'box_hover_tab',
            [
                'label' => esc_html__( 'Hover', 'adina' ),
            ]
        );
        $this->add_control(
            'box_hover_bg_color',
            [
                'label' => __('Background Color', 'adina'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .team-one__single:hover::before' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();

        /********* call Style *********/
        $this->start_controls_section(
            'call_style',
            [
                'label' => __( 'call', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
				'condition' => [
                    'team_layout' => 'layout-2',
                ],
            ]
        );
        $this->add_control(
            'call_icon_color',
            [
                'label' => __('Icon Color', 'adina'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .team-two__single-number>ul>li.icon-box>a>span' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'call_icon_bg_color',
            [
                'label' => __('Icon Background', 'adina'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .team-two__single-number>ul>li.icon-box>a' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'call_icon_text_color',
            [
                'label' => __('Number Color', 'adina'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .team-two__single-number>ul>li>ul>li>p>a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'call_icon_text_hover_color',
            [
                'label' => __('Number Hover Color', 'adina'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .team-two__single-number>ul>li>ul>li>p>a:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_section();

       
    }

    protected function render() {
        $settings = $this->get_settings_for_display();

		$slider_extraSetting = array(
	        'autoplay' => (!empty($settings['autoplay']) && 'yes' === $settings['autoplay']) ? true : false,
            'drag' => (!empty($settings['drag']) && 'yes' === $settings['drag']) ? true : false,
            'dots' => (!empty($settings['dots']) && 'yes' === $settings['dots']) ? true : false,
        	'autoplaytimeout' => !empty($settings['autoplaytimeout']) ? $settings['autoplaytimeout'] : '5000',

        	//this a responsive layout
            'per_coulmn' =>        (!empty($settings['per_coulmn'])) ? $settings['per_coulmn'] : 3,
            'per_coulmn_tablet' => (!empty($settings['per_coulmn_tablet'])) ? $settings['per_coulmn_tablet'] : 2,
            'per_coulmn_mobile' => (!empty($settings['per_coulmn_mobile'])) ? $settings['per_coulmn_mobile'] : 1
        );
		$jasondecode = wp_json_encode($slider_extraSetting);

		if ( ( 'yes' == $settings['show_slider_settings'] ) ) {
            $this->add_render_attribute('team_version', 'class', ['row team-slider']);
            $this->add_render_attribute('team_version', 'data-settings', $jasondecode);
            $this->add_render_attribute('team_gride_classes', 'class', ['item']);
        } else {
            $this->add_render_attribute('team_version', 'class', ['row']);
            //gride class
            $grid_classes = [];
            $grid_classes[] = 'col-xl-' . $settings['per_line'];
            $grid_classes[] = 'col-md-' . $settings['per_line_tablet'];
            $grid_classes[] = 'col-sm-' . $settings['per_line_mobile'];
            $grid_classes = implode(' ', $grid_classes);
            $this->add_render_attribute('team_gride_classes', 'class', [$grid_classes]);
        }

        $layout = $settings['team_layout'];
        $slides = $settings[ 'team_slider' ];
        
        ?>       

			<?php
                if ( $layout) {
                    include('team/'.$layout.'.php');
                }
            ?> 

        <?php
    }
}
$widgets_manager->register(new \Elementor\AdinaTeam());

