<?php
/**
 * Happyden Team Widget.
 *
 *
 * @since 1.0.0
 */
namespace Elementor;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\Widget_Base;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Css_Filter;
use Elementor\Icons_Manager;
use Elementor\Utils;
use Elementor\Repeater;
use Elementor\URL;
use \Elementor\Control_Media;

if (!defined('ABSPATH')) {
    exit;
}
// If this file is called directly, abort.
class AdinaTestimonialOne extends Widget_Base {
    public function get_name() {
        return 'adina-testimonial-one';
    }
    public function get_title() {
        return __('Testimonial One', 'adina');
    }
    public function get_icon() {
        return ('eicon-person');
    }
    public function get_categories() {
        return ['adina-addons'];
    }
    public function get_keywords() {
        return ['Testimonial', 'Slider', 'Slick'];
    }

    protected function register_controls() {

        $this->start_controls_section(
            'test_one_settings',
            [
                'label' => __('Testimonial Settings', 'adina'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'show_slider_settings',
            [
                'label' => __('Slider Active', 'adina'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'adina'),
                'label_off' => __('No', 'adina'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );


        $this->add_responsive_control('per_line', [
            'label'              => __('Columns per row', 'adina'),
            'type'               => Controls_Manager::SELECT,
            'default'            => '3',
            'tablet_default'     => '6',
            'mobile_default'     => '12',
            'options'            => [
                '12' => '1',
                '6'  => '2',
                '4'  => '3',
                '3'  => '4',
            ],
            'frontend_available' => true,
            'condition'   => [ 'show_slider_settings' => '', ]
        ]);


        $this->add_responsive_control(
            'gap_bottom',
            [
                'label'          => __('Gap Bottom', 'adina'),
                'type'           => Controls_Manager::SLIDER,
                'size_units'     => ['px', '%'],
                'range'          => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors'      => [
                    '{{WRAPPER}} .testimonials-one__single' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        //Slider Setting
        $this->start_controls_section('slider_settings',
        [
            'label' => __('Slider Settings', 'adina'),
            'tab'   => Controls_Manager::TAB_CONTENT,
            'condition' => [ 'show_slider_settings' => 'yes',  ]
            ]
        );

        $this->add_responsive_control(
            'per_coulmn',
            [
                'label' => __( 'Slider Items', 'adina' ),
                'type' => Controls_Manager::SELECT,
                'default'            => 3,
                'tablet_default'     => 2,
                'mobile_default'     => 1,
                'options'            => [
                    '1' => '1',
                    '2' => '2',
                    '3' => '3',
                    '4' => '4',
                    '5' => '5',
                    '6' => '6',
                ],
                'frontend_available' => true,
            ]
        );
        $this->add_responsive_control(
			'gap_right_left',
			[
				'label'          => __('Row Gap(Right-Left)', 'adina'),
				'type'           => Controls_Manager::SLIDER,
				'size_units'     => ['px', '%'],
				'range'          => [
					'px' => [
						'min' => 0,
						'max' => 1000,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors'      => [
					'{{WRAPPER}} .testimonials-one__single' => 'margin-right: {{SIZE}}{{UNIT}}; margin-left: {{SIZE}}{{UNIT}};',
				],
			]
		);
        $this->add_control(
            'dots',
            [
                'label' => __( 'Dots?', 'adina' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'adina' ),
                'label_off' => __( 'Hide', 'adina' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'drag',
            [
                'label' => __( 'Drag?', 'adina' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'adina' ),
                'label_off' => __( 'Hide', 'adina' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'autoplay',
            [
                'label' => __( 'Auto Play?', 'adina' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'adina' ),
                'label_off' => __( 'Hide', 'adina' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'autoplaytimeout',
            [
                'label' => __( 'Autoplay Timeout', 'adina' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'label_block' => true,
                'default' => '5000',
                'options' => [
                    '1000'  => __( '1 Second', 'adina' ),
                    '2000'  => __( '2 Second', 'adina' ),
                    '3000'  => __( '3 Second', 'adina' ),
                    '4000'  => __( '4 Second', 'adina' ),
                    '5000'  => __( '5 Second', 'adina' ),
                    '6000'  => __( '6 Second', 'adina' ),
                    '7000'  => __( '7 Second', 'adina' ),
                    '8000'  => __( '8 Second', 'adina' ),
                    '9000'  => __( '9 Second', 'adina' ),
                    '10000' => __( '10 Second', 'adina' ),
                    '11000' => __( '11 Second', 'adina' ),
                    '12000' => __( '12 Second', 'adina' ),
                    '13000' => __( '13 Second', 'adina' ),
                    '14000' => __( '14 Second', 'adina' ),
                    '15000' => __( '15 Second', 'adina' ),
                ],
                'condition' => [
                    'autoplay' => 'yes',
                ],
            ]
        );
        $this->end_controls_section();
		// End Slider settings
        
        $this->start_controls_section(
            'Testimonial_section',
            [
                'label' => __('Testimonila Section', 'adina'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
        $testimonial_repeater = new Repeater();

        $testimonial_repeater->add_control(
			'testimonial02_icon',
			[
				'label' => esc_html__( 'Here you can use Fontawsome or Icomoon Class', 'adina' ),
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'fas fa-heart', 'adina' ),
				'label_block' => true,
			]
		);
        $testimonial_repeater->add_control(
			'testimonial_image',
			[
				'label' => esc_html__( 'Image', 'adina' ),
				'type' =>  Controls_Manager::MEDIA,
				'default' => [
					'url' =>  Utils::get_placeholder_image_src(),
				],
			]
		);
        $testimonial_repeater->add_control(
			'testimonial_title',
			[
				'label' => esc_html__( 'Title', 'adina' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Rebecca Jr.', 'adina' ),
				'label_block' => true,
			]
		);
        $testimonial_repeater->add_control(
			'testimonial_title_link',
			[
				'label' => esc_html__( 'Title Url', 'adina' ),
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__( '#', 'adina' ),
				'label_block' => true,
			]
		);
        $testimonial_repeater->add_control(
			'testimonial_client_title',
			[
				'label' => esc_html__( 'Client Title', 'adina' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Client', 'adina' ),
				'label_block' => true,
			]
		);
        $testimonial_repeater->add_control(
			'testimonial_rating_text',
			[
				'label' => esc_html__( 'Rating Text', 'adina' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( '“Good Services”', 'adina' ),
				'label_block' => true,
			]
		);

        $testimonial_repeater->add_control(
            'adina_t_rating',
            [
                'label'     => __( 'Customar Rating', 'adina' ),
                'type'      =>  Controls_Manager::SELECT,
                'default'   => '5',
                'options'   => [
                    'none' => __( 'none', 'adina' ),
                    '1'    => __( '1', 'adina' ),
                    '2'    => __( '2', 'adina' ),
                    '3'    => __( '3', 'adina' ),
                    '4'    => __( '4', 'adina' ),
                    '5'    => __( '5', 'adina' ),
                ],
                
            ]
        );
        $testimonial_repeater->add_control(
			'testimonial_content',
			[
				'label' => esc_html__( 'Content', 'adina' ),
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut
                fugit some
                sed quia consequuntur dolores sequi nesciunt.', 'adina' ),
				'label_block' => true,
			]
		);
        $this->add_control(
			'adina_testimonial_slides',
			[
				'label' => esc_html__( 'Slider List', 'adina' ),
				'type' =>  Controls_Manager::REPEATER,
				'fields' => $testimonial_repeater->get_controls(),
				'default' => [
					[
						'testimonial_image'        => Utils::get_placeholder_image_src(),
						'testimonial_title'        => esc_html__( 'Rebecca Jr.', 'adina' ),
                        'testimonial_title_link'   => esc_html__( '#', 'adina' ),
                        'testimonial02_icon'       => esc_html__( 'fas fa-heart', 'adina' ),
						'testimonial_client_title' => esc_html__( 'Client', 'adina' ),
						'testimonial_rating_text'  => esc_html__( '“Good Services”', 'adina' ),
						'testimonial_content'      => esc_html__( 'Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut
                        fugit some
                        sed quia consequuntur dolores sequi nesciunt.', 'adina' ),
					],
                    [
						'testimonial_image'        => Utils::get_placeholder_image_src(),
						'testimonial_title'        => esc_html__( 'Rebecca Jr.', 'adina' ),
                        'testimonial_title_link'   => esc_html__( '#', 'adina' ),
                        'testimonial02_icon'       => esc_html__( 'fas fa-heart', 'adina' ),
						'testimonial_client_title' => esc_html__( 'Client', 'adina' ),
						'testimonial_rating_text'  => esc_html__( '“Good Services”', 'adina' ),
						'testimonial_content'      => esc_html__( 'Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut
                        fugit some
                        sed quia consequuntur dolores sequi nesciunt.', 'adina' ),
					],
                    [
						'testimonial_image'        => Utils::get_placeholder_image_src(),
						'testimonial_title'        => esc_html__( 'Rebecca Jr.', 'adina' ),
                        'testimonial_title_link'   => esc_html__( '#', 'adina' ),
                        'testimonial02_icon'       => esc_html__( 'fas fa-heart', 'adina' ),
						'testimonial_client_title' => esc_html__( 'Client', 'adina' ),
						'testimonial_rating_text'  => esc_html__( '“Good Services”', 'adina' ),
						'testimonial_content'      => esc_html__( 'Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut
                        fugit some
                        sed quia consequuntur dolores sequi nesciunt.', 'adina' ),
					],
				],
			]
		);
        $this->end_controls_section();


         /********* End Style Controls /*********/
         /////////////// Testimonial image /////////////////////
         $this->start_controls_section(
            '_testimonial_image_style',
            [
                'label' => __( 'Images', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
            'width',
            [
                'label'          => __('Width', 'adina'),
                'type'           => Controls_Manager::SLIDER,
                'size_units'     => ['%', 'px','vw'],
                'range'          => [
                    '%'  => [
                        'min' => 1,
                        'max' => 100,
                    ],
                    'px' => [
                        'min' => 1,
                        'max' => 1000,
                    ],
                    'vw' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                ],
                'selectors'      => [
                    '{{WRAPPER}} .testimonials-one__single-top .img-box img' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'space',
            [
                'label'          => __('Max Width', 'adina'),
                'type'           => Controls_Manager::SLIDER,
                'size_units'     => ['px', '%', 'vw'],
                'range'          => [
                    '%'  => [
                        'min' => 1,
                        'max' => 100,
                    ],
                    'px' => [
                        'min' => 1,
                        'max' => 1000,
                    ],
                    'vw' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                ],
                'selectors'      => [
                    '{{WRAPPER}} .testimonials-one__single-top .img-box img' => 'max-width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'height',
            [
                'label'          => __('Height', 'adina'),
                'type'           => Controls_Manager::SLIDER,
                'size_units'     => ['px', 'vh'],
                'range'          => [
                    'px' => [
                        'min' => 1,
                        'max' => 1000,
                    ],
                    'vh' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                ],
                'selectors'      => [
                    '{{WRAPPER}} .testimonials-one__single-top .img-box img' => 'height: {{SIZE}}{{UNIT}} !important;',
                ],
            ]
        );
        $this->add_responsive_control(
            'object-fit',
            [
                'label'     => __('Object Fit', 'adina'),
                'type'      => Controls_Manager::SELECT,
                'condition' => [
                    'height[size]!' => '',
                ],
                'options'   => [
                    ''        => __('Default', 'adina'),
                    'fill'    => __('Fill', 'adina'),
                    'cover'   => __('Cover', 'adina'),
                    'contain' => __('Contain', 'adina'),
                ],
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .testimonials-one__single-top .img-box img' => 'object-fit: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'object-posiction',
            [
                'label'     => __('Object Position', 'adina'),
                'type'      => Controls_Manager::SELECT,
                'condition' => [
                    'height[size]!' => '',
                ],
                'options'   => [
                    ''        => __('Default', 'adina'),
                    'center top' => __('Center Top', 'adina'),
                    'center bottom'   => __('Center Bottom', 'adina'),
                    'center left' => __('Center Left', 'adina'),
                    'center right' => __('Center Right', 'adina'),
                ],
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .testimonials-one__single-top .img-box img' => 'object-position: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'testimonial_border',
                'selector' => '{{WRAPPER}} .testimonials-one__single-top .img-box img',
            ]
        );
        $this->add_control(
            'testimonial_border_radius',
            [
                'label' => esc_html__( 'Border Radius', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'selectors' => [
                    '{{WRAPPER}} .testimonials-one__single-top .img-box img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'testimonial01_image_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .testimonials-one__single-top .img-box img' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'testimonial01_image_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .testimonials-one__single-top .img-box img' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        /////////////Testimonial title//////////////////////
        $this->start_controls_section(
            '__testimonial_title_style',
            [
                'label' => __( 'Title', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        /////////// Normal Title/////////////////
        $this->start_controls_tabs(
            'style_tabs'
        );
        
        $this->start_controls_tab(
            'testimonial_normal_tab',
            [
                'label' => esc_html__( 'Normal', 'adina' ),
            ]
        );
        $this->add_control(
            'testimonial_title_color',
            [
                'label' => __( 'Title Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testimonials-one__single-top .title-box h2 a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'testimonial_title_typography',
				'selector' => '{{WRAPPER}} .testimonials-one__single-top .title-box h2 a',
			]
		);
        $this->add_responsive_control(
            'testimonial_title_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .testimonials-one__single-top .title-box h2 a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'testimonial_title_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .testimonials-one__single-top .title-box h2 a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();

        ///////////////Hover Title //////////////////////
        $this->start_controls_tab(
            'testimonial_hover_tab',
            [
                'label' => esc_html__( 'Hover', 'adina' ),
            ]
        );
        $this->add_control(
            'testimonial_title02_color',
            [
                'label' => __( 'Title Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testimonials-one__single-top .title-box h2 a:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'testimonial_title02_background',
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} .testimonials-one__single-top .title-box h2 a:hover',
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();



        ///////////////// Client title////////////////////////////
        $this->start_controls_section(
            '_testimonial_client_text',
            [
                'label' => __( 'Client Text', 'tocore' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'testimonial_client_text_color',
            [
                'label' => __( ' Client Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testimonials-one__single-top .title-box p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'client_title_typography',
				'selector' => '{{WRAPPER}} .testimonials-one__single-top .title-box p',
			]
		);
        $this->add_responsive_control(
            'testimonial_client_text_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .testimonials-one__single-top .title-box p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'testimonial_client_text_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .testimonials-one__single-top .title-box p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        ////////////// Reting text/////////////////////
        $this->start_controls_section(
            '_testimonial_rating_text',
            [
                'label' => __( 'Rating text', 'tocore' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'testimonial_rating_text_color',
            [
                'label' => __( ' Rating Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testimonials-one__single-inner .content-box-top .text-box h3' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'rating_title_typography',
				'selector' => '{{WRAPPER}} .testimonials-one__single-inner .content-box-top .text-box h3',
			]
		);
        $this->add_responsive_control(
            'testimonial_rating_text_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .testimonials-one__single-inner .content-box-top .text-box h3' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'testimonial_rating_text_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .testimonials-one__single-inner .content-box-top .text-box h3' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        // ////////////Star icon  rating cilor////////////////////
        $this->start_controls_section(
            'rating_icon_color',
            [
                'label' => __( 'Rating Icon Color', 'tocore' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'testimonial_rating_icon_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .rating-box .active_color' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_section();
        

        ////////////// Content/////////////////////
        $this->start_controls_section(
            '_testimonial_content_text',
            [
                'label' => __( 'Content text', 'tocore' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'testimonial_content_text_color',
            [
                'label' => __( ' Content Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testimonials-one__single-inner .content-box p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'content_title_typography',
                'selector' => '{{WRAPPER}} .testimonials-one__single-inner .content-box p',
            ]
        );
        $this->add_responsive_control(
            'testimonial_content_text_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .testimonials-one__single-inner .content-box p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'testimonial_content_text_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .testimonials-one__single-inner .content-box p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();


       //////////////// Box Border/////////////////////
        $this->start_controls_section(
            '__testimonial_box_boder',
            [
                'label' => __( 'Box', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        /////////// Normal  box border/////////////////
        $this->start_controls_tabs(
            'style_tabss'
        );
        
        $this->start_controls_tab(
            'testimonial_box_border_tab',
            [
                'label' => esc_html__( 'Normal', 'adina' ),
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'normal_text_border',
                'selector' => '{{WRAPPER}} .testimonials-one__single .border-left',
            ]
        );
        $this->add_control(
            'Normal_text_border_radius',
            [
                'label' => esc_html__( 'Border Radius', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'selectors' => [
                    '{{WRAPPER}} .testimonials-one__single .border-left' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'background',
				'types' => [ 'classic', 'gradient', 'video' ],
				'selector' => '{{WRAPPER}} .testimonials-one__single .border-left .testimonials-one__single::before',
			]
		);
		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'box_shadow',
				'selector' => '{{WRAPPER}} .testimonials-one__single .border-left',
			]
		);
        $this->end_controls_tab();

        ///////////////Hover box border  //////////////////////
        $this->start_controls_tab(
            'testimonial_box_border_hover',
            [
                'label' => esc_html__( 'Hover', 'adina' ),
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'hover__border',
                'selector' => '{{WRAPPER}} .testimonials-one__single:hover .border-left',
            ]
        );
        $this->add_control(
            'hover_border_radius',
            [
                'label' => esc_html__( 'Border Radius', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'selectors' => [
                    '{{WRAPPER}} .testimonials-one__single:hover .border-left .testimonials-one__single:hover::after' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'hover_background',
				'types' => [ 'classic', 'gradient', 'video' ],
				'selector' => '{{WRAPPER}} .testimonials-one__single:hover::after',
			]
		);
        $this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'boder-box_shadow',
				'selector' => '{{WRAPPER}} .testimonials-one__single:hover .border-left .testimonials-one__single:hover::after',
			]
		);
        $this->end_controls_tabs();
        $this->end_controls_section();
        



 
        


        /********* End Style Controls /*********/

    }

    protected function render() {
        $settings = $this->get_settings_for_display();

        //this code course slider option
		$slider_extraSetting = array(
	        'autoplay' => (!empty($settings['autoplay']) && 'yes' === $settings['autoplay']) ? true : false,
            'drag' => (!empty($settings['drag']) && 'yes' === $settings['drag']) ? true : false,
            'dots' => (!empty($settings['dots']) && 'yes' === $settings['dots']) ? true : false,
        	'autoplaytimeout' => !empty($settings['autoplaytimeout']) ? $settings['autoplaytimeout'] : '5000',

        	//this a responsive layout
            'per_coulmn' =>        (!empty($settings['per_coulmn'])) ? $settings['per_coulmn'] : 3,
            'per_coulmn_tablet' => (!empty($settings['per_coulmn_tablet'])) ? $settings['per_coulmn_tablet'] : 2,
            'per_coulmn_mobile' => (!empty($settings['per_coulmn_mobile'])) ? $settings['per_coulmn_mobile'] : 1
        );
		$jasondecode = wp_json_encode($slider_extraSetting);

        if ( ( 'yes' == $settings['show_slider_settings'] ) ) {
            $this->add_render_attribute('testimonial_one_version', 'class', ['row testimonial-one-slider']);
            $this->add_render_attribute('testimonial_one_version', 'data-settings', $jasondecode);
            $this->add_render_attribute('testimonial_one_gride_classes', 'class', ['item']);
        } else {
            $this->add_render_attribute('testimonial_one_version', 'class', ['row']);
            //gride class
            $grid_classes = [];
            $grid_classes[] = 'col-xl-' . $settings['per_line'];
            $grid_classes[] = 'col-md-' . $settings['per_line_tablet'];
            $grid_classes[] = 'col-sm-' . $settings['per_line_mobile'];
            $grid_classes = implode(' ', $grid_classes);
            $this->add_render_attribute('testimonial_one_gride_classes', 'class', [$grid_classes]);
        }

        $slides = $settings[ 'adina_testimonial_slides' ];
        
        ?>

            <!--Start Testimonials One-->
            <section class="testimonials-one">
                <div class="container">
                    <div <?php echo $this->get_render_attribute_string('testimonial_one_version'); ?> >
                        <?php foreach( $slides as $slide  ): ?>
                            <div <?php echo $this->get_render_attribute_string('testimonial_one_gride_classes'); ?> >
                                <div class="swiper-slide">
                                    <!--Start Single Testimonials One-->
                                    <div class="testimonials-one__single">
                                        <!-- Icon class depend -->
                                        <?php if( !empty( $slide[ 'testimonial02_icon' ] ) ): ?>
                                            <div class="icon-box"><span class="<?php echo adina_kses( $slide[ 'testimonial02_icon' ] ); ?>"></span></div>
                                        <?php endif; ?>
                                        <div class="border-left"></div>
                                        <div class="testimonials-one__single-top">

                                            <!-- Images upload in here -->
                                            <?php if( !empty( $slide[ 'testimonial_image' ]['url'] ) ): ?>
                                            <div class="img-box">
                                                <img src="<?php echo esc_url( $slide[ 'testimonial_image' ]['url'] ); ?>" alt="">
                                            </div>
                                            <?php endif; ?>

                                            <div class="title-box">
                                                <!-- Title in here  -->
                                            <?php if( !empty( $slide[ 'testimonial_title' ] ) ): ?>
                                            <h2><a href="<?php echo esc_url( $slide[ 'testimonial_title_link' ] ); ?>"><?php echo adina_kses( $slide[ 'testimonial_title' ] ); ?></a></h2>
                                            <?php endif; ?>
                                            

                                            <!-- Client text in here -->
                                            <?php if ( !empty( $slide['testimonial_client_title']) ) : ?>
                                            <p><?php echo adina_kses( $slide['testimonial_client_title'] ); ?></p>
                                            <?php endif; ?>

                                            </div>
                                        </div>

                                        <div class="testimonials-one__single-inner">
                                            <div class="content-box">
                                                <div class="content-box-top">
                                                    <div class="text-box">
                                                        <!-- title in here -->
                                                        <?php if ( !empty( $slide['testimonial_rating_text']) ) : ?>
                                                        <h3><?php echo adina_kses( $slide['testimonial_rating_text'] ); ?></h3>
                                                        <?php endif; ?>
                                                    </div>
                                                    <span class="rating-box">
                                                        <?php for($i=0;$i<5; $i++): 
                                                                $class = '';
                                                            ?>
                                                            <?php if ($slide['adina_t_rating'] > $i) {
                                                                $class = "active_color";
                                                            } ?>
                                                            <a href="#" class="<?php echo esc_attr( $class ) ?>">
                                                                <i class="icon-star"></i>
                                                            </a>
                                                        <?php endfor; ?>
                                                    </span>
                                                </div>

                                                <!-- Discription in here -->
                                                <?php if ( !empty( $slide['testimonial_content']) ) : ?>
                                                    <p><?php echo adina_kses( $slide['testimonial_content'] ); ?></p>
                                                <?php endif; ?>

                                            </div>
                                        </div>
                                    </div>
                                    <!--End Single Testimonials One-->
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                    <!-- If we need navigation buttons -->
                    <div class="swiper-pagination" id="testimonials-one__pagination"></div>
                </div>
            </section>
            <!--End Testimonials One Area-->            


        <?php
    }
}
$widgets_manager->register(new \Elementor\AdinaTestimonialOne());

