<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Repeater;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Background;
/**
 *
 * Testimonial Slider Widget .
 *
 */
class Adina_Testimonial_Slider extends Widget_Base{

	public function get_name() {
		return 'adinatestimonialslider';
	}

	public function get_title() {
		return __( 'Testimonial Slider', 'adina' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'adina' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'testimonial_slider_section',
			[
				'label' 	=> __( 'Testimonial Slider', 'adina' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'testimonial_style',
			[
				'label' 		=> __( 'Testimonial Style', 'adina' ),
				'type' 			=> Controls_Manager::SELECT,
				'default' 		=> '1',
				'options' 		=> [
					'1'  			=> __( 'Style One', 'adina' ),
					'2' 			=> __( 'Style Two', 'adina' ),
				],
			]
		);

		$this->add_control(
			'quate_icon',
			[
				'label' 		=> __( 'Quate Icon', 'adina' ),
				'type' 			=> Controls_Manager::MEDIA,
				'default' 		=> [
					'url' => Utils::get_placeholder_image_src(),
				],
				'condition' => [
					'testimonial_style' => '2',
				]
			]
		);

		$this->add_control(
			'bg_image',
			[
				'label' 		=> __( 'Background', 'adina' ),
				'type' 			=> Controls_Manager::MEDIA,
				'default' 		=> [
					'url' => Utils::get_placeholder_image_src(),
				],
				'condition' => [
					'testimonial_style' => '1',
				]
			]
		);

		$this->add_control(
			'subtitle', [
				'label' 		=> __( 'Section Subtitle', 'adina' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'default' 		=> __( 'Happy Customer Quotes' , 'adina' ),
				'label_block' 	=> true,
				'condition' => [
					'testimonial_style' => '1',
				]
			]
        );
		$this->add_control(
			'title', [
				'label' 		=> __( 'Section Title', 'adina' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'default' 		=> __( 'Our Top Reviews' , 'adina' ),
				'label_block' 	=> true,
				'condition' => [
					'testimonial_style' => '1',
				]
			]
        );

		$repeater = new Repeater();

		$repeater->add_control(
			'rating',
			[
				'label' 		=> __( 'Rating', 'adina' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Yes', 'adina' ),
				'label_off' 	=> __( 'No', 'adina' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
			]
		);

        $repeater->add_control(
			'client_feedback', [
				'label' 		=> __( 'Client Feedback', 'adina' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'default' 		=> __( 'Contrary to popular belief, Lorem Ipsum is not simply random text over 2000 years old. Richard McClintock' , 'adina' ),
				'label_block' 	=> true,
			]
		);

		$repeater->add_control(
			'client_image',
			[
				'label' 		=> __( 'Client Image', 'adina' ),
				'type' 			=> Controls_Manager::MEDIA,
				'default' 		=> [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);
		$repeater->add_control(
			'client_name', [
				'label' 		=> __( 'Client Name', 'adina' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'default' 		=> __( 'Alax Markun' , 'adina' ),
				'label_block' 	=> true,
			]
        );
		$repeater->add_control(
			'client_designation', [
				'label' 		=> __( 'Client Designation', 'adina' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'default' 		=> __( 'CEO Google' , 'adina' ),
				'label_block' 	=> true,
			]
        );

		$this->add_control(
			'slides',
			[
				'label' 		=> __( 'Slides', 'adina' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'client_name' 		=> __( 'Alax Markun', 'adina' ),
						'client_feedback' 	=> __( 'Contrary to popular belief, Lorem Ipsum is not simply random text over 2000 years old. Richard McClintock', 'adina' ),
						'client_image' 		=> Utils::get_placeholder_image_src(),
					],
					[
						'client_name' 		=> __( 'Vivi Marian', 'adina' ),
						'client_feedback' 	=> __( 'Contrary to popular belief, Lorem Ipsum is not simply random text over 2000 years old. Richard McClintock', 'adina' ),
						'client_image' 		=> Utils::get_placeholder_image_src(),
					],
				],
				'title_field' 	=> '{{{ client_name }}}',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'slider_control_section',
			[
				'label' 		=> __( 'Slider Control', 'adina' ),
				'tab' 			=> Controls_Manager::TAB_CONTENT,
			]
        );
		$this->add_control(
			'slide_to_show',
			[
				'label' 		=> __( 'Slide To Show', 'adina' ),
				'type' 			=> Controls_Manager::SLIDER,
				'size_units' 	=> [ 'px' ],
				'range' 		=> [
					'px' 			=> [
						'min' 			=> 0,
						'max' 			=> 10,
						'step'			=> 1,
					],
				],
				'default' 	=> [
					'unit' 		=> 'px',
					'size' 		=> 1,
				],
			]
		);
		$this->add_control(
			'slider_arrows',
			[
				'label' 		=> __( 'Arrows', 'adina' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Yes', 'adina' ),
				'label_off' 	=> __( 'No', 'adina' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
			]
		);

        $this->end_controls_section();

		$this->start_controls_section(
			'testimonial_general',
			[
				'label' 	=> __( 'General', 'adina' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );

		
		$this->add_control(
			'testimonial_rating_color',
			[
				'label' 		=> __( ' Star Color', 'adina' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .testi-style1 .testi-rating, {{WRAPPER}} .testi-style2 .arrow-shape' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'bg_color',
			[
				'label' 		=> __( ' Box Background', 'adina' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .testi-style1, {{WRAPPER}} .testi-style2' => 'background-color: {{VALUE}}',
				],
			]
		);


		$this->add_responsive_control(
			'box_margin',
			[
				'label' 		=> __( 'Margin', 'adina' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .testi-style1, {{WRAPPER}} .testi-style2' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);
		
		$this->add_responsive_control(
			'box_padding',
			[
				'label' 		=> __( 'Padding', 'adina' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .testi-style1, {{WRAPPER}} .testi-style2' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);
		$this->end_controls_section();

        $this->start_controls_section(
			'testimonial_slider_client_name_style_section',
			[
				'label' 	=> __( 'Client Name', 'adina' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );

        $this->add_control(
			'testimonial_slider_client_name_color',
			[
				'label' 		=> __( 'Client Name Color', 'adina' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .testi-style1 .testi-name' => 'color: {{VALUE}}!important',
				],
			]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'testimonial_slider_client_name_typography',
				'label' 	=> __( 'Client Name Typography', 'adina' ),
				'selector' 	=> '{{WRAPPER}} .testi-style1 .testi-name',
			]
        );

        $this->add_responsive_control(
			'testimonial_slider_client_name_margin',
			[
				'label' 		=> __( 'Client Name Margin', 'adina' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .testi-style1 .testi-name' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );

        $this->add_responsive_control(
			'testimonial_slider_client_name_padding',
			[
				'label' 		=> __( 'Client Name Padding', 'adina' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .testi-style1 .testi-name' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
			'testimonial_slider_client_feedback_style_section',
			[
				'label' 	=> __( 'Client Feedback', 'adina' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );

        $this->add_control(
			'testimonial_slider_client_feedback_color',
			[
				'label' 	=> __( 'Client Feedback Color', 'adina' ),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .testi-style1 .testi-text' => 'color: {{VALUE}} !important',
				],
			]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'testimonial_slider_client_feedback_typography',
				'label' 	=> __( 'Feedback Typography', 'adina' ),
				'selector' 	=> '{{WRAPPER}} .testi-style1 .testi-text',
			]
        );

        $this->add_responsive_control(
			'testimonial_slider_client_feedback_margin',
			[
				'label' 		=> __( 'Feedback Margin', 'adina' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .testi-style1 .testi-text' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );

        $this->add_responsive_control(
			'testimonial_slider_client_feedback_padding',
			[
				'label' 		=> __( 'Feedback Padding', 'adina' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .testi-style1 .testi-text' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
			'testimonial_slider_designation_style_section',
			[
				'label' 	=> __( 'Designation', 'adina' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );

        $this->add_control(
			'testimonial_slider_designation_color',
			[
				'label' 	=> __( 'Client Designation Color', 'adina' ),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .testi-style1 .testi-degi' => 'color: {{VALUE}}!important',
				],
			]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'testimonial_slider_designation_typography',
				'label' 	=> __( 'Client Designation Typography', 'adina' ),
				'selector' 	=> '{{WRAPPER}} .testi-style1 .testi-degi',
			]
        );

        $this->add_responsive_control(
			'testimonial_slider_designation_margin',
			[
				'label' 		=> __( 'Client Designation Margin', 'adina' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .testi-style1 .testi-degi' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );

        $this->add_responsive_control(
			'testimonial_slider_designation_padding',
			[
				'label' 		=> __( 'Client Designation Padding', 'adina' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .testi-style1 .testi-degi' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);

        $this->end_controls_section();


	}

	protected function render() {

		$settings = $this->get_settings_for_display();

		if('1' == $settings[ 'testimonial_style' ] ){
			$this->add_render_attribute( 'wrapper', 'id', 'testislide1' );
			$this->add_render_attribute( 'wrapper', 'class', 'testimonial-carousel' );
		}else{
			$this->add_render_attribute( 'wrapper', 'class', 'testimonial-carousel2' );
		}
	
		$this->add_render_attribute( 'wrapper', 'data-slide-to-show', $settings['slide_to_show']['size'] );

		?>
		<?php if( '1' == $settings[ 'testimonial_style' ] ): ?>
			<div class="testi-style1" data-bg-src="<?php echo esc_url($settings[ 'bg_image' ][ 'url' ] ); ?>">
				<?php if ( !empty( $settings[ 'subtitle' ] ) ): ?>
					<h2 class="inner-title">
						<?php echo esc_html( $settings[ 'subtitle' ]  ); ?>
					</h2>
				<?php endif; ?>

				<?php if( !empty( $settings[ 'title' ] ) ): ?>
					<p class="inner-subtitle">
						<?php echo esc_html($settings[ 'title' ]) ?>
					</p>
				<?php endif; ?>

				<div <?php echo $this->get_render_attribute_string('wrapper'); ?>>
					<?php foreach( $settings[ 'slides' ] as $slide ): ?>
						<div>
							<div class="testi-body">
								<?php if( 'yes' == $slide[ 'rating' ] ):  ?>
									<div class="testi-rating">
										<i class="fas fa-star"></i>
										<i class="fas fa-star"></i>
										<i class="fas fa-star"></i>
										<i class="fas fa-star"></i>
										<i class="fas fa-star"></i>
									</div>
								<?php endif; ?>
								<?php if( !empty( $slide[ 'client_feedback' ] ) ): ?>
									<p class="testi-text">
										<?php echo esc_html($slide[ 'client_feedback' ]) ?>
									</p>
								<?php endif; ?>

								<div class="testi-author">

									<?php if( !empty( $slide['client_image']['url'] ) ): ?>
										<div class="testi-avater">
											<?php echo adina_img_tag( array(
												'url'	=> esc_url( $slide[ 'client_image' ][ 'url' ] ),
												'alt'   => 'avater',
											) );
											?>
										</div>
									<?php endif; ?>
									<div class="media-body">
										<?php if( !empty( $slide[ 'client_name' ] ) ): ?>
											<h4 class="testi-name"><?php echo esc_html($slide[ 'client_name' ]) ?></h4>
										<?php endif; ?>
										<?php if( !empty( $slide[ 'client_designation' ] ) ): ?>
											<p class="testi-degi"><?php echo esc_html($slide[ 'client_designation' ]) ?></p>
										<?php endif; ?>
									</div>
								</div>
							</div>
						</div>
					<?php endforeach; ?>
				</div>
				<div class="slide-btns">
					<button data-slick-prev="#testislide1"><i class="far fa-angle-left"></i></button>
					<button data-slick-prev="#testislide1"><i class="far fa-angle-right"></i></button>
				</div>
			</div>

			<?php elseif( '2' == $settings[ 'testimonial_style' ] ):  ?>
				<div class="testi-style2">
					<?php if( !empty( $settings[ 'quate_icon' ][ 'url' ] ) ): ?>
						<span class="fav-icon">
							<?php echo adina_img_tag( array(
								'url'	=> esc_url( $settings[ 'quate_icon' ][ 'url' ] ),
								'alt'   => 'icon',
							) );
							?>
						</span>
					<?php endif; ?>
					<div <?php echo $this->get_render_attribute_string('wrapper'); ?>>
						<?php foreach( $settings[ 'slides' ] as $slide ): ?>
							<div>
								<?php if( !empty( $slide[ 'client_feedback' ] ) ): ?>
									<p class="testi-text">
										<?php echo esc_html($slide[ 'client_feedback' ]) ?>
									</p>
								<?php endif; ?>
								<?php if( 'yes' == $slide[ 'rating' ] ):  ?>
									<div class="arrow-shape">
										<i class="arrow"></i>
										<i class="arrow"></i>
										<i class="arrow"></i>
										<i class="arrow"></i>
									</div>
								<?php endif; ?>
								<?php if( !empty( $slide[ 'client_name' ] ) ): ?>
									<h3 class="testi-name h5"><?php echo esc_html($slide[ 'client_name' ]) ?></h3>
								<?php endif; ?>
								<?php if( !empty( $slide[ 'client_designation' ] ) ): ?>
									<span class="testi-degi"><?php echo esc_html($slide[ 'client_designation' ]) ?></span>
								<?php endif; ?>
							</div>
						<?php endforeach; ?>
					</div>
				</div>
			<?php  endif ?>
		<?php 
	}
}


