<?php
/**
 * Happyden Team Widget.
 *
 *
 * @since 1.0.0
 */
namespace Elementor;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\Widget_Base;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Css_Filter;
use Elementor\Icons_Manager;
use Elementor\Utils;
use Elementor\Repeater;
use Elementor\URL;
use \Elementor\Control_Media;

if (!defined('ABSPATH')) {
    exit;
}
// If this file is called directly, abort.
class AdinaTestimonialThree extends Widget_Base {
    public function get_name() {
        return 'adina-testimonial-three';
    }
    public function get_title() {
        return __('Testimonial Three', 'adina');
    }
    public function get_icon() {
        return ('eicon-person');
    }
    public function get_categories() {
        return ['adina-addons'];
    }
    public function get_keywords() {
        return ['Testimonial', 'Slider', 'Slick'];
    }

    protected function register_controls() {
        
        $this->start_controls_section(
            'Testimonial_section',
            [
                'label' => __('Testimonila Section', 'adina'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
        $testimonial_repeater = new Repeater();

        $testimonial_repeater->add_control(
			'testimonial03_image04',
			[
				'label' => esc_html__( 'Images 01', 'adina' ),
				'type' =>  Controls_Manager::MEDIA,
				'default' => [
					'url' =>  Utils::get_placeholder_image_src(),
				],
			]
		);
        $testimonial_repeater->add_control(
			'testimonial_designation',
			[
				'label' => esc_html__( 'Designation', 'adina' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Satisfied Customer', 'adina' ),
				'label_block' => true,
			]
		);
        $testimonial_repeater->add_control(
			'testimonial_client_name',
			[
				'label' => esc_html__( 'Client Name', 'adina' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Helen Wilmore', 'adina' ),
				'label_block' => true,
			]
		);
        $testimonial_repeater->add_control(
			'testimonial_rating_text',
			[
				'label' => esc_html__( 'Rating Text', 'adina' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( '“Cargo Transport”', 'adina' ),
				'label_block' => true,
			]
		);
        $testimonial_repeater->add_control(
			'testimonial_content',
			[
				'label' => esc_html__( 'Content', 'adina' ),
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'Many desktop publishing packages and web page editors now use lorem Ipsum as their default model text, and a search for lorem ipsum will uncover many web sites.', 'adina' ),
				'label_block' => true,
			]
		);
        $testimonial_repeater->add_control(
            'adina_t_rating',
            [
                'label'     => __( 'Customar Rating', 'adina' ),
                'type'      =>  Controls_Manager::SELECT,
                'default'   => '5',
                'options'   => [
                    'none' => __( 'none', 'adina' ),
                    '1'    => __( '1', 'adina' ),
                    '2'    => __( '2', 'adina' ),
                    '3'    => __( '3', 'adina' ),
                    '4'    => __( '4', 'adina' ),
                    '5'    => __( '5', 'adina' ),
                ],
                
            ]
        );
        $this->add_control(
			'adina_testimonial_slides',
			[
				'label' => esc_html__( 'Slider List', 'adina' ),
				'type' =>  Controls_Manager::REPEATER,
				'fields' => $testimonial_repeater->get_controls(),
				'default' => [
					[
						'testimonial02_left_image'        => Utils::get_placeholder_image_src(),
						'testimonial_designation'  => esc_html__( 'Satisfied Customer', 'adina' ),
						'testimonial_client_name'  => esc_html__( 'Helen Wilmore', 'adina' ),
						'testimonial_rating_text'  => esc_html__( '“Cargo Transport”', 'adina' ),
						'testimonial_content'      => esc_html__( 'Many desktop publishing packages and web page editors now use lorem Ipsum as their default model text, and a search for lorem ipsum will uncover many web sites.', 'adina' ),
					],
                    [
						'testimonial02_left_image'        => Utils::get_placeholder_image_src(),
						'testimonial_designation'  => esc_html__( 'Satisfied Customer', 'adina' ),
						'testimonial_client_name'  => esc_html__( 'Helen Wilmore', 'adina' ),
						'testimonial_rating_text'  => esc_html__( '“Cargo Transport”', 'adina' ),
						'testimonial_content'      => esc_html__( 'Many desktop publishing packages and web page editors now use lorem Ipsum as their default model text, and a search for lorem ipsum will uncover many web sites.', 'adina' ),
					],
                    [
						'testimonial02_left_image'        => Utils::get_placeholder_image_src(),
						'testimonial_designation'  => esc_html__( 'Satisfied Customer', 'adina' ),
						'testimonial_client_name'  => esc_html__( 'Helen Wilmore', 'adina' ),
						'testimonial_rating_text'  => esc_html__( '“Cargo Transport”', 'adina' ),
						'testimonial_content'      => esc_html__( 'Many desktop publishing packages and web page editors now use lorem Ipsum as their default model text, and a search for lorem ipsum will uncover many web sites.', 'adina' ),
					],
				],
			]
		);
        $this->end_controls_section();


         /********* End Style Controls /*********/

        /////////////// Testimonial Image /////////////////////
        $this->start_controls_section(
            '_testimonial02_image_style',
            [
                'label' => __( 'Images', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        /////////////// Normal Image ////////////////////////////////
        $this->start_controls_tabs(
            'style_tabs_images'
        );
        
        $this->start_controls_tab(
            'style_normal_tab',
            [
                'label' => esc_html__( 'Normal', 'textdomain' ),
            ]
        );
        
        $this->add_control(
            'testimonial02_images_width',
            [
                'label' => esc_html__( 'Width', 'adina' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => '%',
                    'size' => 100,
                ],
                'selectors' => [
                    '{{WRAPPER}} .testimonials-three__thumb-img .inner img' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'testimonial02_images_height',
            [
                'label' => esc_html__( 'height', 'adina' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => '%',
                    'size' => 100,
                ],
                'selectors' => [
                    '{{WRAPPER}} .testimonials-three__thumb-img .inner img' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'testimonial02_images_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testimonials-three__thumb-img .inner img' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'images01_background',
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} .testimonials-three__thumb-img .inner img',
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'testimonial_images_border',
                'selector' => '{{WRAPPER}} .testimonials-three__thumb-img .inner img',
            ]
        );
        $this->add_control(
            'testimonial02_images',
            [
                'label' => esc_html__( 'Border Radius', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'selectors' => [
                    '{{WRAPPER}} .testimonials-three__thumb-img .inner img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'testimonial02_images_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .testimonials-three__thumb-img .inner img' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'testimonial02_images_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .testimonials-three__thumb-img .inner img' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();

        ////////////// Hover images ///////////////////////////////
        $this->start_controls_tab(
            'style_normal_tab_images',
            [
                'label' => esc_html__( 'Hover', 'textdomain' ),
            ]
        );
        $this->add_control(
            'testimonial02_hover_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testimonials-three__thumb-img::before' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'images02_background',
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} .testimonials-three__thumb-img::before',
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'testimonial_icon_hover_border',
                'selector' => '{{WRAPPER}} .testimonials-three__thumb-img::before',
            ]
        );
        $this->add_control(
            'testimonial02_images_hover',
            [
                'label' => esc_html__( 'Border Radius', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'selectors' => [
                    '{{WRAPPER}} .testimonials-three__thumb-img::before' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'testimonial02_images_hover_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .testimonials-three__thumb-img::before' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'testimonial02_images_hover_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .testimonials-three__thumb-img::before' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tabs();
        $this->end_controls_section();


        ////////////// Reting text/////////////////////
        $this->start_controls_section(
            '_testimonial_rating_text',
            [
                'label' => __( 'Rating text', 'tocore' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'testimonial_rating_text_color',
            [
                'label' => __( ' Rating Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testimonials-three__content-single-top .text h3' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'rating_title_typography',
                'selector' => '{{WRAPPER}} .testimonials-three__content-single-top .text h3',
            ]
        );
        $this->add_responsive_control(
            'testimonial_rating_text_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .testimonials-three__content-single-top .text h3' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'testimonial_rating_text_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .testimonials-three__content-single-top .text h3' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        // ////////////Star icon  rating cilor////////////////////
        $this->start_controls_section(
            'rating_icon_color',
            [
                'label' => __( 'Rating Icon Color', 'tocore' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'testimonial_rating_icon_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .rating-box .active_color' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_section();

        ///////////////// Designation////////////////////////////
        $this->start_controls_section(
            '_testimonial_designation',
            [
                'label' => __( 'Designation Text', 'tocore' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'testimonial_designation_color',
            [
                'label' => __( ' designation Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testimonials-three__content-single-bottom h3 span' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'designation_typography',
                'selector' => '{{WRAPPER}} .testimonials-three__content-single-bottom h3 span',
            ]
        );
        $this->add_responsive_control(
            'testimonial_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .testimonials-three__content-single-bottom h3 span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'testimonial_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .testimonials-three__content-single-bottom h3 span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        ///////////////// Client title////////////////////////////
        $this->start_controls_section(
            '_testimonial_client_text',
            [
                'label' => __( 'Client Name', 'tocore' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'testimonial_client_text_color',
            [
                'label' => __( ' Client Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testimonials-three__content-single-bottom h3' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'client_title_typography',
                'selector' => '{{WRAPPER}} .testimonials-three__content-single-bottom h3',
            ]
        );
        $this->add_responsive_control(
            'testimonial_client_text_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .testimonials-three__content-single-bottom h3' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'testimonial_client_text_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .testimonials-three__content-single-bottom h3' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();



        ////////////// Content/////////////////////
        $this->start_controls_section(
            '_testimonial_content_text',
            [
                'label' => __( 'Content text', 'tocore' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'testimonial_content_text_color',
            [
                'label' => __( ' Content Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testimonials-three__content-single-bottom p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'content_title_typography',
                'selector' => '{{WRAPPER}} .testimonials-three__content-single-bottom p',
            ]
        );
        $this->add_responsive_control(
            'testimonial_content_text_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .testimonials-three__content-single-bottom p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'testimonial_content_text_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .testimonials-three__content-single-bottom p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        ///////////// Arrow button option ////////////////////////////////
        $this->start_controls_section(
            '_section_arrow',
            [
                'label' => __( 'Arrow', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        ///////////// Arrow Normal ////////////////
        $this->start_controls_tabs(
            'style_tabses'
        );
        
        $this->start_controls_tab(
            'style__arrow_normal',
            [
                'label' => esc_html__( 'Normal', 'adina' ),
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'arrow_text_background',
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} .testimonials-three__nav .swiper-button-next, .testimonials-three__nav .swiper-button-prev',
            ]
        );
        $this->add_control(
            'arrow_text_color',
            [
                'label' => __( 'Text Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testimonials-three__nav .swiper-button-next, .testimonials-three__nav .swiper-button-prev' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'arrow_text_typography',
                'selector' => '{{WRAPPER}} .testimonials-three__nav .swiper-button-next, .testimonials-three__nav .swiper-button-prev',
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'arrow_text_border',
                'selector' => '{{WRAPPER}} .testimonials-three__nav .swiper-button-next, .testimonials-three__nav .swiper-button-prev',
            ]
        );
        $this->add_control(
            'arrow_text_border_radius',
            [
                'label' => esc_html__( 'Border Radius', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'selectors' => [
                    '{{WRAPPER}} .testimonials-three__nav .swiper-button-next, .testimonials-three__nav .swiper-button-prev' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Text_Shadow::get_type(),
            [
                'name' => 'arrow_text_shadow',
                'selector' => '{{WRAPPER}} .testimonials-three__nav .swiper-button-next, .testimonials-three__nav .swiper-button-prev',
            ]
        );
        $this->add_responsive_control(
            'arrow_text_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .testimonials-three__nav .swiper-button-next, .testimonials-three__nav .swiper-button-prev' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'arrow_text_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .testimonials-three__nav .swiper-button-next, .testimonials-three__nav .swiper-button-prev' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        
        $this->end_controls_tab();


        /////////////////// Arrow Hover ////////////////////////////
        $this->start_controls_tab(
            'style_hover_arrow',
            [
                'label' => esc_html__( 'Hover', 'adina' ),
            ]
        );
        
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'arrow_background',
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} .testimonials-three__nav .swiper-button-next:hover, .testimonials-three__nav .swiper-button-prev:hover',
            ]
        );
        $this->add_control(
            'arrow_color',
            [
                'label' => __( 'Text Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testimonials-three__nav .swiper-button-next:hover, .testimonials-three__nav .swiper-button-prev:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'arrow_typography',
                'selector' => '{{WRAPPER}} .testimonials-three__nav .swiper-button-next:hover, .testimonials-three__nav .swiper-button-prev:hover',
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'arrow_border',
                'selector' => '{{WRAPPER}} .testimonials-three__nav .swiper-button-next:hover, .testimonials-three__nav .swiper-button-prev:hover',
            ]
        );
        $this->add_control(
            'arrow_border_radius',
            [
                'label' => esc_html__( 'Border Radius', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'selectors' => [
                    '{{WRAPPER}} .testimonials-three__nav .swiper-button-next:hover, .testimonials-three__nav .swiper-button-prev:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Text_Shadow::get_type(),
            [
                'name' => 'arrow_shadow',
                'selector' => '{{WRAPPER}} .testimonials-three__nav .swiper-button-next:hover, .testimonials-three__nav .swiper-button-prev:hover',
            ]
        );
        $this->add_responsive_control(
            'arrow_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .testimonials-three__nav .swiper-button-next:hover, .testimonials-three__nav .swiper-button-prev:hover' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'arrow_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .testimonials-three__nav .swiper-button-next:hover, .testimonials-three__nav .swiper-button-prev:hover' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tabs();
        $this->end_controls_section();


        /********* End Style Controls /*********/

    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $slides = $settings[ 'adina_testimonial_slides' ];
        
        ?>

        <!--Start Testimonials Three-->

        <!--Start Testimonials Three Content-->
            <div class="testimonials-three__content-box">
                <div class="swiper-container" id="testimonials-three__thumb">
                    <div class="swiper-wrapper">

                        <?php foreach( $slides as $slide  ): ?>
                        <div class="swiper-slide">
                            <div class="testimonials-three__thumb-img">
                                <!-- images upload in here  -->
                                <?php if( !empty( $slide[ 'testimonial03_image04' ]['url'] ) ): ?>
                                <div class="inner">
                                    <img src="<?php echo esc_url( $slide[ 'testimonial03_image04' ]['url'] ); ?>" alt="">
                                </div>
                                <?php endif; ?>
                            </div>
                        </div><!-- /.swiper-slide -->
                        <?php endforeach; ?>

                    </div>
                </div>

                <div class="testimonials-three__content">
                    <div class="swiper-container" id="testimonials-three__carousel">
                        <div class="swiper-wrapper">
                            <?php foreach( $slides as $slide  ):
            
                                ?>
                            <!--Start Swiper Slide-->
                            <div class="swiper-slide">
                                <div class="testimonials-three__content-single">
                                    <div class="testimonials-three__content-single-top">
                                        <div class="text">
                                            <!--  Rating text  in here -->
                                            <?php if ( !empty( $slide['testimonial_rating_text']) ) : ?>
                                                <h3><?php echo adina_kses( $slide['testimonial_rating_text'] ); ?></h3>
                                            <?php endif; ?>

                                        </div>
                                        <!-- Rating star icon in here -->
                                        <span class="rating-box">
                                            <?php for($i=0;$i<5; $i++): 
                                                    $class = '';
                                                ?>
                                                <?php if ($slide['adina_t_rating'] > $i) {
                                                    $class = "active_color";
                                                } ?>
                                                <a href="#" class="<?php echo esc_attr( $class ) ?>">
                                                    <i class="icon-star"></i>
                                                </a>
                                            <?php endfor; ?>
                                        </span>

                                    </div>
                                    <div class="testimonials-three__content-single-bottom">
                                        <!--  Content  text  in here -->
                                        <?php if ( !empty( $slide['testimonial_content']) ) : ?>
                                            <p><?php echo adina_kses( $slide['testimonial_content'] ); ?></p>
                                        <?php endif; ?>
                                        
                                        <!--  Client Name  in here -->
                                        <?php if ( !empty( $slide['testimonial_client_name']) ) : ?>
                                        <h3><?php echo adina_kses( $slide['testimonial_client_name'] ); ?> <span><?php echo adina_kses( $slide['testimonial_designation'] ); ?></span></h3>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                            <!--End Swiper Slide-->
                            <?php endforeach; ?>

                        </div>
                    </div>

                    <div class="testimonials-three__nav">
                        <div class="swiper-button-prev" id="testimonials-three__swiper-button-next">
                            <i class="icon-left-arrow" aria-hidden="true"></i>
                        </div>
                        <div class="swiper-button-next" id="testimonials-three__swiper-button-prev">
                            <i class="icon-right-arrow1" aria-hidden="true"></i>
                        </div>
                    </div>
                </div>
            </div>
        <!--End Testimonials Three Content-->
        <?php
}
}
$widgets_manager->register(new \Elementor\AdinaTestimonialThree());

