<?php
/**
 * Happyden Team Widget.
 *
 *
 * @since 1.0.0
 */
namespace Elementor;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\Widget_Base;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Css_Filter;
use Elementor\Icons_Manager;
use Elementor\Utils;
use Elementor\Repeater;
use Elementor\URL;
use \Elementor\Control_Media;

if (!defined('ABSPATH')) {
    exit;
}
// If this file is called directly, abort.
class AdinaTestimonialTwo extends Widget_Base {
    public function get_name() {
        return 'adina-testimonial-two';
    }
    public function get_title() {
        return __('Testimonial Two', 'adina');
    }
    public function get_icon() {
        return ('eicon-person');
    }
    public function get_categories() {
        return ['adina-addons'];
    }
    public function get_keywords() {
        return ['Testimonial', 'Slider', 'Slick'];
    }

    protected function register_controls() {

        $this->start_controls_section(
            'test_one_settings',
            [
                'label' => __('Testimonial Settings', 'adina'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'show_slider_settings',
            [
                'label' => __('Slider Active', 'adina'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'adina'),
                'label_off' => __('No', 'adina'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );


        $this->add_responsive_control('per_line', [
            'label'              => __('Columns per row', 'adina'),
            'type'               => Controls_Manager::SELECT,
            'default'            => '3',
            'tablet_default'     => '6',
            'mobile_default'     => '12',
            'options'            => [
                '12' => '1',
                '6'  => '2',
                '4'  => '3',
                '3'  => '4',
            ],
            'frontend_available' => true,
            'condition'   => [ 'show_slider_settings' => '', ]
        ]);


        $this->add_responsive_control(
            'gap_bottom',
            [
                'label'          => __('Gap Bottom', 'adina'),
                'type'           => Controls_Manager::SLIDER,
                'size_units'     => ['px', '%'],
                'range'          => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors'      => [
                    '{{WRAPPER}} .testimonials-two__single' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        //Slider Setting
        $this->start_controls_section('slider_settings',
        [
            'label' => __('Slider Settings', 'adina'),
            'tab'   => Controls_Manager::TAB_CONTENT,
            'condition' => [ 'show_slider_settings' => 'yes',  ]
            ]
        );

        $this->add_responsive_control(
            'per_coulmn',
            [
                'label' => __( 'Slider Items', 'adina' ),
                'type' => Controls_Manager::SELECT,
                'default'            => 3,
                'tablet_default'     => 2,
                'mobile_default'     => 1,
                'options'            => [
                    '1' => '1',
                    '2' => '2',
                    '3' => '3',
                    '4' => '4',
                    '5' => '5',
                    '6' => '6',
                ],
                'frontend_available' => true,
            ]
        );
        $this->add_responsive_control(
			'gap_right_left',
			[
				'label'          => __('Row Gap(Right-Left)', 'adina'),
				'type'           => Controls_Manager::SLIDER,
				'size_units'     => ['px', '%'],
				'range'          => [
					'px' => [
						'min' => 0,
						'max' => 1000,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors'      => [
					'{{WRAPPER}} .testimonials-two__single' => 'margin-right: {{SIZE}}{{UNIT}}; margin-left: {{SIZE}}{{UNIT}};',
				],
			]
		);
        $this->add_control(
            'dots',
            [
                'label' => __( 'Dots?', 'adina' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'adina' ),
                'label_off' => __( 'Hide', 'adina' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'drag',
            [
                'label' => __( 'Drag?', 'adina' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'adina' ),
                'label_off' => __( 'Hide', 'adina' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'autoplay',
            [
                'label' => __( 'Auto Play?', 'adina' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'adina' ),
                'label_off' => __( 'Hide', 'adina' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'autoplaytimeout',
            [
                'label' => __( 'Autoplay Timeout', 'adina' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'label_block' => true,
                'default' => '5000',
                'options' => [
                    '1000'  => __( '1 Second', 'adina' ),
                    '2000'  => __( '2 Second', 'adina' ),
                    '3000'  => __( '3 Second', 'adina' ),
                    '4000'  => __( '4 Second', 'adina' ),
                    '5000'  => __( '5 Second', 'adina' ),
                    '6000'  => __( '6 Second', 'adina' ),
                    '7000'  => __( '7 Second', 'adina' ),
                    '8000'  => __( '8 Second', 'adina' ),
                    '9000'  => __( '9 Second', 'adina' ),
                    '10000' => __( '10 Second', 'adina' ),
                    '11000' => __( '11 Second', 'adina' ),
                    '12000' => __( '12 Second', 'adina' ),
                    '13000' => __( '13 Second', 'adina' ),
                    '14000' => __( '14 Second', 'adina' ),
                    '15000' => __( '15 Second', 'adina' ),
                ],
                'condition' => [
                    'autoplay' => 'yes',
                ],
            ]
        );
        $this->end_controls_section();
		// End Slider settings
        
        $this->start_controls_section(
            'Testimonial_section',
            [
                'label' => __('Testimonila Section', 'adina'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
        $testimonial_repeater = new Repeater();

        $testimonial_repeater->add_control(
			'testimonial02_icon',
			[
				'label' => esc_html__( 'Here you can use Fontawsome or Icomoon Class', 'adina' ),
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'icon-quote11', 'adina' ),
				'label_block' => true,
			]
		);
        $testimonial_repeater->add_control(
			'testimonial_image',
			[
				'label' => esc_html__( 'Image', 'adina' ),
				'type' =>  Controls_Manager::MEDIA,
				'default' => [
					'url' =>  Utils::get_placeholder_image_src(),
				],
			]
		);
        $testimonial_repeater->add_control(
			'testimonial_designation',
			[
				'label' => esc_html__( 'Designation', 'adina' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Satisfied Customer', 'adina' ),
				'label_block' => true,
			]
		);
        $testimonial_repeater->add_control(
			'testimonial_client_name',
			[
				'label' => esc_html__( 'Client Name', 'adina' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Rebecca Jr.', 'adina' ),
				'label_block' => true,
			]
		);
        $testimonial_repeater->add_control(
			'testimonial_rating_text',
			[
				'label' => esc_html__( 'Rating Text', 'adina' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( '“Air Freight Services”', 'adina' ),
				'label_block' => true,
			]
		);
        $testimonial_repeater->add_control(
            'adina_t_rating',
            [
                'label'     => __( 'Customar Rating', 'adina' ),
                'type'      =>  Controls_Manager::SELECT,
                'default'   => '5',
                'options'   => [
                    'none' => __( 'none', 'adina' ),
                    '1'    => __( '1', 'adina' ),
                    '2'    => __( '2', 'adina' ),
                    '3'    => __( '3', 'adina' ),
                    '4'    => __( '4', 'adina' ),
                    '5'    => __( '5', 'adina' ),
                ],
                
            ]
        );
        $testimonial_repeater->add_control(
			'testimonial_content',
			[
				'label' => esc_html__( 'Content', 'adina' ),
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut
                fugit some
                sed quia consequuntur dolores sequi nesciunt.', 'adina' ),
				'label_block' => true,
			]
		);
        $this->add_control(
			'adina_testimonial_slides',
			[
				'label' => esc_html__( 'Slider List', 'adina' ),
				'type' =>  Controls_Manager::REPEATER,
				'fields' => $testimonial_repeater->get_controls(),
				'default' => [
					[
						'testimonial_image'        => Utils::get_placeholder_image_src(), 
						'testimonial_designation'  => esc_html__( 'Satisfied Customer', 'adina' ),
						'testimonial_client_name'  => esc_html__( 'Rebecca Jr.', 'adina' ),
                        'testimonial02_icon'       => esc_html__( 'icon-quote11', 'adina' ),
						'testimonial_rating_text'  => esc_html__( '“Air Freight Services”', 'adina' ),
						'testimonial_content'      => esc_html__( 'Cargo transport is best porro quisquam Many desktop publishing packages and web page editors now use Lorem Ipsum.', 'adina' ),
                        'masco_t_rating'           => '5',
					],
                    [
						'testimonial_image'        => Utils::get_placeholder_image_src(),
						'testimonial_designation'  => esc_html__( 'Satisfied Customer', 'adina' ),
						'testimonial_client_name'  => esc_html__( 'Rebecca Jr.', 'adina' ),
                        'testimonial02_icon'       => esc_html__( 'icon-quote11', 'adina' ),
						'testimonial_rating_text'  => esc_html__( '“Air Freight Services”', 'adina' ),
                        'masco_t_rating'           => '5',
						'testimonial_content'      => esc_html__( 'Cargo transport is best porro quisquam Many desktop publishing packages and web page editors now use Lorem Ipsum.', 'adina' ),
					],
                    [
						'testimonial_image'        => Utils::get_placeholder_image_src(),
						'testimonial_designation'  => esc_html__( 'Satisfied Customer', 'adina' ),
						'testimonial_client_name'  => esc_html__( 'Rebecca Jr.', 'adina' ),
                        'testimonial02_icon'       => esc_html__( 'icon-quote11', 'adina' ),
						'testimonial_rating_text'  => esc_html__( '“Air Freight Services”', 'adina' ),
                        'masco_t_rating'           => '5',
						'testimonial_content'      => esc_html__( 'Cargo transport is best porro quisquam Many desktop publishing packages and web page editors now use Lorem Ipsum.', 'adina' ),
					],
				],
                'title_field' => '{{{ testimonial_client_name }}}',
			]
		);
        $this->end_controls_section();
         /********* End Style Controls /*********/

            /////////////// Testimonial image /////////////////////
            $this->start_controls_section(
            '_testimonial02_image_style',
            [
                'label' => __( 'Images', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'testimonial02_width',
            [
                'label' => esc_html__( 'Width', 'adina' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => '%',
                    'size' => 0,
                ],
                'selectors' => [
                    '{{WRAPPER}} .testimonials-two__single-top .img-box img' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'testimonial02_height',
            [
                'label' => esc_html__( 'height', 'adina' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => '%',
                    'size' => 0,
                ],
                'selectors' => [
                    '{{WRAPPER}} .testimonials-two__single-top .img-box img' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'testimonial_border',
                'selector' => '{{WRAPPER}} .testimonials-two__single-top .img-box img',
            ]
        );
        $this->add_control(
            'testimonial02_border_radius',
            [
                'label' => esc_html__( 'Border Radius', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'selectors' => [
                    '{{WRAPPER}} .testimonials-two__single-top .img-box img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'testimonial02_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .testimonials-two__single-top .img-box img' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'testimonial02_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .testimonials-two__single-top .img-box img' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        /////////////// Testimonial Icon /////////////////////
        $this->start_controls_section(
            '_testimonial02_icon_style',
            [
                'label' => __( 'Icon', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        /////////////// Normal Icon ////////////////////////////////
        $this->start_controls_tabs(
            'style_tabs_icon'
        );
        
        $this->start_controls_tab(
            'style_normal_tab',
            [
                'label' => esc_html__( 'Normal', 'textdomain' ),
            ]
        );
        
        $this->add_control(
            'testimonial02_icon_width',
            [
                'label' => esc_html__( 'Width', 'adina' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => '%',
                    'size' => 0,
                ],
                'selectors' => [
                    '{{WRAPPER}} .testimonials-two__single .quote-icon span' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'testimonial02_icon_height',
            [
                'label' => esc_html__( 'height', 'adina' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => '%',
                    'size' => 0,
                ],
                'selectors' => [
                    '{{WRAPPER}} .testimonials-two__single .quote-icon span' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'testimonial02_icon_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testimonials-two__single .quote-icon span' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'icon01_background',
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} .testimonials-two__single .quote-icon span',
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'testimonial_icon_border',
                'selector' => '{{WRAPPER}} .testimonials-two__single .quote-icon span',
            ]
        );
        $this->add_control(
            'testimonial02_icon',
            [
                'label' => esc_html__( 'Border Radius', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'selectors' => [
                    '{{WRAPPER}} .testimonials-two__single .quote-icon span' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'testimonial02_icon_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .testimonials-two__single .quote-icon span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'testimonial02_icon_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .testimonials-two__single .quote-icon span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();

        ////////////// Hover Icon ///////////////////////////////
        $this->start_controls_tab(
            'style_normal_tab_icon',
            [
                'label' => esc_html__( 'Hover', 'textdomain' ),
            ]
        );
        $this->add_control(
            'testimonial02_hover_icon_width',
            [
                'label' => esc_html__( 'Width', 'adina' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => '%',
                    'size' => 0,
                ],
                'selectors' => [
                    '{{WRAPPER}} .testimonials-two__single:hover .quote-icon span' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'testimonial02_icon_hover_height',
            [
                'label' => esc_html__( 'height', 'adina' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => '%',
                    'size' => 0,
                ],
                'selectors' => [
                    '{{WRAPPER}} .testimonials-two__single:hover .quote-icon span' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'testimonial02_hover_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testimonials-two__single:hover .quote-icon span' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'icon02_background',
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} .testimonials-two__single:hover .quote-icon span',
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'testimonial_icon_hover_border',
                'selector' => '{{WRAPPER}} .testimonials-two__single:hover .quote-icon span',
            ]
        );
        $this->add_control(
            'testimonial02_icon_hover',
            [
                'label' => esc_html__( 'Border Radius', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'selectors' => [
                    '{{WRAPPER}} .testimonials-two__single:hover .quote-icon span' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'testimonial02_icon_hover_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .testimonials-two__single:hover .quote-icon span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'testimonial02_icon_hover_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .testimonials-two__single:hover .quote-icon span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tabs();
        $this->end_controls_section();


        ///////////////// Designation////////////////////////////
        $this->start_controls_section(
            '_testimonial_designation',
            [
                'label' => __( 'Designation Text', 'tocore' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'testimonial_designation_color',
            [
                'label' => __( ' designation Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testimonials-two__single-top .text-box p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'designation_typography',
                'selector' => '{{WRAPPER}} .testimonials-two__single-top .text-box p',
            ]
        );
        $this->add_responsive_control(
            'testimonial_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .testimonials-two__single-top .text-box p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'testimonial_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .testimonials-two__single-top .text-box p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        ///////////////// Client title////////////////////////////
        $this->start_controls_section(
            '_testimonial_client_text',
            [
                'label' => __( 'Client Text', 'tocore' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'testimonial_client_text_color',
            [
                'label' => __( ' Client Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testimonials-two__single-top .text-box h3' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'client_title_typography',
                'selector' => '{{WRAPPER}} .testimonials-two__single-top .text-box h3',
            ]
        );
        $this->add_responsive_control(
            'testimonial_client_text_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .testimonials-two__single-top .text-box h3' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'testimonial_client_text_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .testimonials-two__single-top .text-box h3' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        ////////////// Reting text/////////////////////
        $this->start_controls_section(
            '_testimonial_rating_text',
            [
                'label' => __( 'Rating text', 'tocore' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'testimonial_rating_text_color',
            [
                'label' => __( ' Rating Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testimonials-two__single-bottom .content-box h3' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'rating_title_typography',
                'selector' => '{{WRAPPER}} .testimonials-two__single-bottom .content-box h3',
            ]
        );
        $this->add_responsive_control(
            'testimonial_rating_text_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .testimonials-two__single-bottom .content-box h3' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'testimonial_rating_text_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .testimonials-two__single-bottom .content-box h3' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        // ////////////Star icon  rating cilor////////////////////
        $this->start_controls_section(
            'rating_icon_color',
            [
                'label' => __( 'Rating Icon Color', 'tocore' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'testimonial_rating_icon_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .rating-box .active_color' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_section();

        ////////////// Content/////////////////////
        $this->start_controls_section(
            '_testimonial_content_text',
            [
                'label' => __( 'Content text', 'tocore' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'testimonial_content_text_color',
            [
                'label' => __( ' Content Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testimonials-two__single-bottom .content-box p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'content_title_typography',
                'selector' => '{{WRAPPER}} .testimonials-two__single-bottom .content-box p',
            ]
        );
        $this->add_responsive_control(
            'testimonial_content_text_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .testimonials-two__single-bottom .content-box p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'testimonial_content_text_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .testimonials-two__single-bottom .content-box p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        ///////////// Arrow button option ////////////////////////////////
        $this->start_controls_section(
            '_section_arrow',
            [
                'label' => __( 'Arrow', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        ///////////// Arrow Normal ////////////////
        $this->start_controls_tabs(
            'style_tabses'
        );
        
        $this->start_controls_tab(
            'style__arrow_normal',
            [
                'label' => esc_html__( 'Normal', 'adina' ),
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'arrow_text_background',
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} .swiper-nav-style1 .swiper-button-next, .swiper-nav-style1 .swiper-button-prev',
            ]
        );
        $this->add_control(
            'arrow_text_color',
            [
                'label' => __( 'Text Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .swiper-nav-style1 .swiper-button-next, .swiper-nav-style1 .swiper-button-prev' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'arrow_text_typography',
                'selector' => '{{WRAPPER}} .swiper-nav-style1 .swiper-button-next, .swiper-nav-style1 .swiper-button-prev',
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'arrow_text_border',
                'selector' => '{{WRAPPER}} .swiper-nav-style1 .swiper-button-next, .swiper-nav-style1 .swiper-button-prev',
            ]
        );
        $this->add_control(
            'arrow_text_border_radius',
            [
                'label' => esc_html__( 'Border Radius', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'selectors' => [
                    '{{WRAPPER}} .swiper-nav-style1 .swiper-button-next, .swiper-nav-style1 .swiper-button-prev' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Text_Shadow::get_type(),
            [
                'name' => 'arrow_text_shadow',
                'selector' => '{{WRAPPER}} .swiper-nav-style1 .swiper-button-next, .swiper-nav-style1 .swiper-button-prev',
            ]
        );
        $this->add_responsive_control(
            'arrow_text_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .swiper-nav-style1 .swiper-button-next, .swiper-nav-style1 .swiper-button-prev' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'arrow_text_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .swiper-nav-style1 .swiper-button-next, .swiper-nav-style1 .swiper-button-prev' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        
        $this->end_controls_tab();


        /////////////////// Arrow Hover ////////////////////////////
        $this->start_controls_tab(
            'style_hover_arrow',
            [
                'label' => esc_html__( 'Hover', 'adina' ),
            ]
        );
        
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'arrow_background',
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} .swiper-nav-style1 .swiper-button-next:hover, .swiper-nav-style1 .swiper-button-prev:hover',
            ]
        );
        $this->add_control(
            'arrow_color',
            [
                'label' => __( 'Text Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .swiper-nav-style1 .swiper-button-next:hover, .swiper-nav-style1 .swiper-button-prev:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'arrow_typography',
                'selector' => '{{WRAPPER}} .swiper-nav-style1 .swiper-button-next:hover, .swiper-nav-style1 .swiper-button-prev:hover',
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'arrow_border',
                'selector' => '{{WRAPPER}} .swiper-nav-style1 .swiper-button-next:hover, .swiper-nav-style1 .swiper-button-prev:hover',
            ]
        );
        $this->add_control(
            'arrow_border_radius',
            [
                'label' => esc_html__( 'Border Radius', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'selectors' => [
                    '{{WRAPPER}} .swiper-nav-style1 .swiper-button-next:hover, .swiper-nav-style1 .swiper-button-prev:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Text_Shadow::get_type(),
            [
                'name' => 'arrow_shadow',
                'selector' => '{{WRAPPER}} .swiper-nav-style1 .swiper-button-next:hover, .swiper-nav-style1 .swiper-button-prev:hover',
            ]
        );
        $this->add_responsive_control(
            'arrow_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .swiper-nav-style1 .swiper-button-next:hover, .swiper-nav-style1 .swiper-button-prev:hover' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'arrow_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .swiper-nav-style1 .swiper-button-next:hover, .swiper-nav-style1 .swiper-button-prev:hover' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tabs();
        $this->end_controls_section();

        ///////////// Testimonial single box ////////////////////////////////
        $this->start_controls_section(
            '_section_single_box',
            [
                'label' => __( 'Single Box', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        ///////////// Normal Box ////////////////
        $this->start_controls_tabs(
            'style_tab_single_box'
        );
        
        $this->start_controls_tab(
            'style_box_normal',
            [
                'label' => esc_html__( 'Normal', 'adina' ),
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'box_background',
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} .testimonials-two__single',
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'box_border',
                'selector' => '{{WRAPPER}} .testimonials-two__single',
            ]
        );
        $this->add_control(
            'box_border_radius',
            [
                'label' => esc_html__( 'Border Radius', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'selectors' => [
                    '{{WRAPPER}} .testimonials-two__single' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'box_shadow',
				'selector' => '{{WRAPPER}} .testimonials-two__single',
			]
		);
        $this->add_responsive_control(
            'box_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .testimonials-two__single' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'box_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .testimonials-two__single' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        
        $this->end_controls_tab();


        /////////////////// Hover  Box ////////////////////////////
        $this->start_controls_tab(
            'style_hover_box',
            [
                'label' => esc_html__( 'Hover', 'adina' ),
            ]
        );
        
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'box02_background',
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} .testimonials-two__single',
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'box02_border',
                'selector' => '{{WRAPPER}} .testimonials-two__single',
            ]
        );
        $this->add_control(
            'box02_border_radius',
            [
                'label' => esc_html__( 'Border Radius', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'selectors' => [
                    '{{WRAPPER}} .testimonials-two__single' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'box02_shadow',
				'selector' => '{{WRAPPER}} .testimonials-two__single',
			]
		);
        $this->add_responsive_control(
            'box02_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .testimonials-two__single' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'box02_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .testimonials-two__single' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tabs();
        $this->end_controls_section();

        /********* End Style Controls /*********/

    }

    protected function render() {
        $settings = $this->get_settings_for_display();

        //this code course slider option
		$slider_extraSetting = array(
	        'autoplay' => (!empty($settings['autoplay']) && 'yes' === $settings['autoplay']) ? true : false,
            'drag' => (!empty($settings['drag']) && 'yes' === $settings['drag']) ? true : false,
            'dots' => (!empty($settings['dots']) && 'yes' === $settings['dots']) ? true : false,
        	'autoplaytimeout' => !empty($settings['autoplaytimeout']) ? $settings['autoplaytimeout'] : '5000',

        	//this a responsive layout
            'per_coulmn' =>        (!empty($settings['per_coulmn'])) ? $settings['per_coulmn'] : 3,
            'per_coulmn_tablet' => (!empty($settings['per_coulmn_tablet'])) ? $settings['per_coulmn_tablet'] : 2,
            'per_coulmn_mobile' => (!empty($settings['per_coulmn_mobile'])) ? $settings['per_coulmn_mobile'] : 1
        );
		$jasondecode = wp_json_encode($slider_extraSetting);

        if ( ( 'yes' == $settings['show_slider_settings'] ) ) {
            $this->add_render_attribute('testimonial_two_version', 'class', ['row testimonial-two-slider']);
            $this->add_render_attribute('testimonial_two_version', 'data-settings', $jasondecode);
            $this->add_render_attribute('testimonial_two_gride_classes', 'class', ['item']);
        } else {
            $this->add_render_attribute('testimonial_two_version', 'class', ['row']);
            //gride class
            $grid_classes = [];
            $grid_classes[] = 'col-xl-' . $settings['per_line'];
            $grid_classes[] = 'col-md-' . $settings['per_line_tablet'];
            $grid_classes[] = 'col-sm-' . $settings['per_line_mobile'];
            $grid_classes = implode(' ', $grid_classes);
            $this->add_render_attribute('testimonial_two_gride_classes', 'class', [$grid_classes]);
        }

        $slides = $settings[ 'adina_testimonial_slides' ];
        
        ?>

        <!--Start Testimonials Two-->
        <section class="testimonials-two">
            <div class="container">

                <div <?php echo $this->get_render_attribute_string('testimonial_two_version'); ?> >
                    <?php foreach( $slides as $slide  ): ?>
                        <div <?php echo $this->get_render_attribute_string('testimonial_two_gride_classes'); ?> >
                            <div class="swiper-slide">
                                <!--Start Testimonials Two Single-->
                                <div class="testimonials-two__single">
                                    <div class="quote-icon"><span class="icon-quote11"></span></div>
                                    <div class="testimonials-two__single-top">

                                    <!-- images upload in here -->
                                        <?php if( !empty( $slide[ 'testimonial_image' ]['url'] ) ): ?>
                                        <div class="img-box">
                                            <img src="<?php echo esc_url( $slide[ 'testimonial_image' ]['url'] ); ?>" alt="">
                                        </div>
                                        <?php endif; ?>

                                        <div class="text-box">

                                            <!--  Designation in here -->
                                            <?php if ( !empty( $slide['testimonial_designation']) ) : ?>
                                            <p><?php echo adina_kses( $slide['testimonial_designation'] ); ?></p>
                                            <?php endif; ?>

                                            <!--  Client Name  in here -->
                                            <?php if ( !empty( $slide['testimonial_client_name']) ) : ?>
                                            <h3><?php echo adina_kses( $slide['testimonial_client_name'] ); ?></h3>
                                            <?php endif; ?>
                                            
                                        </div>
                                    </div>

                                    <div class="testimonials-two__single-bottom">

                                        <!-- Rating star icon in herre  -->
                                        <span class="rating-box">
                                            <?php for($i=0;$i<5; $i++): 
                                                    $class = '';
                                                ?>
                                                <?php if ($slide['adina_t_rating'] > $i) {
                                                    $class = "active_color";
                                                } ?>
                                                <a href="#" class="<?php echo esc_attr( $class ) ?>">
                                                    <i class="icon-star"></i>
                                                </a>
                                            <?php endfor; ?>
                                        </span>

                                        <div class="content-box">
                                            <!--  Rating text  in here -->
                                            <?php if ( !empty( $slide['testimonial_rating_text']) ) : ?>
                                                <h3><?php echo adina_kses( $slide['testimonial_rating_text'] ); ?></h3>
                                            <?php endif; ?>

                                            <!--  Content  text  in here -->
                                            <?php if ( !empty( $slide['testimonial_content']) ) : ?>
                                                <p><?php echo adina_kses( $slide['testimonial_content'] ); ?></p>
                                            <?php endif; ?>

                                        </div>
                                    </div>
                                </div>
                                <!--End Testimonials Two Single-->
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </section>
        <!--End Testimonials Two-->


        <?php
}
}
$widgets_manager->register(new \Elementor\AdinaTestimonialTwo());

