<?php
namespace Elementor;

class Adina_Vertical_Menu extends Widget_Base
{
    public function get_name() {
        return 'adina-vertical-menu';
    }
    public function get_title() {
        return __('Vertical Menu', 'adina');
    }

    public function get_icon() {
        return 'eicon-nav-menu';
    }

    public function get_categories()  {
        return ['adina-footer-elements'];
    }

    private function get_available_menus()
    {
        $menus = wp_get_nav_menus();
        $options = [];
        foreach ($menus as $menu) {
            $options[$menu->slug] = $menu->name;
        }
        return $options;
    }

    /**
     * Register oEmbed widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        /**
         * Style tab
         */

        $this->start_controls_section(
            'general',
            [
                'label' => __('Content', 'adina'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );


        $this->add_control(
			'selected_menu',
			[
				'label' => __( 'Select Menu', 'adina' ),
				'type' => Controls_Manager::SELECT,
				'options' => $this->get_available_menus(),
			]
        );
   
        $this->end_controls_section();

        $this->start_controls_section(
            'section_menu_style',
            [
                'label' => __('Menu Style', 'adina'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

		$this->start_controls_tabs(
			'menu_items_tabs'
        );
        
		$this->start_controls_tab(
			'menu_normal_tab',
			[
				'label' => __( 'Normal', 'adina' ),
			]
        );
        
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'menu_typography',
                'label' => __('Menu Typography', 'adina'),
                'selector' => '{{WRAPPER}} .adina-vertical-menu a',
            ]
        );

        $this->add_control(
            'menu_color',
            [
                'label' => __('Item Color', 'adina'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .adina-vertical-menu a' => 'color: {{VALUE}}',
    
                ],
            ]
        );

        $this->add_control(
            'menu_bg_color',
            [
                'label' => __('Item Background Color', 'adina'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .adina-vertical-menu a' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'border',
				'label' => __( 'Item Border', 'adina' ),
				'selector' => '{{WRAPPER}} .adina-vertical-menu li',
			]
		);
        
        $this->add_responsive_control(
            'item_gap',
            [
                'label' => __('Menu Gap', 'adina'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'devices' => ['desktop', 'tablet', 'mobile'],
                'selectors' => [
                    '{{WRAPPER}} .adina-vertical-menu li:not(:last-child) a' => 'margin-bottom: {{SIZE}}{{UNIT}};',
        
                ],

            ]
        );

        $this->add_responsive_control(
            'item_padding',
            [
                'label' => __('Item Padding', 'adina'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .adina-vertical-menu a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );

        $this->add_responsive_control(
            'item_readius',
            [
                'label' => __('Item Radius', 'adina'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .adina-vertical-menu a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

		$this->end_controls_tab();

		$this->start_controls_tab(
			'menu_hover_tab',
			[
				'label' => __( 'Hover', 'adina' ),
			]
		);

        $this->add_control(
            'menu_hover_color',
            [
                'label' => __('Menu Hover Color', 'adina'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .adina-vertical-menu a:hover, 
                     {{WRAPPER}} .adina-vertical-menu li.current-menu-item>a' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'menu_bg_hover_color',
            [
                'label' => __('Item Background Color', 'adina'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .menu-style-inline.navbar:not(.active) .main-navigation ul.navbar-nav>li:hover>a' => 'background-color: {{VALUE}}',
                ],
            ]
        );

		$this->end_controls_tab();
		$this->end_controls_tabs();
        $this->end_controls_section();
        $this->start_controls_section(
            'section_box_style',
            [
                'label' => __('Box Style', 'adina'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'background',
				'label' => __( 'Background', 'plugin-domain' ),
				'types' => [ 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} .adina-vertical-menu-wrap',
			]
		);
        $this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'box-border',
				'label' => __( 'Box Border', 'adina' ),
				'selector' => '{{WRAPPER}} .adina-vertical-menu-wrap',
			]
		);
        $this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'box_shadow',
				'label' => __( 'Box Shadow', 'plugin-domain' ),
				'selector' => '{{WRAPPER}} .adina-vertical-menu-wrap',
			]
		);
        
        $this->add_responsive_control(
            'box_readius',
            [
                'label' => __('Box Radius', 'adina'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .adina-vertical-menu-wrap' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );

        $this->end_controls_section();
    }

    /**
     * Render oEmbed widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $popular_post_key = array();
        $popular_meta_value_num = array();
        $settings = $this->get_settings_for_display();

        $args = [
            'menu'                  => $settings['selected_menu'],
            'menu_class'            => 'adina-vertical-menu',
            'menu_id'               => 'adina-vertical-menu',
            'container_class'       => 'adina-vertical-menu-container',
        ];
        ?>
        <div class="adina-vertical-menu-wrap ">
            <?php wp_nav_menu($args); ?>
        </div>
        <?php
    }
}

$widgets_manager->register(new \Elementor\Adina_Vertical_Menu());
