<?php
/**
 * Happyden Team Widget.
 *
 *
 * @since 1.0.0
 */

namespace Elementor;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\Widget_Base;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Css_Filter;
use Elementor\Icons_Manager;
use Elementor\Utils;
use Elementor\Repeater;
use Elementor\URL;
use \Elementor\Control_Media;

if (!defined('ABSPATH')) {
    exit;
}
// If this file is called directly, abort.
class VideoOne extends Widget_Base {
    public function get_name() {
        return 'adina_video_one';
    }
    public function get_title() {
        return __('Video One', 'adina');
    }
    public function get_icon() {
        return ('eicon-person');
    }
    public function get_categories() {
        return ['adina-addons'];
    }
    public function get_keywords() {
        return ['video', 'play'];
    }
    protected function register_controls() {
        $this->start_controls_section('general_section',
            [
                'label' => __('General ', 'adina'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
			'btn_text',
			[
				'label' => esc_html__( 'Button Text', 'adina' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'PLAY', 'adina' ),
				'label_block' => true,
			]
		);
        $this->add_control(
			'btn_urls',
			[
				'label' => esc_html__( 'Video Url', 'adina' ),
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__( '#', 'adina' ),
				'label_block' => true,
			]
		);
        $this->add_control(
			'bottom_text',
			[
				'label' => esc_html__( 'Bottom Text', 'adina' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Watch Now', 'adina' ),
				'label_block' => true,
			]
		);
        $this->add_control(
			'overlay_text',
			[
				'label' => esc_html__( 'Overlay Text', 'adina' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'WATCH OUR INTRO', 'adina' ),
				'label_block' => true,
			]
		);
        $this->add_control(
			'icon_class',
			[
				'label' => esc_html__( 'Here you can use Fontawsome Class', 'adina' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'icon-right-arrow-2', 'adina' ),
				'label_block' => true,
			]
		);
        $this->end_controls_section();


        // Box STYLE
        $this->start_controls_section('box_style',
            [
                'label' => __('Box', 'adina'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'background',
				'types' => [ 'classic', 'gradient', 'video' ],
				'selector' => '{{WRAPPER}} .video-one__inner::before',
			]
		);
        $this->add_responsive_control(
            'box_border_radius',
            [
                'label' => esc_html__( 'Border Radius', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'selectors' => [
                    '{{WRAPPER}} .video-one__inner' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'boxx_width',
            [
                'label' => esc_html__( 'Width', 'adina' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => '%',
                    'size' => 100,
                ],
                'selectors' => [
                    '{{WRAPPER}} .video-one__inner::before' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'boxx_height',
            [
                'label' => esc_html__( 'height', 'adina' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => '%',
                    'size' => 100,
                ],
                'selectors' => [
                    '{{WRAPPER}} .video-one__inner::before' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'box_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .video-one__inner' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'box_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .video-one__inner' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();


        // Button STYLE
        $this->start_controls_section('btn_style',
            [
                'label' => __('Button', 'adina'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs(
            'btn_styles'
        );

        $this->start_controls_tab(
            'btn_normal_style',
            [
                'label' => esc_html__( 'Normal', 'adina' ),
            ]
        );

        $this->add_control(
            'btn_colors',
            [
                'label' => __( 'Button Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .video-one__video a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'btn_typography',
                'selector' => '{{WRAPPER}} .video-one__video a',
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'btn_border',
                'selector' => '{{WRAPPER}} .video-one__video a',
            ]
        );
        $this->add_responsive_control(
            'btn_border_radius',
            [
                'label' => esc_html__( 'Border Radius', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'selectors' => [
                    '{{WRAPPER}} .video-one__video a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'v_btn_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .request-services-one__video-icon' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'v_btn_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .request-services-one__video-icon' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Box_Shadow::get_type(), 
			[
				'name' => 'btn_box_shadow',
				'selector' => '{{WRAPPER}} .video-one__video a:after, .video-one__video a:before',
			]
		);

        $this->end_controls_tab();

        $this->start_controls_tab(
            'btn_hover_style',
            [
                'label' => esc_html__( 'Hover', 'adina' ),
            ]
        );

        $this->add_control(
            'btn_hover_colors',
            [ 
                'label' => __( 'Button Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .video-one__video a:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'btn_hover_border',
                'selector' => '{{WRAPPER}} .video-one__video a:hover',
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();
        $this->end_controls_section();


        // Bottom Text STYLE
        $this->start_controls_section('bottom_text_style',
            [
                'label' => __('Bottom Text', 'adina'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs(
            'bottom_text_styles'
        );

        $this->start_controls_tab(
            'bottom_text_normal_style',
            [
                'label' => esc_html__( 'Normal', 'adina' ),
            ]
        );

        $this->add_control(
            'bottom_text_colors',
            [
                'label' => __( 'Bottom Text Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .video-one .title h3 a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'bottom_text_typography',
                'selector' => '{{WRAPPER}} .video-one .title h3 a',
            ]
        );
        $this->add_responsive_control(
            'bottom_text_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .video-one .title h3' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'bottom_text_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .video-one .title h3' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
			'bottom_text_align',
			[
				'label' => esc_html__( 'Alignment', 'adina' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'adina' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'adina' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'adina' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => 'center',
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .video-one .title h3' => 'text-align: {{VALUE}};',
				],
			]
		);

        $this->end_controls_tab();

        $this->start_controls_tab(
            'bottom_text_hover_style',
            [
                'label' => esc_html__( 'Hover', 'adina' ),
            ]
        );

        $this->add_control(
            'bottom_text_hover_color',
            [
                'label' => __( 'Hover Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .video-one .title h3 a:hover' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();
        $this->end_controls_section();

        // Overlay Text STYLE
        $this->start_controls_section('overlay_text_style',
            [
                'label' => __('Overlay Text', 'adina'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs(
            'overlay_text_styles'
        );

        $this->start_controls_tab(
            'overlay_text_normal_style',
            [
                'label' => esc_html__( 'Normal', 'adina' ),
            ]
        );

        $this->add_control(
            'overlay_text_colors',
            [
                'label' => __( 'Overlay Text Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .video-one .overlay-text h3 a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'overlay_text_typography',
                'selector' => '{{WRAPPER}} .video-one .overlay-text h3',
            ]
        );
        $this->add_responsive_control(
            'overlay_text_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .video-one .overlay-text h3' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'overlay_text_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .video-one .overlay-text h3' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'overlay_text_hover_style',
            [
                'label' => esc_html__( 'Hover', 'adina' ),
            ]
        );

        $this->add_control(
            'overlay_text_hover_color',
            [
                'label' => __( 'Hover Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .video-one .overlay-text h3 a:hover' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();
        $this->end_controls_section();

        // ICON STYLE
        $this->start_controls_section('icon_style',
            [
                'label' => __('Icon', 'adina'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs(
            'icon_styles'
        );

        $this->start_controls_tab(
            'icon_normal_style',
            [
                'label' => esc_html__( 'Normal', 'adina' ),
            ]
        );

        $this->add_control(
            'icon_color',
            [
                'label' => __( 'icon Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .video-one .overlay-text .icon a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
			'icon_width',
			[
				'label' => esc_html__( 'Size', 'adina' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 58,
				],
				'selectors' => [
					'{{WRAPPER}} .video-one .overlay-text .icon a span' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);
        $this->add_responsive_control(
            'icon_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .video-one .overlay-text .icon a span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'icon_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .video-one .overlay-text .icon a span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_tab();


        $this->start_controls_tab(
            'icon_hover_style',
            [
                'label' => esc_html__( 'Hover', 'adina' ),
            ]
        );

        $this->add_control(
            'icon_hover_color',
            [
                'label' => __( 'Icon Hover Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .video-one .overlay-text .icon a:hover' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();
        $this->end_controls_section();

    }

    protected function render() {
        $settings = $this->get_settings_for_display();

    ?>

        <section class="video-one">
            <div class="container no-pd">
                <div class="video-one__inner">
                    <div class="video-one__video">
                        <a href="<?php echo esc_url( $settings['btn_urls'] ); ?>" class="video-one__video-btn video-popup">
                            <span class="txt"><?php echo esc_html( $settings['btn_text'] ); ?></span>
                        </a>
                    </div>
                    <div class="title">
                        <h3><a href="<?php echo esc_url( $settings['btn_urls'] ); ?>"><?php echo esc_html( $settings['bottom_text'] ); ?></a></h3>
                    </div>
                    <div class="overlay-text">
                        <h3><a href="<?php echo esc_url( $settings['btn_urls'] ); ?>"><?php echo esc_html( $settings['overlay_text'] ); ?></a></h3>
                        <div class="icon">
                            <a href="<?php echo esc_url( $settings['btn_urls'] ); ?>"><span class="<?php echo esc_attr( $settings['icon_class'] ); ?>"></span></a>
                        </div>
                    </div>
                </div>
            </div>
        </section>

    <?php
}
}
$widgets_manager->register(new \Elementor\VideoOne());