<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Utils;
use \Elementor\Group_Control_Background;
use \Elementor\Repeater;
use \Elementor\Group_Control_Box_Shadow;
/**
 *
 * Accordionn Section Widget .
 *
 */
class Adina_Accordion_Section extends Widget_Base {

	public function get_name() {
		return 'adina_accordion_section';
	}

	public function get_title() {
		return __( 'Adina Accordion Section', 'adina' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'adina' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'faq_section',
			[
				'label' 	=> __( 'Section Content', 'adina' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			] 
        );
        $this->add_control(
            'section_bg_image',
            [
                'label' => __('Background Image', 'adina'),
                'type'  => Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
			'section_subtitle_text',
			[
				'label'   => esc_html__( 'SubTitle', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( 'Our FAQ', 'adina' ),
                'label_block' => true,
			]
		);
        $this->add_control(
			'section_title_text',
			[
				'label'   => esc_html__( 'Section Title', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( 'Got questions? We have answers', 'adina' ),
                'label_block' => true,
			]
		);
        $this->add_control(
            'section_left_image',
            [
                'label' => __('Left Image', 'adina'),
                'type'  => Controls_Manager::MEDIA,
            ]
        );
		$this->end_controls_section();

        // faq item
        $this->start_controls_section(
			'faq_content',
			[
				'label' 	=> __( 'Accordion', 'adina' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			] 
        );
        $repeater = new Repeater();

        $repeater->add_control(
			'faq_title',
			[
				'label'   => esc_html__( 'Title', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( 'What types of insurance do you offer?', 'adina' ),
                'label_block' => true,
			]
		);
        $repeater->add_control(
			'faq_text',
			[
				'label'   => esc_html__( 'Text', 'adina' ),
				'type'    => Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'Several factors influence your insurance premium, such as your age, driving record, location, coverage type, and the value of the insured property. Discover thousands of easy to customize themes, templates & CMS products, made by world-class developers.', 'adina' ),
                'label_block' => true,
			]
		);
        $this->add_control(
			'faq_item',
			[
				'label' => __( 'Item', 'adina' ),
				'type' 		=> Controls_Manager::REPEATER,
				'fields' 	=> $repeater->get_controls(),
			]
		);
		$this->end_controls_section();

        // Faq Box style
        $this->start_controls_section(
            'faq_box_style',
            [
                'label' => __( 'Faq Box', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'faq_box_bg_color',
            [
                'label' => __( 'Background Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-faq-area' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'faq_box_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-faq-area' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

        // Section SubTitle style
        $this->start_controls_section(
            'section_subtitle_style',
            [
                'label' => __( 'Section SubTitle', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'section_subtitle_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-section-title-pre' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'section_subtitle_typography',
				'selector' => '{{WRAPPER}} .td-section-title-pre',
			]
		);
		$this->add_responsive_control(
            'section_subtitle_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-section-title-pre' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

        // Section Title style
        $this->start_controls_section(
            'section_title_style',
            [
                'label' => __( 'Section Title', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'section_title_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-section-title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'section_title_typography',
				'selector' => '{{WRAPPER}} .td-section-title',
			]
		);
		$this->add_responsive_control(
            'section_title_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-faq-5-title-wrap' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

        // Title style
        $this->start_controls_section(
            'title_style',
            [
                'label' => __( 'Title', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'title_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-faq-btn-2' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'selector' => '{{WRAPPER}} .td-faq-btn-2',
			]
		);
        $this->add_responsive_control(
            'title_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-faq-5-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

        // Text style
        $this->start_controls_section(
            'text_style',
            [
                'label' => __( 'Text', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'text_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-faq-para p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'text_typography',
				'selector' => '{{WRAPPER}} .td-faq-para p',
			]
		);
        $this->add_responsive_control(
            'text_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-faq-para p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

        // Box style
        $this->start_controls_section(
            'box_style',
            [
                'label' => __( 'Box', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'box_bg_color',
            [
                'label' => __( 'Background Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-faq-5-accordion' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'box_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-faq-5-accordion' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'box_shadow',
				'selector' => '{{WRAPPER}} .td-faq-5-accordion'
			]
		);
		$this->end_controls_section();

	}

	protected function render() {
        $settings = $this->get_settings_for_display();

		?>
            <div class="td-faq-area p-relative  bg-position pt-140" style="background-image: url('<?php echo esc_url($settings['section_bg_image']['url']); ?>');">
                <div class="container">
                    <div class="row">
                        <div class="col-xl-5 col-lg-7">
                            <div class="td-faq-5-title-wrap mb-75 wow fadeInUp" data-wow-delay=".3s" data-wow-duration="1s">
                                <span class="td-section-title-pre mb-10">
                                    <?php echo esc_html( $settings[ 'section_subtitle_text' ]  ); ?>
                                </span>
                                <h2 class="td-section-title">
                                    <?php echo esc_html( $settings[ 'section_title_text' ]  ); ?>
                                </h2>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-lg-5">
                            <div class="td-faq-5-thumb wow fadeInRight" data-wow-delay=".3s" data-wow-duration="1s">
                                <img src="<?php echo esc_url($settings['section_left_image']['url']); ?>" alt="">
                            </div>
                        </div>
                        <div class="col-lg-7 wow fadeInLeft" data-wow-delay=".3s" data-wow-duration="1s">
                            <div class="td-faq-wrapper td-faq-5-wrapper mb-140">
                                <div class="accordion td-faq-4-accordion td-faq-5-accordion" id="return_faqaccordion">
                                    <?php 
                                    $index = 1; // Initialize index to generate unique IDs
                                    foreach( $settings['faq_item'] as $faq_item ) : 
                                        // Generate unique ID based on the index
                                        $faq_id = 'faq_' . $index;
                                        $collapse_id = 'collapse_' . $index;
                                    ?>
                                        <div class="accordion-item  <?php echo ($index === 1) ? 'td-faq-active' : ''; ?> td-faq-4-item td-faq-5-item">
                                            <h2 class="accordion-header" id="<?php echo esc_attr( $faq_id ); ?>">
                                                <button class="accordion-button <?php echo ($index !== 1) ? 'collapsed' : ''; ?> td-faq-btn-2 td-faq-4-btn td-faq-5-btn" type="button" data-bs-toggle="collapse" data-bs-target="#<?php echo esc_attr( $collapse_id ); ?>" aria-expanded="<?php echo ($index === 1) ? 'true' : 'false'; ?>" aria-controls="<?php echo esc_attr( $collapse_id ); ?>">
                                                    <?php echo esc_html( $faq_item['faq_title'] ); ?>
                                                    <span class="accordion-btn">
                                                    <b class="td-btn-group p-relative">
                                                        <i class="fa-solid fa-arrow-up-long fa-fw td-up"></i>
                                                        <i class="fa-solid fa-arrow-down-long fa-fw td-down"></i>
                                                    </b>
                                                    </span>
                                                </button>
                                            </h2>
                                            <div id="<?php echo esc_attr( $collapse_id ); ?>" class="accordion-collapse collapse <?php echo ($index === 1) ? 'show' : ''; ?>" aria-labelledby="<?php echo esc_attr( $faq_id ); ?>" data-bs-parent="#return_faqaccordion">
                                                <div class="accordion-body td-faq-para">
                                                    <p><?php echo esc_html( $faq_item['faq_text'] ); ?></p>
                                                </div>
                                            </div>
                                        </div>
                                    <?php 
                                        $index++; // Increment index for the next item
                                    endforeach; 
                                    ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
		<?php
	}
}
$widgets_manager->register( new \Adina_Accordion_Section() );