<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Utils;
use \Elementor\Group_Control_Background;
use \Elementor\Repeater;
use \Elementor\Group_Control_Box_Shadow;
/**
 *
 * Accordion Two Widget .
 *
 */
class Adina_Accordion_Two extends Widget_Base {

	public function get_name() {
		return 'adina_accordion_two';
	}

	public function get_title() {
		return __( 'Adina Accordion Two', 'adina' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'adina' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'faq_section',
			[
				'label' 	=> __( 'Accordion', 'adina' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			] 
        );
        $repeater = new Repeater();

        $repeater->add_control(
			'faq_title',
			[
				'label'   => esc_html__( 'Title', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( 'What is ROI and how is it calculated?', 'adina' ),
                'label_block' => true,
			]
		);
        $repeater->add_control(
            'need_images',
            [
                'label' => __( 'Need Images?', 'adina' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'adina' ),
                'label_off' => __( 'Hide', 'adina' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $repeater->add_control(
            'faq_image_one',
            [
                'label' => __('Image 01', 'adina'),
                'type'  => Controls_Manager::MEDIA,
            ]
        );
        $repeater->add_control(
            'faq_image_two',
            [
                'label' => __('Image 02', 'adina'),
                'type'  => Controls_Manager::MEDIA,
            ]
        );
        $repeater->add_control(
			'faq_text',
			[
				'label'   => esc_html__( 'Text', 'adina' ),
				'type'    => Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'Our focus is on delivering superior value to our clients for company modification. Providing sustainable strategies that will upgrade their business.', 'adina' ),
                'label_block' => true,
			]
		);
        $this->add_control(
			'faq_item',
			[
				'label' => __( 'Item', 'adina' ),
				'type' 		=> Controls_Manager::REPEATER,
				'fields' 	=> $repeater->get_controls(),
			]
		);
		$this->end_controls_section();

        // Title style
        $this->start_controls_section(
            'title_style',
            [
                'label' => __( 'Title', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'title_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-service-details-accordion-item .accordion-button' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'selector' => '{{WRAPPER}} .td-service-details-accordion-item .accordion-button',
			]
		);
        $this->add_responsive_control(
            'title_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-service-details-accordion-item .accordion-button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

        // Text style
        $this->start_controls_section(
            'text_style',
            [
                'label' => __( 'Text', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'text_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-service-details-accordion-item .accordion-body p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'text_typography',
				'selector' => '{{WRAPPER}} .td-service-details-accordion-item .accordion-body p',
			]
		);
        $this->add_responsive_control(
            'text_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-service-details-accordion-item .accordion-body p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

        // Box style
        $this->start_controls_section(
            'box_style',
            [
                'label' => __( 'Box', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'box_bg_color',
            [
                'label' => __( 'Background Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-service-details-accordion-item' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'box_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-service-details-accordion-item' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'box_border',
				'selector' => '{{WRAPPER}} .td-service-details-accordion-item',
			]
		);
		$this->end_controls_section();

	}

	protected function render() {
        $settings = $this->get_settings_for_display();

		?>
            <div class="accordion td-service-details-accordion" id="faqaccordion_image">
                <?php 
                    $index = 1; // Initialize index to generate unique IDs
                    foreach( $settings['faq_item'] as $faq_item ) : 
                        // Generate unique ID based on the index
                        $faq_id = 'faq_' . $index;
                        $collapse_id = 'collapse_' . $index;
                ?>
                    <div class="accordion-item td-service-details-accordion-item">
                        <h2 class="accordion-header" id="<?php echo esc_attr( $faq_id ); ?>">
                            <button class="accordion-button <?php echo ($index !== 1) ? 'collapsed' : ''; ?>" type="button" data-bs-toggle="collapse" data-bs-target="#<?php echo esc_attr( $collapse_id ); ?>" aria-expanded="<?php echo ($index === 1) ? 'true' : 'false'; ?>" aria-controls="<?php echo esc_attr( $collapse_id ); ?>">
                                <?php echo esc_html( $faq_item['faq_title'] ); ?>
                                <span class="accordion-btn"></span>
                            </button>
                        </h2>
                        <div id="<?php echo esc_attr( $collapse_id ); ?>" class="accordion-collapse collapse <?php echo ($index === 1) ? 'show' : ''; ?>" aria-labelledby="<?php echo esc_attr( $faq_id ); ?>" data-bs-parent="#faqaccordion_image">
                            <div class="accordion-body">
                                <?php if( $faq_item['need_images'] == 'yes' ): ?>
                                    <div class="row">
                                        <div class="col-lg-6 col-md-6 col-sm-6">
                                            <div class="td-faq-thumb mb-30">
                                                <img class="w-100" src="<?php echo esc_url($faq_item['faq_image_one']['url']); ?>" alt="faq">
                                            </div>
                                        </div>
                                        <div class="col-lg-6 col-md-6 col-sm-6">
                                            <div class="td-faq-thumb mb-30">
                                                <img class="w-100" src="<?php echo esc_url($faq_item['faq_image_two']['url']); ?>" alt="faq">
                                            </div>
                                        </div>
                                    </div>
                                <?php endif; ?>
                                <p><?php echo esc_html( $faq_item['faq_text'] ); ?></p>
                            </div>
                        </div>
                    </div>
                <?php 
                    $index++; // Increment index for the next item
                    endforeach; 
                ?>
            </div>
		<?php
	}
}
$widgets_manager->register( new \Adina_Accordion_Two() );