<div class="accordion td-service-details-accordion" id="faqaccordion_image">
    <?php 
        $index = 1; // Initialize index to generate unique IDs
        foreach( $settings['faq_item'] as $faq_item ) : 
            // Generate unique ID based on the index
            $faq_id = 'faq_' . $index;
            $collapse_id = 'collapse_' . $index;
    ?>
        <div class="accordion-item td-service-details-accordion-item">
            <h2 class="accordion-header" id="<?php echo esc_attr( $faq_id ); ?>">
                <button class="accordion-button <?php echo ($index !== 1) ? 'collapsed' : ''; ?>" type="button" data-bs-toggle="collapse" data-bs-target="#<?php echo esc_attr( $collapse_id ); ?>" aria-expanded="<?php echo ($index === 1) ? 'true' : 'false'; ?>" aria-controls="<?php echo esc_attr( $collapse_id ); ?>">
                    <?php echo esc_html( $faq_item['faq_title'] ); ?>
                    <span class="accordion-btn"></span>
                </button>
            </h2>
            <div id="<?php echo esc_attr( $collapse_id ); ?>" class="accordion-collapse collapse <?php echo ($index === 1) ? 'show' : ''; ?>" aria-labelledby="<?php echo esc_attr( $faq_id ); ?>" data-bs-parent="#faqaccordion_image">
                <div class="accordion-body">
                    <p><?php echo esc_html( $faq_item['faq_text'] ); ?></p>
                </div>
            </div>
        </div>
    <?php 
        $index++; // Increment index for the next item
        endforeach; 
    ?>
</div>