<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Utils;
use \Elementor\Group_Control_Background;
use \Elementor\Repeater;
/**
 *
 * Animation Shape Widget .
 *
 */
class Adina_Animation_Shape extends Widget_Base {

	public function get_name() {
		return 'adina_animation_shape';
	}

	public function get_title() {
		return __( 'Animation Shape', 'adina' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'adina' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'shape_section',
			[
				'label' 	=> __( 'Shape', 'adina' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			] 
        );
		$this->add_control(
            'image_layout',
            [
                'label' => esc_html__('Select Layout', 'adina'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'layout-1' => esc_html__('Horizontal', 'adina'),
                    'layout-2' => esc_html__('Vertical', 'adina'),
                ],
                'default' => 'layout-1',
            ]
        );
        $this->add_control(
            'shape_image',
            [
                'label' => __('Shape Image', 'adina'),
                'type'  => Controls_Manager::MEDIA,
            ]
        );
		$this->end_controls_section();

		// Image style
        $this->start_controls_section(
            'img_style',
            [
                'label' => __( 'Image', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
			'img_width',
			[
				'label' => esc_html__( 'Width', 'adina' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .td-impressions-shape' => 'width: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .td-about-3-shape-2' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'img_height',
			[
				'label' => esc_html__( 'Height', 'adina' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .td-impressions-shape' => 'height: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .td-about-3-shape-2' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();

	}

	protected function render() {
        $settings = $this->get_settings_for_display();

		?>
            <?php if ( $settings['image_layout'] == 'layout-1'): ?>  
            	<img class="td-impressions-shape tpleftright d-none d-lg-block" src="<?php echo esc_url( $settings[ 'shape_image' ]['url'] ); ?>" alt="shape">
            <?php endif; ?>

			<?php if ( $settings['image_layout'] == 'layout-2'): ?>  
				<img class="td-about-3-shape-2 d-none d-sm-block tpupdown" src="<?php echo esc_url( $settings[ 'shape_image' ]['url'] ); ?>" alt="shape">
            <?php endif; ?>

		<?php
	}
}
$widgets_manager->register( new \Adina_Animation_Shape() );