<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Utils;
use \Elementor\Group_Control_Background;
use \Elementor\Repeater;
/**
 *
 * Animation Title Widget .
 *
 */
class Adina_Animation_Title extends Widget_Base {

	public function get_name() {
		return 'animation_title';
	}

	public function get_title() {
		return __( 'Animation Title', 'adina' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'adina' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'title_section',
			[
				'label' 	=> __( 'Content', 'adina' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			] 
        );
		$this->add_control(
            'title_layout',
            [
                'label' => esc_html__('Select Layout', 'adina'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'layout-1' => esc_html__('Layout 1', 'adina'),
                    'layout-2' => esc_html__('Layout 2', 'adina'),
                ],
                'default' => 'layout-1',
            ]
        );
        $this->add_control(
			'title_text',
			[
				'label'   => esc_html__( 'Title', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( 'Let’s talk', 'adina' ),
                'label_block' => true,
			]
		);
		$this->end_controls_section();

        // Title style
        $this->start_controls_section(
            'title_style',
            [
                'label' => __( 'Title', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'fill_color',
            [
                'label' => __( 'Fill Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-footer-2-big-title' => '-webkit-text-fill-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'Stroke_color',
            [
                'label' => __( 'Stroke Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-footer-2-big-title' => '-webkit-text-stroke-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'selector' => '{{WRAPPER}} .td-footer-2-big-title',
			]
		);
        $this->add_responsive_control(
			'stroke_width',
			[
				'label' => esc_html__( 'Stroke Width', 'adina' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .td-footer-2-big-title' => '-webkit-text-stroke-width: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();

	}

	protected function render() {
        $settings = $this->get_settings_for_display();
        $layout = $settings['title_layout'];

		?>
            <?php
                if ( $layout) {
                    include('animation-title/'.$layout.'.php');
                }
            ?> 
		<?php
	}
}
$widgets_manager->register( new \Adina_Animation_Title() );