<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Utils;
use \Elementor\Group_Control_Background;
use \Elementor\Repeater;
/**
 *
 * Award Widget .
 *
 */
class Adina_Award extends Widget_Base {

	public function get_name() {
		return 'adina_award';
	}

	public function get_title() {
		return __( 'Adina Award', 'adina' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'adina' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'award_section',
			[
				'label' 	=> __( 'Content', 'adina' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			] 
        );
		$repeater = new Repeater();

        $repeater->add_control(
            'hover_image',
            [
                'label' => __('Hover Image', 'adina'),
                'type'  => Controls_Manager::MEDIA,
            ]
        );
        $repeater->add_control(
			'award_year',
			[
				'label'   => esc_html__( 'Award Year', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( '2024', 'adina' ),
			]
		);
        $repeater->add_control(
			'award_title',
			[
				'label'   => esc_html__( 'Award Title', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( 'TradingTech Insight Award', 'adina' ),
                'label_block' => true,
			]
		);
        $repeater->add_control(
			'award_link',
			[
				'label' => __( 'URL', 'adina' ),
				'type' => Controls_Manager::URL,
			]
		);
        $repeater->add_control(
			'award_location',
			[
				'label'   => esc_html__( 'Location', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( 'Boston, Massachusetts', 'adina' ),
                'label_block' => true,
			]
		);
        $this->add_control(
			'award_list',
			[
				'label' => __( 'Award List', 'adina' ),
				'type' 		=> Controls_Manager::REPEATER,
				'fields' 	=> $repeater->get_controls(),
			]
		);
		$this->end_controls_section();

        // Box style
        $this->start_controls_section(
            'box_style',
            [
                'label' => __( 'Box', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
            'box_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-awards-wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'box_border',
				'selector' => '{{WRAPPER}} .td-awards-wrapper',
			]
		);
        $this->add_control(
            'box_hover_border_color',
            [
                'label' => __( 'Hover Border Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-awards-wrapper::before' => 'background-color: {{VALUE}}',
                ],
            ]
        );
		$this->end_controls_section();

        // Year style
        $this->start_controls_section(
            'year_style',
            [
                'label' => __( 'Year', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'year_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-awards-content span' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'year_typography',
				'selector' => '{{WRAPPER}} .td-awards-content span',
			]
		);
		$this->add_responsive_control(
            'year_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-awards-content span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

        // Title style
        $this->start_controls_section(
            'title_style',
            [
                'label' => __( 'Title', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'title_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-awards-title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'selector' => '{{WRAPPER}} .td-awards-title',
			]
		);
		$this->end_controls_section();

        // Location style
        $this->start_controls_section(
            'location_style',
            [
                'label' => __( 'Location', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'location_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-awards-meta span' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'location_typography',
				'selector' => '{{WRAPPER}} .td-awards-meta span',
			]
		);
		$this->end_controls_section();

        // Icon style
        $this->start_controls_section(
            'icon_style',
            [
                'label' => __( 'Icon', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'icon_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-awards-btn' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'icon_hover_color',
            [
                'label' => __( 'Hover Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-awards-wrapper:hover .td-awards-btn' => 'color: {{VALUE}}',
                ],
            ]
        );
		$this->end_controls_section();

	}

	protected function render() {
        $settings = $this->get_settings_for_display();

		?>
            <?php foreach( $settings['award_list'] as $award_list ) : ?>
                <div class="td-awards-wrapper p-relative wow fadeInUp" data-wow-delay=".3s" data-wow-duration="1s">
                    <div class="td-awards-thumb">
                        <a href="<?php echo esc_url( $award_list[ 'award_link' ]['url'] ); ?>">
                            <img class="layer w-100" src="<?php echo esc_url( $award_list[ 'hover_image' ]['url'] ); ?>" alt="awards">
                        </a>
                    </div>
                    <div class="row align-items-center">
                        <div class="col-lg-8 col-md-8 mb-20">
                            <div class="td-awards-content d-flex align-items-center">
                                <span><?php echo esc_html( $award_list[ 'award_year' ]  ); ?></span>
                                <h4 class="td-awards-title">
                                    <a href="<?php echo esc_url( $award_list[ 'award_link' ]['url'] ); ?>">
                                        <?php echo esc_html( $award_list[ 'award_title' ]  ); ?>
                                    </a>
                                </h4>
                            </div>
                        </div>
                        <div class="col-lg-4 col-md-4 mb-20">
                            <div class="td-awards-meta d-flex justify-content-between">
                                <span><i class="fa-sharp fa-regular fa-location-dot"></i><?php echo esc_html( $award_list[ 'award_location' ]  ); ?></span>
                                <a class="td-awards-btn" href="<?php echo esc_url( $award_list[ 'award_link' ]['url'] ); ?>">
                                    <svg width="22" height="22" viewBox="0 0 22 22" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M2.66732 21.6667L0.333984 19.3333L16.334 3.33333H2.00065V0H22.0006V20H18.6673V5.66667L2.66732 21.6667Z" fill="currentColor" />
                                    </svg>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
		<?php
	}
}
$widgets_manager->register( new \Adina_Award() );