<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Utils;
/**
 *
 * Blog Post Widget .
 *
 */
class Adina_Blog_Post extends Widget_Base {

	public function get_name() {
		return 'adina_blog_post';
	}

	public function get_title() {
		return __( 'Adina Blog Post', 'adina' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'adina' ];
	}


	protected function register_controls() {

		$this->start_controls_section(
			'blog_settings',
			[
				'label' 	=> __( 'Blog Settings', 'adina' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );
        $this->add_control(
            'blog_layout',
            [
                'label' => esc_html__('Select Layout', 'adina'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'layout-1' => esc_html__('Layout 1', 'adina'),
                    'layout-2' => esc_html__('Layout 2', 'adina'),
                ],
                'default' => 'layout-1',
            ]
        );
		$this->add_control(
            'blog_per_page',
            [
                'label'       => __('Numbar Of Post', 'adina'),
                'type'        => Controls_Manager::NUMBER,
                'default'     => '',
                'description' => 'use empty value show all posts',
            ]
        );
		$this->add_control(
            'post_by',
            [
                'label' => __('Post By:', 'adina'),
                'type' => Controls_Manager::SELECT,
                'default' => 'latest',
                'label_block' => true,
                'options' => array(
                    'latest'   =>   __('Latest Post', 'adina'),
                    'selected' =>   __('Selected posts', 'adina'),
                ),
            ]
        );
        $this->add_control(
            'post__in',
            [
                'label' => __('Post In', 'adina'),
                'type' => Controls_Manager::SELECT2,
                'options' => adina_get_all_posts('post'),
                'multiple' => true,
                'label_block' => true,
                'condition'   => [
					'post_by' => 'selected',
				]
            ]
        );
        $this->add_control(
            'orderby',
            [
                'label' => __('Order By', 'adina'),
                'type' => Controls_Manager::SELECT,
                'options' => adina_get_post_orderby_options(),
                'default' => 'date',
                'label_block' => true,

            ]
        );
        $this->add_control(
            'order',
            [
                'label' => __('Order', 'adina'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'asc' => 'Ascending',
                    'desc' => 'Descending',
                ],
                'default' => 'desc',
                'label_block' => true,

            ]
        );
        $this->end_controls_section();

		// Blog Content
		$this->start_controls_section(
			'blog_content',
			[
				'label' 	=> __( 'Blog Content', 'adina' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );
		$this->add_control(
            'show_date',
            [
                'label' => __( 'Date?', 'adina' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'adina' ),
                'label_off' => __( 'Hide', 'adina' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
		$this->add_control(
            'show_excerpt',
            [
                'label' => __( 'Show Excerpt', 'adina' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'adina' ),
                'label_off' => __( 'Hide', 'adina' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'excerpt_limit',
            [
                'label' => __('Excerpt Word Limit', 'adina'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 15,
                ],
                'devices' => ['desktop', 'tablet', 'mobile'],
                'condition' => [
                    'show_excerpt' => 'yes',
                ]
            ]
        );
		$this->add_control(
            'show_btn',
            [
                'label' => __( 'Show Button', 'adina' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'adina' ),
                'label_off' => __( 'Hide', 'adina' ),
                'return_value' => 'yes',
                'default' => 'yes',
                'condition' => [
                    'blog_layout' => 'layout-1',
                ]
            ]
        );
        $this->end_controls_section();

        // Image style
        $this->start_controls_section(
            'img_style',
            [
                'label' => __( 'Image', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
			'img_width',
			[
				'label' => esc_html__( 'Width', 'adina' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .td-blog-thumb img' => 'width: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .td-blog-5-thumb img' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);
        $this->add_responsive_control(
			'img_height',
			[
				'label' => esc_html__( 'Height', 'adina' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .td-blog-thumb img' => 'height: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .td-blog-5-thumb img' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();

        // meta style
        $this->start_controls_section(
            'meta_style',
            [
                'label' => __( 'Meta', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'meta_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-blog-meta' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .td-blog-5-qoute-meta span' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'category_color',
            [
                'label' => __( 'Category Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-blog-5-qoute-meta span.designation' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'meta_typography',
				'selector' => '{{WRAPPER}} .td-blog-meta, {{WRAPPER}} .td-blog-5-qoute-meta span',
			]
		);
        $this->add_responsive_control(
            'meta_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-blog-meta' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .td-blog-5-qoute-meta' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

        // title style
        $this->start_controls_section(
            'title_style',
            [
                'label' => __( 'Title', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'title_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-blog-title' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .td-blog-5-qoute-title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'selector' => '{{WRAPPER}} .td-blog-title, {{WRAPPER}} .td-blog-5-qoute-title',
			]
		);
        $this->add_responsive_control(
            'title_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-blog-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .td-blog-5-qoute-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

        // text style
        $this->start_controls_section(
            'text_style',
            [
                'label' => __( 'Text', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'text_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-blog-content p' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .td-blog-5-content p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'text_typography',
				'selector' => '{{WRAPPER}} .td-blog-content p, {{WRAPPER}} .td-blog-5-content p',
			]
		);
        $this->add_responsive_control(
            'text_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-blog-content p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .td-blog-5-content p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

        // Button Icon style
        $this->start_controls_section(
            'button_icon_style',
            [
                'label' => __( 'Button Icon', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'blog_layout' => 'layout-1',
                ]
            ]
        );
        $this->add_control(
            'button_icon_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-blog-btn' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'button_icon_hover_color',
            [
                'label' => __( 'Hover Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-blog-btn:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'button_icon_bg_color',
            [
                'label' => __( 'Background Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-blog-btn' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'button_icon_hover_bg_color',
            [
                'label' => __( 'Background Hover Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-blog-btn:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
			'icon_size',
			[
				'label' => esc_html__( 'Iconbox Size', 'adina' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .td-blog-btn' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();

    }

	protected function render() {

        $settings = $this->get_settings_for_display();
        $layout = $settings['blog_layout'];

        ?>

		<?php
            // Query
            $numabr_of_post = !empty($settings['blog_per_page']) ? $settings['blog_per_page'] : -1;

            $query_args = [
                'post_type'           => 'post',
                'orderby' => $settings['orderby'],
                'order'   => $settings['order'],
                'posts_per_page'      => $numabr_of_post,
                'post_status'         => 'publish',
                'ignore_sticky_posts' => 1,
            ];

            // get_type
            if ( 'selected' === $settings['post_by'] ) {
                $query_args['post__in'] = (array)$settings['post__in'];
            }

            $the_query = new \WP_Query($query_args);

		?>
            <?php
                if ( $layout) {
                    include('blog/'.$layout.'.php');
                }
            ?> 
		<?php

	}

}
$widgets_manager->register( new \Adina_Blog_Post() );