<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Utils;
/**
 *
 * Blog Slider Widget .
 *
 */
class Adina_Blog_Slider extends Widget_Base {

	public function get_name() {
		return 'adina_blog_slider';
	}

	public function get_title() {
		return __( 'Adina Blog Slider', 'adina' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'adina' ];
	}


	protected function register_controls() {

		$this->start_controls_section(
			'blog_settings',
			[
				'label' 	=> __( 'Blog Settings', 'adina' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );
		$this->add_control(
            'blog_per_page',
            [
                'label'       => __('Numbar Of Post', 'adina'),
                'type'        => Controls_Manager::NUMBER,
                'default'     => '',
                'description' => 'use empty value show all posts',
            ]
        );
		$this->add_control(
            'post_by',
            [
                'label' => __('Post By:', 'adina'),
                'type' => Controls_Manager::SELECT,
                'default' => 'latest',
                'label_block' => true,
                'options' => array(
                    'latest'   =>   __('Latest Post', 'adina'),
                    'selected' =>   __('Selected posts', 'adina'),
                ),
            ]
        );
        $this->add_control(
            'post__in',
            [
                'label' => __('Post In', 'adina'),
                'type' => Controls_Manager::SELECT2,
                'options' => adina_get_all_posts('post'),
                'multiple' => true,
                'label_block' => true,
                'condition'   => [
					'post_by' => 'selected',
				]
            ]
        );
        $this->add_control(
            'orderby',
            [
                'label' => __('Order By', 'adina'),
                'type' => Controls_Manager::SELECT,
                'options' => adina_get_post_orderby_options(),
                'default' => 'date',
                'label_block' => true,

            ]
        );
        $this->add_control(
            'order',
            [
                'label' => __('Order', 'adina'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'asc' => 'Ascending',
                    'desc' => 'Descending',
                ],
                'default' => 'desc',
                'label_block' => true,

            ]
        );
        $this->end_controls_section();

		// Blog Content
		$this->start_controls_section(
			'blog_content',
			[
				'label' 	=> __( 'Blog Content', 'adina' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );
		$this->add_control(
            'show_date',
            [
                'label' => __( 'Date?', 'adina' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'adina' ),
                'label_off' => __( 'Hide', 'adina' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
		$this->add_control(
            'show_excerpt',
            [
                'label' => __( 'Show Excerpt', 'adina' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'adina' ),
                'label_off' => __( 'Hide', 'adina' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'excerpt_limit',
            [
                'label' => __('Excerpt Word Limit', 'adina'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 15,
                ],
                'devices' => ['desktop', 'tablet', 'mobile'],
                'condition' => [
                    'show_excerpt' => 'yes',
                ]
            ]
        );
		$this->end_controls_section();

        // Image style
        $this->start_controls_section(
            'img_style',
            [
                'label' => __( 'Image', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
			'img_width',
			[
				'label' => esc_html__( 'Width', 'adina' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .td-blog-thumb img' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);
        $this->add_responsive_control(
			'img_height',
			[
				'label' => esc_html__( 'Height', 'adina' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .td-blog-thumb img' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();

        // Category style
        $this->start_controls_section(
            'category_style',
            [
                'label' => __( 'Category', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'category_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-blog-2-tag' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'category_typography',
				'selector' => '{{WRAPPER}} .td-blog-meta-2 span',
			]
		);
        $this->add_responsive_control(
            'category_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-blog-meta-2' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

        // date style
        $this->start_controls_section(
            'date_style',
            [
                'label' => __( 'Date', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'date_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-blog-meta-2 span' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'date_typography',
				'selector' => '{{WRAPPER}} .td-blog-meta-2 span',
			]
		);
		$this->end_controls_section();

        // title style
        $this->start_controls_section(
            'title_style',
            [
                'label' => __( 'Title', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'title_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-blog-title-2' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'selector' => '{{WRAPPER}} .td-blog-title-2',
			]
		);
        $this->add_responsive_control(
            'title_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-blog-title-2' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

        // text style
        $this->start_controls_section(
            'text_style',
            [
                'label' => __( 'Text', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'text_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-blog-content p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'text_typography',
				'selector' => '{{WRAPPER}} .td-blog-content p',
			]
		);
        $this->add_responsive_control(
            'text_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-blog-content p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

    }

	protected function render() {

        $settings = $this->get_settings_for_display();

        ?>

		<?php
            // Query
            $numabr_of_post = !empty($settings['blog_per_page']) ? $settings['blog_per_page'] : -1;

            $query_args = [
                'post_type'           => 'post',
                'orderby' => $settings['orderby'],
                'order'   => $settings['order'],
                'posts_per_page'      => $numabr_of_post,
                'post_status'         => 'publish',
                'ignore_sticky_posts' => 1,
            ];

            // get_type
            if ( 'selected' === $settings['post_by'] ) {
                $query_args['post__in'] = (array)$settings['post__in'];
            }

            $the_query = new \WP_Query($query_args);

		?>
            <div class="td-blog-slider-wrap">
                <div class="swiper-container td-blog-slider-active">
                    <div class="swiper-wrapper">
                        <?php if ($the_query->have_posts()) {
                            while ($the_query->have_posts()) {
                                $the_query->the_post();
                                $excerpt = (isset($settings['excerpt_limit']['size']) && $settings['excerpt_limit']['size']) 
                                            ? wp_trim_words(get_the_excerpt(), $settings['excerpt_limit']['size'], '') 
                                            : get_the_excerpt();
                        ?>
                            <div class="swiper-slide wow slideInDown" data-wow-delay=".3s" data-wow-duration="1s">
                                <div class="td-blog-content">
                                    <?php if( has_post_thumbnail() ): ?>
                                        <div class="td-blog-thumb mb-30">
                                            <?php the_post_thumbnail('full');?>
                                        </div>
                                    <?php endif; ?>

                                    <div class="td-blog-meta-2 mb-15">
                                        <span class="td-blog-2-tag">
                                            <?php
                                                $categories = get_the_category();
                                                if ($categories) {
                                                    // Get the first category
                                                    $first_category = $categories[0];
                                                    echo esc_html($first_category->name);
                                                }
                                            ?>
                                        </span>
                                        <?php if( $settings['show_date'] == 'yes' ): ?>
                                            <span class="dvdr">
                                                <?php echo esc_html__( '/', 'adina' ); ?>
                                            </span>
                                            <span>
                                                <?php echo get_the_time('M j, Y'); ?>
                                            </span>
                                        <?php endif; ?>
                                    </div>
                                    <h3 class="td-blog-title td-blog-title-2">
                                        <a href="<?php the_permalink(); ?>">
                                            <?php the_title(); ?>
                                        </a>
                                    </h3>

                                    <?php if( $settings['show_excerpt'] == 'yes' ): ?>
                                        <?php echo esc_html( $excerpt ); ?>
                                    <?php endif; ?>
                                </div>
                            </div>
                        <?php
                            }
                            // Restore original Post Data.
                            wp_reset_postdata();
                            }
                        ?>
                    </div>
                </div>
            </div>
		<?php

	}

}
$widgets_manager->register( new \Adina_Blog_Slider() );