<div class="row">
    <?php if ($the_query->have_posts()) {
        while ($the_query->have_posts()) {
            $the_query->the_post();
            $excerpt = (isset($settings['excerpt_limit']['size']) && $settings['excerpt_limit']['size']) 
                        ? wp_trim_words(get_the_excerpt(), $settings['excerpt_limit']['size'], '') 
                        : get_the_excerpt();
        ?>

        <div class="col-lg-4 col-sm-6 mb-40">
            <div class="td-blog-wrapper wow fadeInUp" data-wow-delay=".3s" data-wow-duration="1s">
                <div class="td-blog-content">
                    <?php if( has_post_thumbnail() ): ?>
                        <div class="td-blog-thumb mb-30">
                            <?php the_post_thumbnail('full');?>
                        </div>
                    <?php endif; ?>

                    <span class="td-blog-meta">
                        <?php if( $settings['show_date'] == 'yes' ): ?>
                            <?php echo get_the_time('M j, Y'); ?>
                            <?php echo esc_html__( '/', 'adina' ); ?>
                        <?php endif; ?>
                        <?php
                            $categories = get_the_category();
                            if ($categories) {
                                // Get the first category
                                $first_category = $categories[0];
                                echo esc_html($first_category->name);
                            }
                        ?>
                    </span>
                    <h3 class="td-blog-title mb-65">
                        <a href="<?php the_permalink(); ?>">
                            <?php the_title(); ?>
                        </a>
                    </h3>

                    <?php if( $settings['show_excerpt'] == 'yes' ): ?>
                        <?php echo esc_html( $excerpt ); ?>
                    <?php endif; ?>

                    <?php if( $settings['show_btn'] == 'yes' ): ?>
                        <div class="td-blog-btn-wrap">
                            <a class="td-blog-btn" href="<?php the_permalink(); ?>">
                                <svg width="18" height="15" viewBox="0 0 18 15" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M17.3832 6.08007L11.2205 0.196711C10.9462 -0.06514 10.501 -0.0656087 10.2261 0.195539C9.95117 0.45672 9.9506 0.880717 10.2249 1.14253L16.3881 7.02653C16.6622 7.28761 16.6622 7.71244 16.3875 7.97409L10.2249 13.8575C9.95064 14.1193 9.95117 14.5433 10.2261 14.8045C10.3633 14.9348 10.5431 15 10.7227 15C10.9029 15 11.0832 14.9344 11.2206 14.8033L17.3826 8.92052C18.205 8.13724 18.205 6.86274 17.3832 6.08007Z" fill="currentColor" />
                                    <path d="M13.4655 6.83008H0.703159C0.314789 6.83008 0 7.1299 0 7.49972C0 7.86955 0.314789 8.16936 0.703159 8.16936H13.4655C13.8539 8.16936 14.1687 7.86958 14.1687 7.49972C14.1687 7.12986 13.8539 6.83008 13.4655 6.83008Z" fill="currentColor" />
                                </svg>
                            </a>
                        </div>
                    <?php endif; ?>

                </div>
            </div>
        </div>

    <?php
        }
        // Restore original Post Data.
        wp_reset_postdata();
        }
    ?>
</div>    