<div class="row">
    <?php if ($the_query->have_posts()) {
        while ($the_query->have_posts()) {
            $the_query->the_post();
            $excerpt = (isset($settings['excerpt_limit']['size']) && $settings['excerpt_limit']['size']) 
                        ? wp_trim_words(get_the_excerpt(), $settings['excerpt_limit']['size'], '') 
                        : get_the_excerpt();
        ?>
        <div class="col-lg-12 col-md-6">
            <div class="td-blog-5-wrap mb-40">
                <?php if( has_post_thumbnail() ): ?>
                    <div class="td-blog-5-thumb mb-25">
                        <?php the_post_thumbnail('full');?>
                    </div>
                <?php endif; ?>

                <div class="td-blog-5-content text-center">
                    <div class="td-blog-5-qoute-meta mb-5">
                        <span class="designation">
                            <?php
                                $categories = get_the_category();
                                if ($categories) {
                                    // Get the first category
                                    $first_category = $categories[0];
                                    echo esc_html($first_category->name);
                                }
                            ?>
                        </span>

                        <?php if( $settings['show_date'] == 'yes' ): ?>
                            <span class="dvdr">
                                <?php echo esc_html__( '|', 'adina' ); ?>
                            </span>
                            <span> 
                                <?php echo get_the_time('M j, Y'); ?>
                            </span>
                        <?php endif; ?>

                    </div>
                    <h3 class="td-blog-5-qoute-title">
                        <a href="<?php the_permalink(); ?>">
                            <?php the_title(); ?>
                        </a>
                    </h3>
                    <?php if( $settings['show_excerpt'] == 'yes' ): ?>
                        <?php echo esc_html( $excerpt ); ?>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    <?php
        }
        // Restore original Post Data.
        wp_reset_postdata();
        }
    ?>
</div>