<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Utils;
use \Elementor\Group_Control_Background;
use \Elementor\Repeater;
/**
 *
 * Brand Logo Widget .
 *
 */
class Adina_Brand_Logo extends Widget_Base {

	public function get_name() {
		return 'adina_Brand_Logo';
	}

	public function get_title() {
		return __( 'Adina Brand Logo', 'adina' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'adina' ];
	}

	protected function register_controls() {

        // slider item
        $this->start_controls_section(
			'Brand_Logo_section',
			[
				'label' 	=> __( 'Content', 'adina' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			] 
        );
        $this->add_control(
            'logo_layout',
            [
                'label' => esc_html__('logo/counter', 'adina'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'logo' => esc_html__('Logo', 'adina'),
                    'counter' => esc_html__('Counter', 'adina'),
                ],
                'default' => 'logo',
            ]
        );
        $this->add_control(
            'logo_image',
            [
                'label' => __('Logo Image', 'adina'),
                'type'  => Controls_Manager::MEDIA,
                'condition' => [
                    'logo_layout' => 'logo',
                ]
            ]
        );
        $this->add_control(
			'logo_link',
			[
				'label' => __( 'URL', 'adina' ),
				'type' => Controls_Manager::URL,
                'condition' => [
                    'logo_layout' => 'logo',
                ]
			]
		);
        $this->add_control(
			'counter_nmbr',
			[
				'label'   => esc_html__( 'Number', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( '100', 'adina' ),
                'label_block' => true,
                'condition' => [
                    'logo_layout' => 'counter',
                ]
			]
		);
        $this->add_control(
			'counter_suffix',
			[
				'label'   => esc_html__( 'Suffix', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( 'k', 'adina' ),
                'label_block' => true,
                'condition' => [
                    'logo_layout' => 'counter',
                ]
			]
		);
        $this->add_control(
			'counter_text',
			[
				'label'   => esc_html__( 'Counter Text', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( 'Satisfied Clients', 'adina' ),
                'label_block' => true,
                'condition' => [
                    'logo_layout' => 'counter',
                ]
			]
		);
		$this->end_controls_section();

        // logo style
        $this->start_controls_section(
            'logo_style',
            [
                'label' => __( 'logo', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'logo_layout' => 'logo',
                ]
            ]
        );
        $this->add_responsive_control(
            'logo_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-brand-logo-wrap-2' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'logo_border',
				'selector' => '{{WRAPPER}} .td-brand-logo-border',
			]
		);
		$this->end_controls_section();

        // Counter style
        $this->start_controls_section(
            'counter_style',
            [
                'label' => __( 'Counter', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'logo_layout' => 'counter',
                ]
            ]
        );
        $this->add_control(
            'counter_color',
            [
                'label' => __( 'Number Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-brand-counter-title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'counter_typography',
				'selector' => '{{WRAPPER}} .td-brand-counter-title',
			]
		);
		$this->add_responsive_control(
            'counter_margin',
            [
                'label' => __( 'Number Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-brand-counter-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'text_color',
            [
                'label' => __( 'Text Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-brand-counter-pre' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'text_typography',
				'selector' => '{{WRAPPER}} .td-brand-counter-pre',
			]
		);
        $this->add_responsive_control(
            'counter_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-brand-logo-wrap-space' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'counter_border',
				'selector' => '{{WRAPPER}} .td-brand-logo-border',
			]
		);
		$this->end_controls_section();

	}

	protected function render() {
        $settings = $this->get_settings_for_display();

		?>
            <?php if ( $settings['logo_layout'] == 'logo'): ?>  
                <div class="td-brand-logo-wrap-2 td-brand-logo-border p-relative text-center">
                    <a href="<?php echo esc_url($settings['logo_link']['url']); ?>">
                        <img class="td-brand-logo-2" src="<?php echo esc_url($settings['logo_image']['url']); ?>" alt="brand">
                    </a>
                    <span class="td-brand-shape td-brand-shape-position"><i class="fa-sharp fa-regular fa-plus fa-fw"></i></span>
                    <span class="td-brand-shape td-brand-shape-position-2"><i class="fa-sharp fa-regular fa-plus fa-fw"></i></span>
                    <span class="td-brand-shape td-brand-shape-position-3"><i class="fa-sharp fa-regular fa-plus fa-fw"></i></span>
                    <span class="td-brand-shape td-brand-shape-position-4"><i class="fa-sharp fa-regular fa-plus fa-fw"></i></span>
                </div>
            <?php endif; ?>

            <?php if ( $settings['logo_layout'] == 'counter'): ?>  
                <div class="td-brand-logo-wrap-2 td-brand-logo-wrap-space td-brand-logo-border p-relative text-center">
                    <div class="td-brand-counter">
                        <h2 class="td-brand-counter-title">
                            <span data-purecounter-duration="1" data-purecounter-end="<?php echo esc_attr( $settings[ 'counter_nmbr' ]  ); ?>" class="purecounter">
                                <?php echo esc_html( $settings[ 'counter_nmbr' ]  ); ?>
                            </span>
                            <?php echo esc_html( $settings[ 'counter_suffix' ]  ); ?>
                        </h2>
                        <span class="td-brand-counter-pre"><?php echo esc_html( $settings[ 'counter_text' ]  ); ?></span>
                    </div>
                    <span class="td-brand-shape td-brand-shape-position"><i class="fa-sharp fa-regular fa-plus fa-fw"></i></span>
                    <span class="td-brand-shape td-brand-shape-position-2"><i class="fa-sharp fa-regular fa-plus fa-fw"></i></span>
                    <span class="td-brand-shape td-brand-shape-position-3"><i class="fa-sharp fa-regular fa-plus fa-fw"></i></span>
                    <span class="td-brand-shape td-brand-shape-position-4"><i class="fa-sharp fa-regular fa-plus fa-fw"></i></span>
                </div>
            <?php endif; ?>
		<?php
	}
}
$widgets_manager->register( new \Adina_Brand_Logo() );