<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Utils;
use \Elementor\Group_Control_Background;
use \Elementor\Repeater;
use \Elementor\Icons_Manager;
/**
 *
 * Business Category Widget .
 *
 */
class Adina_Business_Category extends Widget_Base {

	public function get_name() {
		return 'adina_business_category';
	}

	public function get_title() {
		return __( 'Adina Business Category', 'adina' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'adina' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'business_category_section',
			[
				'label' 	=> __( 'Business Category', 'adina' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			] 
        );
        $this->add_control(
			'category_text01',
			[
				'label'   => esc_html__( 'Category 01', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( 'Investment', 'adina' ),
                'label_block' => true,
			]
		);
        $this->add_control(
			'category_text02',
			[
				'label'   => esc_html__( 'Category 02', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( 'Economy', 'adina' ),
                'label_block' => true,
			]
		);
        $this->add_control(
			'category_text03',
			[
				'label'   => esc_html__( 'Category 03', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( 'Finances', 'adina' ),
                'label_block' => true,
			]
		);
        $this->add_control(
            'business_icon',
            [
                'label' => __('Image', 'adina'),
                'type'  => Controls_Manager::MEDIA,
            ]
        );      
        $this->add_control(
			'business_title',
			[
				'label'   => esc_html__( 'Title', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( 'Financial report 2015', 'adina' ),
                'label_block' => true,
			]
		);
        $this->add_control(
			'business_link',
			[
				'label' => __( 'URL', 'adina' ),
				'type' => Controls_Manager::URL,
			]
		);
        $this->add_control(
			'business_text',
			[
				'label'   => esc_html__( 'Text', 'adina' ),
				'type'    => Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'Our focus is on delivering superior value to our clients for company modification.', 'adina' ),
                'label_block' => true,
			]
		);
		$this->end_controls_section();

        // Category style
        $this->start_controls_section(
            'category_style',
            [
                'label' => __( 'Category', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'category_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-business-tag a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'category_typography',
				'selector' => '{{WRAPPER}} .td-business-tag a',
			]
		);
        $this->add_responsive_control(
            'category_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-business-tag' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

        // Image style
        $this->start_controls_section(
            'img_style',
            [
                'label' => __( 'Image', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
            'img_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-business-chat' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

        // Title style
        $this->start_controls_section(
            'title_style',
            [
                'label' => __( 'Title', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'title_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-business-title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'selector' => '{{WRAPPER}} .td-business-title',
			]
		);
        $this->add_responsive_control(
            'title_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-business-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

        // Text style
        $this->start_controls_section(
            'text_style',
            [
                'label' => __( 'Text', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'text_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-business-para' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'text_typography',
				'selector' => '{{WRAPPER}} .td-business-para',
			]
		);
        $this->add_responsive_control(
            'text_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-business-para' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

	}

	protected function render() {
        $settings = $this->get_settings_for_display();

		?>
            <div class="td-business-wraper text-center">
                <div class="td-business-tag mb-40">
                    <a href="#"><span></span> <?php echo esc_html( $settings[ 'category_text01' ]  ); ?></a>
                    <a href="#"><span class="enable-1"></span> <?php echo esc_html( $settings[ 'category_text02' ]  ); ?></a>
                    <a href="#"><span class="enable-2"></span> <?php echo esc_html( $settings[ 'category_text03' ]  ); ?></a>
                </div>
                <div class="td-business-chat mb-50">
				    <img src="<?php echo esc_url( $settings[ 'business_icon' ]['url'] ); ?>" alt="shape">
                </div>
                <div class="td-business-content">
                    <h3 class="td-business-title mb-20">
                        <a href="<?php echo esc_url($settings['business_link']['url']); ?>">
                            <?php echo esc_html( $settings[ 'business_title' ]  ); ?>
                        </a>
                    </h3>
                    <p class="td-business-para"><?php echo esc_html( $settings[ 'business_text' ]  ); ?></p>
                </div>
            </div>
		<?php
	}
}
$widgets_manager->register( new \Adina_Business_Category() );