<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Utils;
use \Elementor\Group_Control_Background;
use \Elementor\Repeater;
/**
 *
 * Counter Logo Widget .
 *
 */
class Adina_Counter_Logo extends Widget_Base {

	public function get_name() {
		return 'counter_logo';
	}

	public function get_title() {
		return __( 'Counter Logo', 'adina' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'adina' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'counter_section',
			[
				'label' 	=> __( 'Content', 'adina' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			] 
        );
		$this->add_control(
            'logo_layout',
            [
                'label' => esc_html__('Select Layout', 'adina'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'layout-1' => esc_html__('Layout 1', 'adina'),
                    'layout-2' => esc_html__('Layout 2', 'adina'),
                ],
                'default' => 'layout-1',
            ]
        );
        $this->add_control(
			'logo_text',
			[
				'label'   => esc_html__( 'Logo Text', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( 'E.', 'adina' ),
                'label_block' => true,
				'condition' => [
                    'logo_layout' => 'layout-1',
                ]
			]
		);
		$this->add_control(
            'logo_image',
            [
                'label' => __('Image', 'adina'),
                'type'  => Controls_Manager::MEDIA,
				'condition' => [
                    'logo_layout' => 'layout-2',
                ]
            ]
        );
		$this->add_control(
			'logo_url',
			[
				'label' => __( 'URL', 'adina' ),
				'type' => Controls_Manager::URL,
				'condition' => [
                    'logo_layout' => 'layout-2',
                ]
			]
		);
		$this->end_controls_section();

		// logo style
        $this->start_controls_section(
            'logo_style',
            [
                'label' => __( 'Logo', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
				'condition' => [
                    'logo_layout' => 'layout-1',
                ]
            ]
        );
		$this->add_control(
            'logo_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-counter-logo' => 'color: {{VALUE}}',
                ],
            ]
        );
		$this->add_control(
            'logo_bg_color',
            [
                'label' => __( 'Background Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-counter-logo' => 'background-color: {{VALUE}}',
                ],
            ]
        );
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'logo_typography',
				'selector' => '{{WRAPPER}} .td-counter-logo',
			]
		);
		$this->end_controls_section();

	}

	protected function render() {
        $settings = $this->get_settings_for_display();

		?>
			<?php if ( $settings['logo_layout'] == 'layout-1'): ?>  
				<div class="td-counter-logo d-none d-sm-block td-pulse-border">
					<h3><?php echo esc_html( $settings[ 'logo_text' ]  ); ?></h3>
				</div>
			<?php endif; ?>

			<?php if ( $settings['logo_layout'] == 'layout-2'): ?>  
				<div class="td-service-4-logo td-video-4-logo">
					<a class="td-pulse-border" href="<?php echo esc_url( $settings[ 'logo_url' ]['url'] ); ?>">
						<img src="<?php echo esc_url( $settings[ 'logo_image' ]['url'] ); ?>" alt="logo">
					</a>
				</div>
			<?php endif; ?>
		<?php
	}
}
$widgets_manager->register( new \Adina_Counter_Logo() );