<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Utils;
use \Elementor\Group_Control_Background;
use \Elementor\Repeater;
/**
 *
 * Cta Widget .
 *
 */
class Adina_Cta extends Widget_Base {

	public function get_name() {
		return 'adina_cta';
	}

	public function get_title() {
		return __( 'Adina Cta', 'adina' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'adina' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'cta_section',
			[
				'label' 	=> __( 'Content', 'adina' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			] 
        );
        $this->add_control(
			'cta_title',
			[
				'label'   => esc_html__( 'Title', 'adina' ),
				'type'    => Controls_Manager::TEXT,
                'default' => esc_html__( 'Subscribe to people  first dispatch', 'adina' ),
                'label_block' => true,
			]
		);
        $this->add_control(
			'cta_text',
			[
				'label'   => esc_html__( 'Text', 'adina' ),
				'type'    => Controls_Manager::TEXTAREA,
                'default' => esc_html__( 'Get a amazing solution with us.', 'adina' ),
                'label_block' => true,
			]
		);
        $this->add_control(
			'form_shortcode',
			[
				'label'   => esc_html__( 'Form Shortcode', 'adina' ),
				'type'    => Controls_Manager::TEXTAREA,
                'label_block' => true,
			]
		);
        $this->add_control(
            'cta_shape_one',
            [
                'label' => __('Shape 01', 'adina'),
                'type'  => Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
            'cta_shape_two',
            [
                'label' => __('Shape 01', 'adina'),
                'type'  => Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
            'cta_shape_three',
            [
                'label' => __('Shape 01', 'adina'),
                'type'  => Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
            'cta_shape_four',
            [
                'label' => __('Shape 01', 'adina'),
                'type'  => Controls_Manager::MEDIA,
            ]
        );
		$this->end_controls_section();

        // title style
        $this->start_controls_section(
            'title_style',
            [
                'label' => __( 'Title', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'title_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-subscribe-5-title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'selector' => '{{WRAPPER}} .td-subscribe-5-title',
			]
		);
        $this->add_responsive_control(
            'title_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-subscribe-5-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

        // text style
        $this->start_controls_section(
            'text_style',
            [
                'label' => __( 'Text', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'text_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-subscribe-5-wrap p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'text_typography',
				'selector' => '{{WRAPPER}} .td-subscribe-5-wrap p',
			]
		);
        $this->add_responsive_control(
            'text_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-subscribe-5-wrap p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

         // box style
         $this->start_controls_section(
            'box_style',
            [
                'label' => __( 'Box', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'box_bg_color',
            [
                'label' => __( 'Background Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-subscribe-5-wrap' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'box_bg_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-subscribe-5-wrap' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

	}

	protected function render() {
        $settings = $this->get_settings_for_display();

		?>
            <div class="td-subscribe-area">
                <div class="container">
                    <div class="row justify-content-center">
                        <div class="col-lg-10">
                            <div class="td-subscribe-5-wrap p-relative text-center">
                                <div class="td-subscribe-5-shape tpupdown d-none d-md-block">
                                    <span>
                                        <img src="<?php echo esc_url( $settings[ 'cta_shape_one' ]['url'] ); ?>" alt="shape1">
                                    </span>
                                </div>
                                <div class="td-subscribe-5-shape-2 tree-move d-none d-md-block">
                                    <span>
                                        <img src="<?php echo esc_url( $settings[ 'cta_shape_two' ]['url'] ); ?>" alt="shape1">
                                    </span>
                                </div>
                                <div class="td-subscribe-5-shape-3 tree-move d-none d-md-block">
                                    <span>
                                        <img src="<?php echo esc_url( $settings[ 'cta_shape_three' ]['url'] ); ?>" alt="shape1">
                                    </span>
                                </div>
                                <div class="td-subscribe-5-shape-4 tpupdown d-none d-md-block">
                                    <span>
                                        <img src="<?php echo esc_url( $settings[ 'cta_shape_four' ]['url'] ); ?>" alt="shape1">
                                    </span>
                                </div>
                                    <h2 class="td-subscribe-5-title">
                                        <?php echo adina_kses($settings['cta_title']); ?>
                                    </h2>
                                    <p><?php echo esc_html($settings['cta_text']); ?></p>
                                <?php echo do_shortcode($settings['form_shortcode']); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
		<?php
	}
}
$widgets_manager->register( new \Adina_Cta() );