<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Utils;
use \Elementor\Group_Control_Background;
use \Elementor\Repeater;
/**
 *
 * Document List Widget .
 *
 */
class Adina_Document_List extends Widget_Base {

	public function get_name() {
		return 'adina_document_list';
	}

	public function get_title() {
		return __( 'Adina Document List', 'adina' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'adina' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'document_list_section',
			[
				'label' 	=> __( 'Document List', 'adina' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			] 
        );
        $repeater = new Repeater();

        $repeater->add_control(
			'docs_text',
			[
				'label'   => esc_html__( 'Title', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( 'Investments', 'adina' ),
                'label_block' => true,
			]
		);
        $repeater->add_control(
			'doc_link',
			[
				'label' => __( 'URL', 'adina' ),
				'type' => Controls_Manager::URL,
			]
		);
        $repeater->add_control(
			'docs_icon',
			[
				'label'       => __( 'Icon', 'adina' ),
				'type'        => \Elementor\Controls_Manager::ICONS,
				'label_block' => true,
			]
		);
        $this->add_control(
			'list_item',
			[
				'label' => __( 'Item', 'adina' ),
				'type' 		=> Controls_Manager::REPEATER,
				'fields' 	=> $repeater->get_controls(),
			]
		);
		$this->end_controls_section();

        // Box style
        $this->start_controls_section(
            'box_style',
            [
                'label' => __( 'Box', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'box_bg_color',
            [
                'label' => __( 'Background Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-service-widget-pdf ul li' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'box_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-service-widget-pdf ul li:not(:last-child)' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'box_padding',
            [
                'label' => __( 'padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-service-widget-pdf ul li' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

        // title style
        $this->start_controls_section(
            'title_style',
            [
                'label' => __( 'Title', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'title_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-service-widget-pdf ul li a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'selector' => '{{WRAPPER}} .td-service-widget-pdf ul li a',
			]
		);
		$this->end_controls_section();

        // Docs Icon style
        $this->start_controls_section(
            'doc_icon_style',
            [
                'label' => __( 'Docs Icon', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'doc_icon_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-service-widget-pdf ul li a i' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .td-service-widget-pdf ul li a svg path' => 'fill: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
			'doc_icon_size',
			[
				'label' => __( 'Icon Size', 'adina' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 50,
						'step' => 5,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .td-service-widget-pdf ul li a i' => 'font-size: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .td-service-widget-pdf ul li a svg' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
        );
        $this->add_responsive_control(
            'doc_icon_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-service-widget-pdf ul li a i, .td-service-widget-pdf ul li a svg' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

        // Arrow Icon style
        $this->start_controls_section(
            'icon_style',
            [
                'label' => __( 'Icon', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'arrow_icon_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-service-widget-pdf ul li span i' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
			'arrow_icon_size',
			[
				'label' => __( 'Icon Size', 'adina' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 50,
						'step' => 5,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .td-service-widget-pdf ul li span i' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
        );
		$this->end_controls_section();

	}

	protected function render() {
        $settings = $this->get_settings_for_display();

		?>
            <div class="td-service-widget-pdf">
                <ul>
                    <?php foreach( $settings['list_item'] as $list_item ) : ?>
                        <li>
                            <a href="<?php echo esc_url( $list_item[ 'doc_link' ]['url'] ); ?>">
                                <?php \Elementor\Icons_Manager::render_icon( $list_item['docs_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                                <?php echo esc_html( $list_item[ 'docs_text' ]  ); ?> 
                            </a>
                            <span> 
                                <i class="fa-regular fa-arrow-right-long"></i>
                            </span>
                        </li>
                    <?php endforeach; ?>
                </ul>
            </div>
		<?php
	}
}
$widgets_manager->register( new \Adina_Document_List() );