<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Utils;
use \Elementor\Group_Control_Background;
use \Elementor\Repeater;
use \Elementor\Group_Control_Box_Shadow;
/**
 *
 * Experience Widget .
 *
 */
class Adina_Experience extends Widget_Base {

	public function get_name() {
		return 'adina_experience';
	}

	public function get_title() {
		return __( 'Adina Experience', 'adina' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'adina' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'experience_section',
			[
				'label' 	=> __( 'Experience', 'adina' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			] 
        );
		$repeater = new Repeater();

        $repeater->add_control(
            'experience_image',
            [
                'label' => __('Image', 'adina'),
                'type'  => Controls_Manager::MEDIA,
            ]
        );
        $repeater->add_control(
			'category_text',
			[
				'label'   => esc_html__( 'Category', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( 'Business, Finance', 'adina' ),
                'label_block' => true,
			]
		);
        $repeater->add_control(
			'experience_date',
			[
				'label'   => esc_html__( 'Date', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( 'June 21, 2024', 'adina' ),
                'label_block' => true,
			]
		);
        $repeater->add_control(
			'experience_nmbr',
			[
				'label'   => esc_html__( 'Number', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( '01', 'adina' ),
                'label_block' => true,
			]
		);
        $repeater->add_control(
			'experience_title',
			[
				'label'   => esc_html__( 'Title', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( 'Startup investment', 'adina' ),
                'label_block' => true,
			]
		);
        $repeater->add_control(
			'experience_text',
			[
				'label'   => esc_html__( 'Text', 'adina' ),
				'type'    => Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys standard dummy text ever since the 1500s, when an unknow.', 'adina' ),
                'label_block' => true,
			]
		);
        $repeater->add_control(
			'experience_link',
			[
				'label' => __( 'URL', 'adina' ),
				'type' => Controls_Manager::URL,
			]
		);
        $this->add_control(
			'experience_item',
			[
				'label' => __( 'Item', 'adina' ),
				'type' 		=> Controls_Manager::REPEATER,
				'fields' 	=> $repeater->get_controls(),
			]
		);
		$this->end_controls_section();

        // Box style
        $this->start_controls_section(
            'box_style',
            [
                'label' => __( 'Box', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'box_bg_color',
            [
                'label' => __( 'Background Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-expreance-item::before' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'box_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-expreance-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'box_border',
                'selector' => '{{WRAPPER}} .td-expreance-item',
            ]
        ); 
		$this->end_controls_section();

        // Category & Date style
        $this->start_controls_section(
            'category_date_style',
            [
                'label' => __( 'Category & Date', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'category_date_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-expreance-title-pre' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'category_date_typography',
                'selector' => '{{WRAPPER}} .td-expreance-title-pre',
            ]
        );
		$this->end_controls_section();

        // Number style
        $this->start_controls_section(
            'nmbr_style',
            [
                'label' => __( 'Number', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'nmbr_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-expreance-title span' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'nmbr_typography',
                'selector' => '{{WRAPPER}} .td-expreance-title span',
            ]
        );
        $this->add_responsive_control(
            'nmbr_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-expreance-title span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

        // Title style
        $this->start_controls_section(
            'title_style',
            [
                'label' => __( 'Title', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'title_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-expreance-title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'selector' => '{{WRAPPER}} .td-expreance-title',
            ]
        );
		$this->end_controls_section();

        // Text style
        $this->start_controls_section(
            'text_style',
            [
                'label' => __( 'Text', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'text_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-expreance-btn-wrap p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'text_typography',
                'selector' => '{{WRAPPER}} .td-expreance-btn-wrap p',
            ]
        );
        $this->add_responsive_control(
            'text_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-expreance-btn-wrap p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

        // Icon style
        $this->start_controls_section(
            'icon_style',
            [
                'label' => __( 'Icon', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'icon_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-expreance-btn a' => 'color: {{VALUE}}',
                ],
            ]
        );
		$this->end_controls_section();

	}

	protected function render() {
        $settings = $this->get_settings_for_display();

		?>
            <?php foreach( $settings['experience_item'] as $experience_item ) : ?>
                <div class="td-expreance-content-wrap p-relative">
                    <div class="td-expreance-thumb">
                        <img class="w-100" src="<?php echo esc_url($experience_item['experience_image']['url']); ?>" alt="thumb">
                    </div>
                    <div class="td-expreance-item">
                        <div class="row">
                            <div class="col-lg-6 mb-30">
                            <div class="td-expreance-content">
                                <p class="td-expreance-title-pre">
                                    <?php echo esc_html( $experience_item[ 'category_text' ]  ); ?> 
                                    <span><?php echo esc_html__( '/', 'adina' ); ?></span> 
                                    <?php echo esc_html( $experience_item[ 'experience_date' ]  ); ?> 
                                </p>
                                <h3 class="td-expreance-title">
                                    <span>
                                        <?php echo esc_html( $experience_item[ 'experience_nmbr' ]  ); ?> 
                                    </span>
                                    <?php echo esc_html( $experience_item[ 'experience_title' ]  ); ?> 
                                </h3>
                            </div>
                            </div>
                            <div class="col-lg-6 mb-30">
                            <div class="td-expreance-btn-wrap">
                                <p><?php echo esc_html( $experience_item[ 'experience_text' ]  ); ?> </p>
                                <div class="td-expreance-btn">
                                    <a href="<?php echo esc_url($experience_item['experience_link']['url']); ?>">
                                        <svg width="50" height="50" viewBox="0 0 50 50" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M25 50C38.8235 50 50 38.8235 50 25C50 11.1765 38.8235 0 25 0C11.1765 0 0 11.1765 0 25C0 38.8235 11.1765 50 25 50ZM25 2.94118C37.2059 2.94118 47.0588 12.7941 47.0588 25C47.0588 37.2059 37.2059 47.0588 25 47.0588C12.7941 47.0588 2.94118 37.2059 2.94118 25C2.94118 12.7941 12.7941 2.94118 25 2.94118Z" fill="currentColor" />
                                            <path d="M24.5585 39.2638L38.8232 24.9991L24.5585 10.7344L22.4997 12.7932L34.7056 24.9991L22.4997 37.205L24.5585 39.2638Z" fill="currentColor" />
                                            <path d="M36.7646 23.5293H11.7646V26.4705H36.7646V23.5293Z" fill="currentColor" />
                                        </svg>
                                    </a>
                                </div>
                            </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
		<?php
	}
}
$widgets_manager->register( new \Adina_Experience() );