<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Repeater;
use \Elementor\Utils;
/**
 *
 * Button Widget .
 *
 */
class Adina_Header extends Widget_Base {

	public function get_name() {
		return 'adina_header';
	}

	public function get_title() {
		return __( 'Adina Header', 'adina' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'adina' ];
	}

    private function get_available_menus() {

        $menus = wp_get_nav_menus();

        $options = [];

        foreach ( $menus as $menu ) {

            $options[$menu->slug] = $menu->name;

        }

        return $options;

    }

	protected function register_controls() {

        // layout
        $this->start_controls_section('layout_section',
            [
                'label' => __('Layout', 'adina'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'header_layout',
            [
                'label' => esc_html__('Select Layout', 'adina'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'layout-1' => esc_html__('Layout 1', 'adina'),
                    'layout-2' => esc_html__('Layout 2', 'adina'),
                    'layout-3' => esc_html__('Layout 3', 'adina'),
                    'layout-4' => esc_html__('Layout 4', 'adina'),
                    'layout-5' => esc_html__('Layout 5', 'adina'),
                ],
                'default' => 'layout-1',
            ]
        );
        $this->end_controls_section();

        // Header Top Menu
        $this->start_controls_section('header_top_menu_section',
            [
                'label' => __('Header Top Menu', 'adina'),
                'tab'   => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'header_layout' => ['layout-1', 'layout-4']
                ]
            ]
        );
		$repeater = new Repeater();

        $repeater->add_control(
			'top_menu_text',
			[
				'label'   => esc_html__( 'Top Menu Text', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( 'About', 'adina' ),
			]
		);
        $repeater->add_control(
			'top_menu_link',
			[
				'label' => __( 'List URL', 'adina' ),
				'type' => Controls_Manager::URL,
			]
		);
        $this->add_control(
			'top_menu_list',
			[
				'label' => __( 'Menu List', 'adina' ),
				'type' 		=> Controls_Manager::REPEATER,
				'fields' 	=> $repeater->get_controls(),
			]
		);
        $this->end_controls_section();

        // Header Top Social
        $this->start_controls_section('header_top_social_section',
            [
                'label' => __('Header Top Social', 'adina'),
                'tab'   => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'header_layout' => 'layout-2',
                ]
            ]
        );
        $this->add_control(
			'top_mail_text',
			[
				'label'   => esc_html__( 'Mail Text', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( 'info@adina.com', 'adina' ),
                'label_block' => true,
			]
		);
        $this->add_control(
			'top_mail_link',
			[
				'label' => __( 'Mail URL', 'adina' ),
				'type' => Controls_Manager::URL,
			]
		);
        $this->add_control(
			'top_phone_text',
			[
				'label'   => esc_html__( 'Phone Text', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( '+(123) 456 789 00', 'adina' ),
                'label_block' => true,
			]
		);
        $this->add_control(
			'top_phone_link',
			[
				'label' => __( 'Phone URL', 'adina' ),
				'type' => Controls_Manager::URL,
			]
		);
        $this->end_controls_section();

        // Header Iconbox
        $this->start_controls_section('header_iconbox_section',
            [
                'label' => __('Header Iconbox', 'adina'),
                'tab'   => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'header_layout' => 'layout-5',
                ]
            ]
        );
        $this->add_control(
			'iconbox_mail_title',
			[
				'label'   => esc_html__( 'Mail Title', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( 'Drop us a line', 'adina' ),
                'label_block' => true,
			]
		);
        $this->add_control(
			'iconbox_mail_text',
			[
				'label'   => esc_html__( 'Mail Text', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( 'info@adina.com', 'adina' ),
                'label_block' => true,
			]
		);
        $this->add_control(
			'iconbox_mail_link',
			[
				'label' => __( 'Mail URL', 'adina' ),
				'type' => Controls_Manager::URL,
			]
		);
        $this->add_control(
			'iconbox_phone_title',
			[
				'label'   => esc_html__( 'Phone Title', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( 'Make a call', 'adina' ),
                'label_block' => true,
			]
		);
        $this->add_control(
			'iconbox_phone_text',
			[
				'label'   => esc_html__( 'Phone Text', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( '+(123) 456 789 00', 'adina' ),
                'label_block' => true,
			]
		);
        $this->add_control(
			'iconbox_phone_link',
			[
				'label' => __( 'Phone URL', 'adina' ),
				'type' => Controls_Manager::URL,
			]
		);
        $this->end_controls_section();

        // Header Top Text
        $this->start_controls_section('header_top_text_section',
            [
                'label' => __('Header Top Text', 'adina'),
                'tab'   => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'header_layout' => ['layout-2', 'layout-3']
                ]
            ]
        );
        $this->add_control(
			'top_text_one',
			[
				'label'   => esc_html__( 'Text One', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( 'Adina - for All ', 'adina' ),
                'label_block' => true,
			]
		);
        $this->add_control(
			'top_link_text',
			[
				'label'   => esc_html__( 'Link Text', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( ' your business', 'adina' ),
                'label_block' => true,
			]
		);
        $this->add_control(
			'top_link_text_url',
			[
				'label' => __( 'Text Link', 'adina' ),
				'type' => Controls_Manager::URL,
			]
		);
        $this->add_control(
			'top_text_two',
			[
				'label'   => esc_html__( 'Text Two', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( ' endeavors', 'adina' ),
                'label_block' => true,
			]
		);
        $this->end_controls_section();

        // Time Text
        $this->start_controls_section('time_text_section',
            [
                'label' => __('Time', 'adina'),
                'tab'   => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'header_layout' => ['layout-1', 'layout-2', 'layout-4']
                ]
            ]
        );
        $this->add_control(
			'time_text',
			[
				'label'   => esc_html__( 'Time Text', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( '10:00am - 06:00pm', 'adina' ),
                'label_block' => true,
			]
		);
        $this->end_controls_section();

        // Logo
        $this->start_controls_section('logo_section',
            [
                'label' => __('Logo', 'adina'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
			'logo_type',
			[
				'label' => __( 'Logo Type', 'adina' ),
				'type'  => Controls_Manager::SELECT,
				'default' => 'dark',
				'options' => [
					'dark'   => __( 'Dark', 'adina' ),
					'white'  => __( 'White', 'adina' ),
					'custom' => __( 'Custom', 'adina' ),
				],
			]
        );
        $this->add_control(
            'image',
            [
                'label' => __('Choose logo', 'adina'),
                'type'  => Controls_Manager::MEDIA,
                'default' => [
                    'url' => '',
                ],
                'condition' => [
                    'logo_type' => 'custom',
                ]
            ]
        );
        $this->end_controls_section();

        // Header Top Button
        $this->start_controls_section('header_top_btn_section',
            [
                'label' => __('Header Top Button', 'adina'),
                'tab'   => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'header_layout' => ['layout-2', 'layout-4']
                ]
            ]
        );
        $this->add_control(
			'top_btn_text',
			[
				'label'   => esc_html__( 'Button Text', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( 'We are hearing!', 'adina' ),
                'label_block' => true,
			]
		);
        $this->add_control(
			'top_btn_url',
			[
				'label' => __( 'Button Url', 'adina' ),
				'type' => Controls_Manager::URL,
			]
		);
        $this->end_controls_section();

        // Menu
        $this->start_controls_section('menu_section',
            [
                'label' => __('Menu', 'adina'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'use_main_menu',
            [
                'label'        => __( 'Use Main Menu', 'adina' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'Yes', 'adina' ),
                'label_off'    => __( 'No', 'adina' ),
                'return_value' => 'yes',
                'default'      => 'yes',
            ]
        );
        $menus = $this->get_available_menus();

        if ( !empty( $menus ) ) {
            $this->add_control(
                'primary_menu',
                [
                    'label'        => __( 'Menu', 'header-footer-elementor' ),
                    'type'         => Controls_Manager::SELECT,
                    'options'      => $menus,
                    'default'      => array_keys( $menus )[0],
                    'save_default' => true,
                    'separator'    => 'after',
                    'description'  => sprintf( __( 'Go to the <a href="%s" target="_blank">Menus screen</a> to manage your menus.', 'header-footer-elementor' ), admin_url( 'nav-menus.php' ) ),
                    'condition'    => [
                        'use_main_menu!' => 'yes',
                    ],
                ]
            );
        } else {
            $this->add_control(
                'menu',
                [
                    'type'            => Controls_Manager::RAW_HTML,
                    'raw'             => sprintf( __( '<strong>There are no menus in your site.</strong><br>Go to the <a href="%s" target="_blank">Menus screen</a> to create one.', 'header-footer-elementor' ), admin_url( 'nav-menus.php?action=edit&menu=0' ) ),
                    'separator'       => 'after',
                    'content_classes' => 'elementor-panel-alert elementor-panel-alert-info',
                ]
            );
        }
        $this->end_controls_section();

        // Header Mail
        $this->start_controls_section('header_mail_section',
            [
                'label' => __('Header Mail', 'adina'),
                'tab'   => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'header_layout' => 'layout-4',
                ]
            ]
        );
        $this->add_control(
			'header_mail_text',
			[
				'label'   => esc_html__( 'Mail Text', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( 'info@adina.com', 'adina' ),
                'label_block' => true,
			]
		);
        $this->add_control(
			'header_mail_link',
			[
				'label' => __( 'Mail URL', 'adina' ),
				'type' => Controls_Manager::URL,
			]
		);
        $this->end_controls_section();

        // Header Default Button
        $this->start_controls_section('header_default_btn_section',
            [
                'label' => __('Default Button', 'adina'),
                'tab'   => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'header_layout!' => 'layout-1',
                ]
            ]
        );
        $this->add_control(
			'default_btn_text',
			[
				'label'   => esc_html__( 'Button Text', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( 'Let’s Talk', 'adina' ),
                'label_block' => true,
			]
		);
        $this->add_control(
			'default_btn_url',
			[
				'label' => __( 'Button Url', 'adina' ),
				'type' => Controls_Manager::URL,
			]
		);
        $this->end_controls_section();

        // Mobile Menu
        $this->start_controls_section('mobile_menu_section',
            [
                'label' => __('Mobile Menu', 'adina'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'mobile_menu_logo',
            [
                'label' => esc_html__( 'Mobile Logo', 'adina' ),
                'type' =>  Controls_Manager::MEDIA,
                'default' => [
                    'url' =>  Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->end_controls_section();

        // Mobile Social Icons
        $this->start_controls_section('mobile_social_section',
            [
                'label' => __('Mobile Social Icons', 'adina'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
		$icon_repeater = new Repeater();

        $icon_repeater->add_control(
            'social_icon_select',
            [
                'label' => __('Icon select', 'construz'),
                'type' => Controls_Manager::SELECT2,
                'options' => adina_icon_list_options(),
                'default' => 'linkedin-fill',
                'label_block' => true,

            ]
        );
        $icon_repeater->add_control(
            'icon_url',
            [
                'label' => esc_html__( 'Icon Url', 'adina' ),
                'type' => Controls_Manager::URL,
                'default' => [
                    'url' => '#',
                ],
                'label_block' => true,
            ]
        ); 
        $this->add_control(
			'mobile_menu_social_list',
			[
				'label' => __( 'Social Icon', 'adina' ),
				'type' 		=> Controls_Manager::REPEATER,
				'fields' 	=> $icon_repeater->get_controls(),
			]
		);
        $this->end_controls_section();

        // Header offcanvas
        $this->start_controls_section('header_offcanvas_section',
            [
                'label' => __('Offcanvas', 'adina'),
                'tab'   => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'header_layout' => 'layout-5',
                ]
            ]
        );
        $this->add_control(
			'offcanvas_title',
			[
				'label'       => esc_html__( 'Offcanvas Title', 'adina' ),
				'type'        => Controls_Manager::TEXT,
				'default'     => esc_html__( 'Hello There!', 'adina' ),
                'label_block' => true,
			]
		);
        $this->add_control(
			'offcanvas_text',
			[
				'label'       => esc_html__( 'Offcanvas Text', 'adina' ),
				'type'        => Controls_Manager::TEXT,
				'default'     => esc_html__( 'Business management for all future successful projects, The new way to keep track of all the projects, Day to day work made our life simple and easy', 'adina' ),
                'label_block' => true,
			]
		);
		$img_repeater = new Repeater();

        $img_repeater->add_control(
            'offcanvas_img',
            [
                'label'   => esc_html__( 'Offcanvas Image', 'adina' ),
                'type'    =>  Controls_Manager::MEDIA,
                'default' => [
                    'url' =>  Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
			'offcanvas_img_list',
			[
				'label'     => __( 'Image List', 'adina' ),
				'type' 		=> Controls_Manager::REPEATER,
				'fields' 	=> $img_repeater->get_controls(),
			]
		);
        $this->end_controls_section();

        // Start Style Controls
        // Header Top Menu style
        $this->start_controls_section(
            'header_top_menu_style',
            [
                'label' => __( 'Header Top Menu', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'header_layout' => ['layout-1', 'layout-4']
                ]
            ]
        );
        $this->add_control(
            'header_top_menu_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-header-top-menu ul li a' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .td-header-4-top-menu ul li a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'header_top_menu_typography',
                'selector' => '{{WRAPPER}} .td-header-top-menu ul li a, {{WRAPPER}} .td-header-4-top-menu ul li a',
            ]
        );               
        $this->add_responsive_control(
            'header_top_menu_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-header-top-menu ul li a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .td-header-4-top-menu ul li a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        // Header Top Social style
        $this->start_controls_section(
            'header_top_social_style',
            [
                'label' => __( 'Header Top Social', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'header_layout' => 'layout-2',
                ]
            ]
        );
        $this->add_control(
            'header_top_social_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-header-top-social ul li a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'header_top_social_typography',
				'selector' => '{{WRAPPER}} .td-header-top-social ul li a',
			]
		);
        $this->end_controls_section();

        // Header Logo style
        $this->start_controls_section(
            'header_logo_style',
            [
                'label' => __( 'Logo', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
            'header_logo_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-header-logo a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        // Header Iconbox style
        $this->start_controls_section(
            'header_iconbox_style',
            [
                'label' => __( 'Header Iconbox', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'header_layout' => 'layout-5',
                ]
            ]
        );
        $this->add_control(
            'header_iconbox_text_color',
            [
                'label' => __( 'Text Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-header-5-info-wrap ul li a p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'header_iconbox_text_typography',
				'selector' => '{{WRAPPER}} .td-header-5-info-wrap ul li a p',
			]
		);
        $this->add_responsive_control(
            'header_iconbox_text_margin',
            [
                'label' => __( 'Text Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-header-5-info-wrap ul li a p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'header_iconbox_title_color',
            [
                'label' => __( 'Title Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-header-5-info-wrap ul li a span' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'header_iconbox_title_typography',
				'selector' => '{{WRAPPER}} .td-header-5-info-wrap ul li a span',
			]
		);
        $this->end_controls_section();

        // Header Top Text style
        $this->start_controls_section(
            'header_top_text_style',
            [
                'label' => __( 'Header Top Text', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'header_layout' => ['layout-2', 'layout-3']
                ]
            ]
        );
        $this->add_control(
            'header_top_text_color',
            [
                'label' => __( 'Text Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-header-endeavos p' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .td-header-3-content p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'header_top_text_typography',
                'selector' => '{{WRAPPER}} .td-header-endeavos p, {{WRAPPER}} .td-header-3-content p',
            ]
        );               
        $this->add_control(
            'header_top_link_text_color',
            [
                'label' => __( 'Text Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-header-endeavos p a' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .td-header-3-content p a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'header_top_link_text_typography',
                'selector' => '{{WRAPPER}} .td-header-endeavos p a, {{WRAPPER}} .td-header-3-content p a',
            ]
        );            
        $this->end_controls_section();

        // Header Time style
        $this->start_controls_section(
            'header_time_style',
            [
                'label' => __( 'Header Time', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'header_layout' => ['layout-1', 'layout-2', 'layout-4']
                ]
            ]
        );
        $this->add_control(
            'header_time_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-header-time' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'header_time_typography',
				'selector' => '{{WRAPPER}} .td-header-time',
			]
		);
        $this->end_controls_section();

        // Header Top Button style
        $this->start_controls_section(
            'header_top_btn_style',
            [
                'label' => __( 'Header Top Button', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'header_layout' => ['layout-2', 'layout-4']
                ]
            ]
        );
        $this->add_control(
            'header_top_btn_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-btn-4' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .td-header-4-btn .td-btn-4' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'header_top_btn_bg_color',
            [
                'label' => __( 'Background Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-btn-4' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .td-header-4-btn .td-btn-4' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'header_top_btn_typography',
                'selector' => '{{WRAPPER}} .td-btn-4, {{WRAPPER}} .td-header-4-btn .td-btn-4',
            ]
        );           
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'header_top_btn_border',
                'selector' => '{{WRAPPER}} .td-btn-4, {{WRAPPER}} .td-header-4-btn .td-btn-4',
            ]
        );              
        $this->add_responsive_control(
			'header_top_btn_radius',
			[
				'label'         => __( 'Border Radius', 'adina' ),
				'type'          => Controls_Manager::DIMENSIONS,
				'size_units'    => [ 'px', '%', 'em' ],
				'selectors'     => [
					'{{WRAPPER}} .td-btn-4' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .td-header-4-btn .td-btn-4' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );
        $this->add_responsive_control(
            'header_top_btn_padding',
            [
                'label' => __( 'Image Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-btn-4' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .td-header-4-btn .td-btn-4' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        // Header Mail style
        $this->start_controls_section(
            'header_mail_style',
            [
                'label' => __( 'Header Mail', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'header_layout' => 'layout-4',
                ]
            ]
        );
        $this->add_control(
            'header_mail_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-header-4-email a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'header_mail_typography',
				'selector' => '{{WRAPPER}} .td-header-4-email a',
			]
		);
        $this->end_controls_section();

        // Header Default Button style
        $this->start_controls_section(
            'header_default_btn_style',
            [
                'label' => __( 'Header Default Button', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'header_layout!' => 'layout-1',
                ]
            ]
        );
        $this->add_control(
            'header_default_btn_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-btn' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .td-btn-7' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .td-header-5-btn .td-btn' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .td-btn-3' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .td-btn-5' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'header_default_btn_bg_color',
            [
                'label' => __( 'Background Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-btn' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .td-btn-7' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .td-header-5-btn .td-btn' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .td-btn-3' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .td-btn-5' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'header_default_btn_typography',
                'selector' => '{{WRAPPER}} .td-btn, {{WRAPPER}} .td-btn-7, {{WRAPPER}} .td-header-5-btn .td-btn, {{WRAPPER}} .td-btn-3, {{WRAPPER}} .td-btn-5',
            ]
        );             
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'header_default_btn_border',
                'selector' => '{{WRAPPER}} .td-btn, {{WRAPPER}} .td-btn-7, {{WRAPPER}} .td-header-5-btn .td-btn, {{WRAPPER}} .td-btn-3, {{WRAPPER}} .td-btn-5',
            ]
        );             
        $this->add_responsive_control(
			'header_default_btn_radius',
			[
				'label'         => __( 'Border Radius', 'adina' ),
				'type'          => Controls_Manager::DIMENSIONS,
				'size_units'    => [ 'px', '%', 'em' ],
				'selectors'     => [
					'{{WRAPPER}} .td-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .td-btn-7' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .td-header-5-btn .td-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .td-btn-3' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .td-btn-5' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );
        $this->add_responsive_control(
            'header_default_btn_padding',
            [
                'label' => __( 'Image Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .td-btn-7' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .td-header-5-btn .td-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .td-btn-3' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .td-btn-5' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        // Header Offcanvas style
        $this->start_controls_section(
            'header_offcanvas_style',
            [
                'label' => __( 'Header Offcanvas', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'header_layout' => 'layout-5',
                ]
            ]
        );
        $this->add_control(
            'header_offcanvas_title_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tp-offcanvas-title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'header_offcanvas_title_typography',
				'selector' => '{{WRAPPER}} .tp-offcanvas-title',
			]
		);
        $this->add_responsive_control(
            'header_offcanvas_title_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .tp-offcanvas-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'header_offcanvas_text_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-offcanvas-content p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'header_offcanvas_text_typography',
				'selector' => '{{WRAPPER}} .td-offcanvas-content p',
			]
		);
        $this->end_controls_section();

        // Header Box style
        $this->start_controls_section(
            'header_box_style',
            [
                'label' => __( 'Header Box', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'header_top_box_bg_color',
            [
                'label' => __( 'Background Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .border-bottom' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .td-black-bg-2' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'header_top_box_border',
                'selector' => '{{WRAPPER}} .border-bottom, {{WRAPPER}} .td-black-bg-2',
            ]
        );               
        $this->add_control(
            'header_fullbox_bg_color',
            [
                'label' => __( 'Background Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .border-bottom-2' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .td-header-2-bottom' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .td-header-bottom' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .td-black-bg' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'header_fullbox_border',
                'selector' => '{{WRAPPER}} .border-bottom-2, {{WRAPPER}} .td-header-bottom, {{WRAPPER}} .td-header-2-bottom, {{WRAPPER}} .td-black-bg, {{WRAPPER}} .td-header-5-bg',
            ]
        );                
        $this->end_controls_section();

        // Header Menu style
        $this->start_controls_section(
            'header_menu_style',
            [
                'label' => __( 'Header Menu', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'header_menu_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-main-menu nav ul li a' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .td-main-menu-2 nav ul li a' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .td-main-menu-3 nav ul li a' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .td-main-menu-4 nav ul li a' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .td-main-menu-5 nav ul li a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'header_menu_typography',
                'selector' => '{{WRAPPER}} .td-main-menu nav ul li a, {{WRAPPER}} .td-main-menu-2 nav ul li a, {{WRAPPER}} .td-main-menu-3 nav ul li a, {{WRAPPER}} .td-main-menu-4 nav ul li a, {{WRAPPER}} .td-main-menu-5 nav ul li a',
            ]
        );           
        $this->add_control(
            'header_trigger_color',
            [
                'label' => __( 'Trigger Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-header-bar button span' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .td-header-bar-white button span' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_section();

        // Header Submenu style
        $this->start_controls_section(
            'header_submenu_style',
            [
                'label' => __( 'Header Submenu', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'header_submenu_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-main-menu nav ul .submenu li a' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .td-main-menu-2 nav ul .submenu li a' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .td-main-menu-3 nav ul .submenu li a' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .td-main-menu-4 nav ul .submenu li a' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .td-main-menu-5 nav ul .submenu li a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'header_submenu_typography',
                'selector' => '{{WRAPPER}} .td-main-menu nav ul .submenu li a, {{WRAPPER}} .td-main-menu-2 nav ul .submenu li a, {{WRAPPER}} .td-main-menu-3 nav ul .submenu li a, {{WRAPPER}} .td-main-menu-4 nav ul .submenu li a, {{WRAPPER}} .td-main-menu-5 nav ul .submenu li a',
            ]
        );              
        $this->end_controls_section();

        // Header Mobile Menu style
        $this->start_controls_section(
            'header_mobile_menu_style',
            [
                'label' => __( 'Mobile Menu', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'header_mobile_menu_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-main-menu-mobile ul li > a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'header_mobile_menu_typography',
				'selector' => '{{WRAPPER}} .td-main-menu-mobile ul li > a',
			]
		);
        $this->end_controls_section();

        // Header Mobile Logo style
        $this->start_controls_section(
            'header_mobile_logo_style',
            [
                'label' => __( 'Mobile Logo', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
			'mobile_logo_width',
			[
				'label' => esc_html__( 'Width', 'adina' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .tdoffcanvas__logo img' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);
        $this->add_responsive_control(
            'mobile_logo_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .tdoffcanvas__logo' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();


    }

    // adina get logo  
    public function adina_get_site_logo( $logo_type = 'dark'  ) {
        $logo = '';
        $adina = get_option('adina_opt');
        $logo_url = '';
        if ( 'dark' ==  $logo_type && isset( $adina['logo']['url'] ) ) {
            $logo_url = esc_url($adina['logo']['url']);
            $logo = '<img src="' . esc_url($logo_url) . '" alt="' . esc_attr(get_bloginfo('title')) . '" class="dark-logo">';

        } else if ( 'white' ==  $logo_type && isset($adina['white_logo']['url'])) {
            $logo_url = esc_url($adina['white_logo']['url']);
            $logo = '<img src="' . esc_url($logo_url) . '" alt="' . esc_attr(get_bloginfo('title')) . '" class="white-logo">';
        } else {
            if ( has_custom_logo() ) {
                $core_logo_id = get_theme_mod('custom_logo');
                $logo_url = wp_get_attachment_image_src($core_logo_id, 'full');
                $logo = '<img src="' . esc_url($logo_url[0]) . '" alt="' . esc_attr(get_bloginfo('title')) . '">';
            } else {

                $logo = '<h2 class="navbar-brand__regular">' . get_bloginfo('name') . '</h2>';

            }
        }
        return $logo;
    }

    // Render
	protected function render() {

        $settings = $this->get_settings_for_display();
        $layout = $settings['header_layout'];

        if ( 'yes' == $settings['use_main_menu'] ) {
            $args = [
                'theme_location'  => 'primary-menu',
                'container'      => false, 
                'menu_id'        => false, 
                'menu_class'     => false, 
            ];
        } else {
            $args = [
                // 'theme_location'        => 'main-menu',
                'menu'            => $settings['primary_menu'],
                'container'      => false, 
                'menu_id'        => false, 
                'menu_class'     => false, 
            ];
        }

        ?>
            <?php
                if ( $layout) {
                    include('header/'.$layout.'.php');
                }
            ?> 
    
        <?php
    
    }
    

}
$widgets_manager->register( new \Adina_Header() );