<!-- header-area-start -->
<div class="td-header-area">
    <div class="td-header-top d-none d-md-block">
        <div class="container container-1750">
            <div class="row">
                <div class="col-12">
                    <div class="border-bottom">
                        <div class="row align-items-center">
                            <div class="col-lg-6 col-md-6">
                                <div class="td-header-top-left">
                                <div class="td-header-top-menu">
                                    <ul>
                                        <?php foreach( $settings['top_menu_list'] as $menu_list ) : ?>
                                            <li>
                                                <a href="<?php echo esc_url($menu_list['top_menu_link']['url']); ?>">
                                                    <?php echo esc_html( $menu_list[ 'top_menu_text' ]  ); ?>
                                                </a>
                                            </li>
                                        <?php endforeach; ?>
                                    </ul>
                                </div>
                                </div>
                            </div>
                            <div class="col-lg-6 col-md-6">
                                <div class="td-header-right d-flex align-items-center justify-content-end">
                                    <div class="td-header-lang p-relative">
                                        <span class="td-header-lang-toggle" id="td-header-lang-toggle"><i class="fa-light fa-globe"></i> English</span>
                                        <ul class="td-header-lang-list td-lang-list">
                                            <li>Spanish</li>
                                            <li>English</li>
                                            <li>Canada</li>
                                        </ul>
                                    </div>
                                    <div class="td-header-time td-header-right-border">
                                        <span>
                                            <i class="fa-sharp fa-light fa-clock"></i>
                                            <?php echo esc_html( $settings[ 'time_text' ]  ); ?>
                                        </span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="td-header-bottom" id="header-sticky">
        <div class="container container-1750">
            <div class="row">
                <div class="col-12">
                    <div class="border-bottom-2 td-header-mobile-space">
                        <div class="row align-items-center">
                            <div class="col-xxl-4 col-xl-4 col-lg-3">
                                <div class="td-header-search d-none d-lg-block">
                                    <form action="<?php echo esc_url( home_url( '/' ) ); ?>"  method="get">
                                        <div class="td-header-input p-relative">
                                            <input type="email" name="s" placeholder="<?php echo esc_attr__( 'Search here...', 'adina' ); ?>">
                                            <button class="td-header-search-btn" type="button">
                                                <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                    <path d="M8.1172 0C12.593 0 16.2344 3.64136 16.2344 8.11718C16.2344 10.1445 15.4873 12.0007 14.254 13.4247L19.8284 18.9997C20.0572 19.2286 20.0572 19.5996 19.8284 19.8284C19.5995 20.0572 19.2286 20.0572 18.9997 19.8284L13.4254 14.2534C12.0012 15.4871 10.1448 16.2344 8.1172 16.2344C3.64139 16.2344 2.28882e-05 12.593 2.28882e-05 8.11718C2.28882e-05 3.64136 3.64139 0 8.1172 0ZM8.1172 15.0625C11.9469 15.0625 15.0625 11.9468 15.0625 8.11718C15.0625 4.28753 11.9468 1.17187 8.1172 1.17187C4.28756 1.17187 1.1719 4.28753 1.1719 8.11718C1.1719 11.9468 4.28756 15.0625 8.1172 15.0625Z" fill="currentColor" />
                                                </svg>
                                            </button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                            <div class="col-xxl-3 col-xl-2 col-lg-2 col-7">
                                <div class="td-header-logo text-end  mr-90">
                                    <a href="<?php echo esc_url( home_url('/') ); ?>">
                                        <?php
                                            if ( 'custom' == $settings['logo_type'] && $settings['image']['url']) {
                                                echo Group_Control_Image_Size::get_attachment_image_html($settings, 'thumbnail', 'image');
                                            } else {
                                                echo $this->adina_get_site_logo( $settings['logo_type'] );
                                            }
                                        ?>
                                    </a>
                                </div>
                            </div>
                            <div class="col-xxl-5 col-xl-6 col-lg-7 col-5">
                                <div class="td-main-menu td-main-menu-01 d-none d-lg-block">
                                    <nav class="td-main-menu-content">
                                        <?php wp_nav_menu( $args );?>
                                    </nav>
                                </div>
                                <div class="td-header-bar d-block d-lg-none text-right">
                                    <button class="td-offcanvas-open-btn td-menu-bar">
                                        <span></span>
                                        <span></span>
                                        <span></span>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- header-area-end -->

<!-- td-offcanvus-area-start -->
<div class="tdoffcanvas-area">
    <div class="tdoffcanvas">
        <div class="tdoffcanvas__close-btn">
            <button class="close-btn"><i class="fal fa-times"></i></button>
        </div>
        <div class="tdoffcanvas__logo">
            <a href="<?php echo esc_url( home_url('/') ); ?>">
                <img src="<?php echo esc_url( $settings[ 'mobile_menu_logo' ]['url'] ); ?>" alt="logo">
            </a>
        </div>
        <div class="td-main-menu-mobile d-lg-none"></div>
        <div class="tdoffcanvas__contact-info">
            <div class="tdoffcanvas__contact-title">
                <h5><?php echo esc_html__( 'Contact us', 'adina' ); ?></h5>
            </div>
        </div>
        <div class="tdoffcanvas__social">
            <div class="social-icon">
                <?php foreach( $settings['mobile_menu_social_list'] as $social_icon ) : ?>
                    <?php if ( !empty( $social_icon['social_icon_select'] ) ) : ?>
                        <a href="<?php echo esc_url( $social_icon[ 'icon_url' ]['url'] ); ?>">
                            <i class="fab fa-<?php echo esc_html( $social_icon[ 'social_icon_select' ] ); ?>"></i>
                        </a>
                    <?php endif; ?>
                <?php endforeach; ?>
            </div>
        </div>
    </div>
</div>
<div class="body-overlay"></div>
<!-- td-offcanvus-area-end -->