<!-- header-area-start -->
<div class="td-header-area">
    <div class="td-header-top td-black-bg-2 d-none d-md-block">
        <div class="container-fluid container-1750">
            <div class="row align-items-center">
                <div class="col-lg-6 col-md-6">
                    <div class="td-header-top-left">
                        <div class="td-header-top-menu td-header-4-top-menu">
                            <ul>
                                <?php foreach( $settings['top_menu_list'] as $menu_list ) : ?>
                                    <li>
                                        <a href="<?php echo esc_url($menu_list['top_menu_link']['url']); ?>">
                                            <?php echo esc_html( $menu_list[ 'top_menu_text' ]  ); ?>
                                        </a>
                                    </li>
                                <?php endforeach; ?>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6 col-md-6">
                    <div class="td-header-right d-flex align-items-center justify-content-end">
                        <div class="td-header-lang td-header-4-lang p-relative">
                            <span class="td-header-lang-toggle" id="td-header-lang-toggle"><i class="fa-light fa-globe"></i> Schedule</span>
                            <ul class="td-header-lang-list td-lang-list">
                                <li>Spanish</li>
                                <li>English</li>
                                <li>Canada</li>
                            </ul>
                        </div>
                        <div class="td-header-time td-header-4-time td-header-right-border">
                            <span>
                                <i class="fa-sharp fa-light fa-clock"></i> 
                                <?php echo esc_html( $settings[ 'time_text' ]  ); ?>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="td-header-bottom td-black-bg td-header-sticky-black" id="header-sticky">
        <div class="container-fluid container-1750">
            <div class="row">
                <div class="col-12">
                    <div class="td-header-mobile-space">
                        <div class="row align-items-center">
                            <div class="col-xl-3 col-lg-2 col-6">
                                <div class="td-header-logo d-flex align-items-center">
                                    <a href="<?php echo esc_url( home_url('/') ); ?>">
                                        <?php
                                            if ( 'custom' == $settings['logo_type'] && $settings['image']['url']) {
                                                echo Group_Control_Image_Size::get_attachment_image_html($settings, 'thumbnail', 'image');
                                            } else {
                                                echo $this->adina_get_site_logo( $settings['logo_type'] );
                                            }
                                        ?>
                                    </a>
                                    <div class="td-header-btn td-header-4-btn d-none d-xl-block">
                                        <a class="td-btn-4" href="<?php echo esc_url($settings['top_btn_url']['url']); ?>">
                                            <?php echo esc_html( $settings[ 'top_btn_text' ]  ); ?>
                                        </a>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-5 col-lg-6 d-none d-lg-block">
                                <div class="td-main-menu td-main-menu-2 td-main-menu-4 d-none d-lg-block">
                                    <nav class="td-main-menu-content">
                                        <?php wp_nav_menu( $args );?>
                                    </nav>
                                </div>
                            </div>
                            <div class="col-xl-4 col-lg-4 col-6">
                                <div class="td-header-right d-flex align-items-center justify-content-end">
                                    <div class="td-header-4-email d-none d-xl-block">
                                        <a href="<?php echo esc_url($settings['header_mail_link']['url']); ?>">
                                            <i class="fa-regular fa-envelope-open"></i> 
                                            <?php echo esc_html( $settings[ 'header_mail_text' ]  ); ?>
                                        </a>
                                    </div>
                                    <div class="td-header-right-2-btn ml-30 d-none d-lg-block">
                                        <a class="td-btn td-btn-7 td-left-right" href="contact.html">Let’s Talk
                                            <span class="td-arrow-angle ml-10"> 
                                                <svg class="td-arrow-svg-top-right" xmlns="http://www.w3.org/2000/svg" width="10" height="10" viewBox="0 0 10.00 10.00">
                                                <path d="M1.018 10.009 0 8.991l7.569-7.582H1.723L1.737 0h8.26v8.274H8.574l.013-5.847Z" />
                                                <path d="M1.018 10.009 0 8.991l7.569-7.582H1.723L1.737 0h8.26v8.274H8.574l.013-5.847Z" />
                                                </svg> 
                                            </span>
                                        </a>
                                    </div>
                                </div>
                                <div class="td-header-bar td-header-bar-white d-block d-lg-none text-right">
                                    <button class="td-offcanvas-open-btn td-menu-bar">
                                        <span></span>
                                        <span></span>
                                        <span></span>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- header-area-end -->



<!-- td-offcanvus-area-start -->
<div class="tdoffcanvas-area">
    <div class="tdoffcanvas">
        <div class="tdoffcanvas__close-btn">
            <button class="close-btn"><i class="fal fa-times"></i></button>
        </div>
        <div class="tdoffcanvas__logo">
            <a href="<?php echo esc_url( home_url('/') ); ?>">
                <img src="<?php echo esc_url( $settings[ 'mobile_menu_logo' ]['url'] ); ?>" alt="logo">
            </a>
        </div>
        <div class="td-main-menu-mobile d-lg-none"></div>
        <div class="tdoffcanvas__contact-info">
            <div class="tdoffcanvas__contact-title">
                <h5><?php echo esc_html__( 'Contact us', 'adina' ); ?></h5>
            </div>
        </div>
        <div class="tdoffcanvas__social">
            <div class="social-icon">
                <?php foreach( $settings['mobile_menu_social_list'] as $social_icon ) : ?>
                    <?php if ( !empty( $social_icon['social_icon_select'] ) ) : ?>
                        <a href="<?php echo esc_url( $social_icon[ 'icon_url' ]['url'] ); ?>">
                            <i class="fab fa-<?php echo esc_html( $social_icon[ 'social_icon_select' ] ); ?>"></i>
                        </a>
                    <?php endif; ?>
                <?php endforeach; ?>
            </div>
        </div>
    </div>
</div>
<div class="body-overlay"></div>
<!-- td-offcanvus-area-end -->