<!-- header-area-start -->
<div class="td-header-5-area p-relative z-index-11">
    <div class="td-header-5-top d-none d-md-block">
        <div class="container ">
            <div class="row align-items-center">
                <div class="col-xl-5 col-lg-6 col-md-8">
                    <div class="td-header-5-info-wrap">
                        <ul>
                            <li class="borders">
                                <a href="<?php echo esc_url($settings['iconbox_mail_link']['url']); ?>">
                                    <i class="fa-regular fa-envelope-open"></i>
                                    <div class="td-header-5-info">
                                        <p><?php echo esc_html( $settings[ 'iconbox_mail_text' ]  ); ?></p>
                                        <span><?php echo esc_html( $settings[ 'iconbox_mail_title' ]  ); ?></span>
                                    </div>
                                </a>
                            </li>
                            <li>
                                <a href="<?php echo esc_url($settings['iconbox_phone_link']['url']); ?>">
                                    <i class="fa-regular fa-phone-flip"></i>
                                    <div class="td-header-5-info">
                                        <p><?php echo esc_html( $settings[ 'iconbox_phone_text' ]  ); ?></p>
                                        <span><?php echo esc_html( $settings[ 'iconbox_phone_title' ]  ); ?></span>
                                    </div>
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>
                <div class="col-xl-3 col-lg-2 d-none d-lg-block">
                    <div class="td-header-5-logo ml-40">
                        <a href="<?php echo esc_url( home_url('/') ); ?>">
                            <?php
                                if ( 'custom' == $settings['logo_type'] && $settings['image']['url']) {
                                    echo Group_Control_Image_Size::get_attachment_image_html($settings, 'thumbnail', 'image');
                                } else {
                                    echo $this->adina_get_site_logo( $settings['logo_type'] );
                                }
                            ?>
                        </a>
                    </div>
                </div>
                <div class="col-lg-4 col-md-4">
                    <div class="td-header-5-btn text-right">
                        <a class="td-btn td-btn-3 td-left-right" href="<?php echo esc_url($settings['default_btn_url']['url']); ?>">
                            <?php echo esc_html( $settings[ 'default_btn_text' ]  ); ?>
                            <span class="td-arrow-angle ml-10"> 
                                <svg class="td-arrow-svg-top-right" xmlns="http://www.w3.org/2000/svg" width="10" height="10" viewBox="0 0 10.00 10.00">
                                <path d="M1.018 10.009 0 8.991l7.569-7.582H1.723L1.737 0h8.26v8.274H8.574l.013-5.847Z" />
                                <path d="M1.018 10.009 0 8.991l7.569-7.582H1.723L1.737 0h8.26v8.274H8.574l.013-5.847Z" />
                                </svg> 
                            </span>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="td-header-5-bottom">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="td-header-5-bg" id="header-sticky">
                        <div class="row align-items-center">
                            <div class="col-lg-8 col-6">
                                <div class="td-main-menu td-main-menu-2 td-main-menu-5 d-none d-lg-block">
                                    <nav class="td-main-menu-content">
                                        <?php wp_nav_menu( $args );?>
                                    </nav>
                                </div>
                                <div class="td-header-5-logo ml-30 d-lg-none">
                                    <a href="<?php echo esc_url( home_url('/') ); ?>">
                                        <?php
                                            if ( 'custom' == $settings['logo_type'] && $settings['image']['url']) {
                                                echo Group_Control_Image_Size::get_attachment_image_html($settings, 'thumbnail', 'image');
                                            } else {
                                                echo $this->adina_get_site_logo( $settings['logo_type'] );
                                            }
                                        ?>
                                    </a>
                                </div>
                            </div>
                            <div class="col-lg-4 col-6">
                                <div class="td-header-5-right">
                                    <div class="td-header-search td-header-5-search d-none d-lg-block">
                                        <form action="<?php echo esc_url( home_url( '/' ) ); ?>"  method="get">
                                            <div class="td-header-input p-relative">
                                                <input type="email" name="s" placeholder="<?php echo esc_attr__( 'Search here...', 'adina' ); ?>">
                                                <button class="td-header-search-btn" type="button">
                                                    <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                        <path d="M8.1172 0C12.593 0 16.2344 3.64136 16.2344 8.11718C16.2344 10.1445 15.4873 12.0007 14.254 13.4247L19.8284 18.9997C20.0572 19.2286 20.0572 19.5996 19.8284 19.8284C19.5995 20.0572 19.2286 20.0572 18.9997 19.8284L13.4254 14.2534C12.0012 15.4871 10.1448 16.2344 8.1172 16.2344C3.64139 16.2344 2.28882e-05 12.593 2.28882e-05 8.11718C2.28882e-05 3.64136 3.64139 0 8.1172 0ZM8.1172 15.0625C11.9469 15.0625 15.0625 11.9468 15.0625 8.11718C15.0625 4.28753 11.9468 1.17187 8.1172 1.17187C4.28756 1.17187 1.1719 4.28753 1.1719 8.11718C1.1719 11.9468 4.28756 15.0625 8.1172 15.0625Z" fill="currentColor" />
                                                    </svg>
                                                </button>
                                            </div>
                                        </form>
                                    </div>
                                    <div class="td-header-5-menubar">
                                        <button class="td-menu-bar">
                                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <path d="M6 6H0V0H6V6ZM15 0H9V6H15V0ZM24 0H18V6H24V0ZM6 9H0V15H6V9ZM15 9H9V15H15V9ZM24 9H18V15H24V9ZM6 18H0V24H6V18ZM15 18H9V24H15V18ZM24 18H18V24H24V18Z" fill="#20282D" />
                                            </svg>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- header-area-end -->



<!-- td-offcanvus-area-start -->
<div class="tdoffcanvas-area">
    <div class="tdoffcanvas">
        <div class="tdoffcanvas__close-btn">
            <button class="close-btn"><i class="fal fa-times"></i></button>
        </div>
        <div class="tdoffcanvas__logo">
            <a href="<?php echo esc_url( home_url('/') ); ?>">
                <img src="<?php echo esc_url( $settings[ 'mobile_menu_logo' ]['url'] ); ?>" alt="logo">
            </a>
        </div>
        <div class="td-main-menu-mobile d-lg-none"></div>
        <div class="td-offcanvas-content d-none d-lg-block mb-50">
            <h2 class="tp-offcanvas-title"><?php echo esc_html( $settings[ 'offcanvas_title' ]  ); ?></h2>
            <p><?php echo esc_html( $settings[ 'offcanvas_text' ]  ); ?></p>
        </div>
        <div class="d-none d-lg-block">
            <div class="td-offcanvas-gallery mb-50">
                <?php foreach( $settings['offcanvas_img_list'] as $img_list ) : ?>
                    <a class="popup-image" href="<?php echo esc_url( $img_list['offcanvas_img']['url'] ); ?>">
                        <img class="m-img" src="<?php echo esc_url( $img_list['offcanvas_img']['url'] ); ?>" alt="">
                    </a>
                <?php endforeach; ?>
            </div>
        </div>
        <div class="tdoffcanvas__contact-info">
            <div class="tdoffcanvas__contact-title">
                <h5><?php echo esc_html__( 'Contact us', 'adina' ); ?></h5>
            </div>
        </div>
        <div class="tdoffcanvas__social">
            <div class="social-icon">
                <?php foreach( $settings['mobile_menu_social_list'] as $social_icon ) : ?>
                    <?php if ( !empty( $social_icon['social_icon_select'] ) ) : ?>
                        <a href="<?php echo esc_url( $social_icon[ 'icon_url' ]['url'] ); ?>">
                            <i class="fab fa-<?php echo esc_html( $social_icon[ 'social_icon_select' ] ); ?>"></i>
                        </a>
                    <?php endif; ?>
                <?php endforeach; ?>
            </div>
        </div>
    </div>
</div>
<div class="body-overlay"></div>
<!-- td-offcanvus-area-end -->


