<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Utils;
use \Elementor\Group_Control_Background;
use \Elementor\Repeater;
/**
 *
 * Hero Navbar Widget .
 *
 */
class Adina_Hero_Navbar extends Widget_Base {

	public function get_name() {
		return 'hero_navbar';
	}

	public function get_title() {
		return __( 'Hero Navbar', 'adina' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'adina' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'navbar_section',
			[
				'label' 	=> __( 'Content', 'adina' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			] 
        );
		$repeater = new Repeater();

        $repeater->add_control(
			'navbar_text',
			[
				'label'   => esc_html__( 'Title', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( 'Our Mission', 'adina' ),
			]
		);
        $repeater->add_control(
			'navbar_link',
			[
				'label' => __( 'URL', 'adina' ),
				'type' => Controls_Manager::URL,
			]
		);
        $this->add_control(
			'navbar_item',
			[
				'label' => __( 'Item', 'adina' ),
				'type' 		=> Controls_Manager::REPEATER,
				'fields' 	=> $repeater->get_controls(),
			]
		);
		$this->end_controls_section();

        // Box style
        $this->start_controls_section(
            'box_style',
            [
                'label' => __( 'Box', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'box_border',
				'selector' => '{{WRAPPER}} .td-hero-2-navebar',
			]
		);
		$this->end_controls_section();

        // Item style
        $this->start_controls_section(
            'item_style',
            [
                'label' => __( 'Item', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'item_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-hero-2-navebar-single span' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'item_typography',
				'selector' => '{{WRAPPER}} .td-hero-2-navebar-single span',
			]
		);
        $this->add_control(
            'item_bg_color',
            [
                'label' => __( 'Background Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-hero-2-navebar-single' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'box_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-hero-2-navebar-single' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'item_icon_color',
            [
                'label' => __( 'Icon Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-hero-2-navebar-single a' => 'color: {{VALUE}}',
                ],
            ]
        );
		$this->end_controls_section();

	}

	protected function render() {
        $settings = $this->get_settings_for_display();

		?>
            <div class="td-hero-2-navebar">
                <div class="container">
                    <div class="row gx-0">
                        <?php foreach( $settings['navbar_item'] as $navbar_item ) : ?>
                            <div class="col-lg-3 col-md-6 col-sm-6">
                                <div class="td-hero-2-navebar-single">
                                    <span><?php echo esc_html( $navbar_item[ 'navbar_text' ]  ); ?></span>
                                    <a href="<?php echo esc_url( $navbar_item[ 'navbar_link' ]['url'] ); ?>">
                                        <i class="fa-regular fa-arrow-right-long"></i>
                                    </a>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
		<?php
	}
}
$widgets_manager->register( new \Adina_Hero_Navbar() );