<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Utils;
use \Elementor\Group_Control_Background;
use \Elementor\Repeater;
/**
 *
 * Hero Slider Widget .
 *
 */
class Adina_Hero_Slider extends Widget_Base {

	public function get_name() {
		return 'adina_hero_slider';
	}

	public function get_title() {
		return __( 'Adina Hero Slider', 'adina' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'adina' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'hero_section',
			[
				'label' 	=> __( 'Content', 'adina' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			] 
        );
        $this->add_control(
			'social_link_01',
			[
				'label' => __( 'Social Link 01', 'adina' ),
				'type' => Controls_Manager::URL,
			]
		);
        $this->add_control(
			'social_link_02',
			[
				'label' => __( 'Social Link 02', 'adina' ),
				'type' => Controls_Manager::URL,
			]
		);
        $this->add_control(
			'social_link_03',
			[
				'label' => __( 'Social Link 03', 'adina' ),
				'type' => Controls_Manager::URL,
			]
		);
		$this->end_controls_section();

        // slider item
        $this->start_controls_section(
			'hero_slider_section',
			[
				'label' 	=> __( 'Slider Content', 'adina' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			] 
        );
		$repeater = new Repeater();

        $repeater->add_control(
            'bg_image',
            [
                'label' => __('Background Image', 'adina'),
                'type'  => Controls_Manager::MEDIA,
            ]
        );
        $repeater->add_control(
            'badge_image',
            [
                'label' => __('Badge Image', 'adina'),
                'type'  => Controls_Manager::MEDIA,
            ]
        );
        $repeater->add_control(
			'shadow_title',
			[
				'label'   => esc_html__( 'Shadow Title', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( 'A', 'adina' ),
			]
		);
        $repeater->add_control(
			'hero_title',
			[
				'label'   => esc_html__( 'Title', 'adina' ),
				'type'    => Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'Make your business boom with Adina', 'adina' ),
                'label_block' => true,
			]
		);
        $repeater->add_control(
			'link_title',
			[
				'label'   => esc_html__( 'Link Title', 'adina' ),
				'type'    => Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'Adina', 'adina' ),
			]
		);
        $repeater->add_control(
			'title_url',
			[
				'label' => __( 'Title URL', 'adina' ),
				'type' => Controls_Manager::URL,
			]
		);
        $repeater->add_control(
			'btn_text',
			[
				'label'   => esc_html__( 'Button Text', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( 'Our Services', 'adina' ),
			]
		);
        $repeater->add_control(
			'btn_link',
			[
				'label' => __( 'URL', 'adina' ),
				'type' => Controls_Manager::URL,
			]
		);
        $repeater->add_control(
			'slider_number',
			[
				'label'   => esc_html__( 'Slider Number', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( '01.', 'adina' ),
			]
		);
        $repeater->add_control(
			'nav_title',
			[
				'label'   => esc_html__( 'Nav Title', 'adina' ),
				'type'    => Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'Make your business boom with Adina', 'adina' ),
                'label_block' => true,
			]
		);
        $repeater->add_control(
            'slider_image',
            [
                'label' => __('Slider Image', 'adina'),
                'type'  => Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
			'hero_slider_content',
			[
				'label' => __( 'Slider Item', 'adina' ),
				'type' 		=> Controls_Manager::REPEATER,
				'fields' 	=> $repeater->get_controls(),
			]
		);
		$this->end_controls_section();

        // Social Icon style
        $this->start_controls_section(
            'social_icon_style',
            [
                'label' => __( 'Social Icon', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'social_icon_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-hero-4-social ul li a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'social_icon_hover_color',
            [
                'label' => __( 'Hover Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-hero-4-social ul li a:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'social_icon_bg_color',
            [
                'label' => __( 'Backrgound Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-hero-4-social ul li a' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'social_icon_bg_hover_color',
            [
                'label' => __( 'Backrgound Hover Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-hero-4-social ul li a:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'social_icon_border',
				'selector' => '{{WRAPPER}} .td-hero-4-social ul li a',
			]
		);
        $this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'social_icon_hover_border',
				'selector' => '{{WRAPPER}} .td-hero-4-social ul li a:hover',
			]
		);
		$this->end_controls_section();

        // Shadow Title style
        $this->start_controls_section(
            'shadow_title_style',
            [
                'label' => __( 'Shadow Title', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'shadow_title_typography',
				'selector' => '{{WRAPPER}} .td-hero-4-big-text h2',
			]
		);
		$this->add_control(
            'shadow_title_fill_color',
            [
                'label' => __( 'Fill Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-hero-4-big-text h2' => '-webkit-text-fill-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'shadow_title_stroke_color',
            [
                'label' => __( 'Stroke Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-hero-4-big-text h2' => '-webkit-text-stroke-color: {{VALUE}}',
                ],
            ]
        );
		$this->add_responsive_control(
			'shadow_title_stroke_width',
			[
				'label' => esc_html__( 'Stroke Width', 'adina' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .td-hero-4-big-text h2' => '-webkit-text-stroke-width: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();

        // Title style
        $this->start_controls_section(
            'title_style',
            [
                'label' => __( 'Title', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'title_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-hero-4-title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'selector' => '{{WRAPPER}} .td-hero-4-title',
			]
		);
		$this->add_responsive_control(
            'title_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-hero-4-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

        // Button style
        $this->start_controls_section(
            'btn_style',
            [
                'label' => __( 'Button', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'btn_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-btn-7' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'btn_bg_color',
            [
                'label' => __( 'Background Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-btn-7' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'btn_typography',
				'selector' => '{{WRAPPER}} .td-btn-7',
			]
		);
        $this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'btn_border',
				'selector' => '{{WRAPPER}} .td-btn',
			]
		);
        $this->add_responsive_control(
			'btn_radius',
			[
				'label'         => __( 'Border Radius', 'adina' ),
				'type'          => Controls_Manager::DIMENSIONS,
				'size_units'    => [ 'px', '%', 'em' ],
				'selectors'     => [
					'{{WRAPPER}} .td-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );
        $this->add_responsive_control(
            'btn_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-hero-4-btn .td-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'btn_icon_color',
            [
                'label' => __( 'Icon Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-arrow-svg-top-right' => 'fill: {{VALUE}}',
                ],
            ]
        );
		$this->end_controls_section();

        // Nav Item style
        $this->start_controls_section(
            'nav_item_style',
            [
                'label' => __( 'Nav Item', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'number_color',
            [
                'label' => __( 'Number Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-hero-4-nav-content span' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'nav_title_color',
            [
                'label' => __( 'Nav Title Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-hero-4-nav-title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'nav_bg_color',
            [
                'label' => __( 'Nav Background Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-hero-4-nav-content' => 'background-color: {{VALUE}}',
                ],
            ]
        );
		$this->end_controls_section();

	}

	protected function render() {
        $settings = $this->get_settings_for_display();

		?>
            <div class="td-hero-4-area fix p-relative">
                <div class="swiper-container td-hero-4-slider-active">
                    <div class="swiper-wrapper">
                        <?php foreach( $settings['hero_slider_content'] as $slider_content ) : ?>
                            <div class="swiper-slide">
                                <div class="td-hero-4-singles pt-175 pb-165">                
                                    <div class="td-hero-4-bg-home bg-position" style="background-image: url('<?php echo esc_url($slider_content['bg_image']['url']); ?>');"></div>
                                    <div class="container">
                                    <div class="row justify-content-center">
                                        <div class="col-lg-3 d-none d-lg-block">
                                            <div class="td-hero-4-big-text p-relative">
                                                <img class="td-hero-4-badge" src="<?php echo esc_url($slider_content['badge_image']['url']); ?>" alt="badge">
                                                <h2><?php echo esc_html( $slider_content[ 'shadow_title' ]  ); ?></h2>
                                            </div>
                                        </div>
                                        <div class="col-lg-7">
                                            <div class="td-hero-4-content mt-60">
                                                <h3 class="td-hero-4-title mb-55">
                                                    <?php echo adina_kses( $slider_content[ 'hero_title' ]  ); ?>
                                                    <a href="<?php echo esc_url($slider_content['title_url']['url']); ?>">
                                                        <?php echo esc_html( $slider_content[ 'link_title' ]  ); ?>
                                                    </a>
                                                </h3>
                                                <div class="td-hero-4-btn">
                                                <a class="td-btn td-btn-7 td-left-right" href="<?php echo esc_url($slider_content['btn_link']['url']); ?>">
                                                    <?php echo esc_html( $slider_content[ 'btn_text' ]  ); ?>
                                                    <span class="td-arrow-angle ml-10"> 
                                                        <svg class="td-arrow-svg-top-right" xmlns="http://www.w3.org/2000/svg" width="10" height="10" viewBox="0 0 10.00 10.00">
                                                            <path d="M1.018 10.009 0 8.991l7.569-7.582H1.723L1.737 0h8.26v8.274H8.574l.013-5.847Z" />
                                                            <path d="M1.018 10.009 0 8.991l7.569-7.582H1.723L1.737 0h8.26v8.274H8.574l.013-5.847Z" />
                                                        </svg> 
                                                    </span>
                                                </a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>
                <div class="td-hero-4-dot d-sm-flex"></div>
                <div class="td-hero-4-nav-slider">
                    <div class="td-hero-4-nav-slider-inner p-relative">
                        <div class="td-hero-4-nav-active swiper-container">
                            <div class="swiper-wrapper">
                                <?php foreach( $settings['hero_slider_content'] as $slider_content ) : ?>
                                    <div class="td-hero-4-nav-item d-flex align-items-center swiper-slide">
                                        <div class="td-hero-4-nav-content">
                                            <span>
                                                <?php echo esc_html( $slider_content[ 'slider_number' ]  ); ?>
                                            </span>
                                            <h3 class="td-hero-4-nav-title">
                                                <?php echo esc_html( $slider_content[ 'nav_title' ]  ); ?>
                                            </h3>
                                        </div>
                                        <div class="td-hero-4-nav-thumb">
                                            <img src="<?php echo esc_url($slider_content['slider_image']['url']); ?>" alt="">
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        </div>
                        <div class="td-hero-4-navigation-wrapper d-flex justify-content-between">
                            <button class="td-hero-4-navigation-next"><i class="fa-light fa-arrow-left-long"></i></button>
                            <button class="td-hero-4-navigation-prev"><i class="fa-light fa-arrow-right-long"></i></button>
                        </div>
                    </div>
                </div>
                <div class="td-hero-4-social d-none d-lg-block">
                    <ul>
                        <li><a href="<?php echo esc_url($settings['social_link_01']['url']); ?>"><i class="fa-brands fa-facebook-f"></i></a></li>
                        <li><a href="<?php echo esc_url($settings['social_link_02']['url']); ?>"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M389.2 48h70.6L305.6 224.2 487 464H345L233.7 318.6 106.5 464H35.8L200.7 275.5 26.8 48H172.4L272.9 180.9 389.2 48zM364.4 421.8h39.1L151.1 88h-42L364.4 421.8z"/></svg></a></li>
                        <li><a href="<?php echo esc_url($settings['social_link_03']['url']); ?>"><i class="fa-brands fa-behance"></i></a></li>
                    </ul>
                    <span>Follow Us:</span>
                </div>
            </div>
		<?php
	}
}
$widgets_manager->register( new \Adina_Hero_Slider() );