<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Utils;
use \Elementor\Group_Control_Background;
use \Elementor\Repeater;
/**
 *
 * History Section Widget .
 *
 */
class Adina_History_Section extends Widget_Base {

	public function get_name() {
		return 'adina_history_section';
	}

	public function get_title() {
		return __( 'Adina History Section', 'adina' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'adina' ];
	}

	protected function register_controls() {

        // slider item
        $this->start_controls_section(
			'history_section',
			[
				'label' 	=> __( 'Content', 'adina' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			] 
        );
		$repeater = new Repeater();

        $repeater->add_control(
			'history_year',
			[
				'label'   => esc_html__( 'Year', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( '1972', 'adina' ),
                'label_block' => true,
			]
		);
        $repeater->add_control(
			'history_title',
			[
				'label'   => esc_html__( 'Title', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( 'Journey Was Started', 'adina' ),
                'label_block' => true,
			]
		);
        $repeater->add_control(
			'history_text',
			[
				'label'   => esc_html__( 'Description', 'adina' ),
				'type'    => Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'We are constantly rethinking the future by creating the next generation of products, brands and services from a hybrid perspective.', 'adina' ),
                'label_block' => true,
			]
		);
        $this->add_control(
			'history_list',
			[
				'label' => __( 'Item', 'adina' ),
				'type' 		=> Controls_Manager::REPEATER,
				'fields' 	=> $repeater->get_controls(),
			]
		);
		$this->end_controls_section();

        // Box style
        $this->start_controls_section(
            'box_style',
            [
                'label' => __( 'Box', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'box_bg_color',
            [
                'label' => __( 'Background Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-history-item' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'box_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-history-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'box_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-history-item' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        // Year style
        $this->start_controls_section(
            'year_style',
            [
                'label' => __( 'Year', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'year_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-history-year' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'year_typography',
				'selector' => '{{WRAPPER}} .td-history-year',
			]
		);
		$this->add_responsive_control(
            'year_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-history-year' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

        // Title style
        $this->start_controls_section(
            'title_style',
            [
                'label' => __( 'Title', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'title_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-history-title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'selector' => '{{WRAPPER}} .td-history-title',
			]
		);
		$this->add_responsive_control(
            'title_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-history-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

        // Text style
        $this->start_controls_section(
            'text_style',
            [
                'label' => __( 'Description', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'text_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-history-item p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'text_typography',
				'selector' => '{{WRAPPER}} .td-history-item p',
			]
		);
        $this->add_responsive_control(
            'text_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-history-item p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

        // Number style
        $this->start_controls_section(
            'number_style',
            [
                'label' => __( 'Number', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'number_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-history-navebar ul li a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'number_active_color',
            [
                'label' => __( 'Active Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-history-navebar ul li.current a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'number_bg_color',
            [
                'label' => __( 'Background Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-history-navebar ul li a' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'number_active_bg_color',
            [
                'label' => __( 'Active Background Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-history-navebar ul li.current a' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'number_border',
				'selector' => '{{WRAPPER}} .td-history-navebar ul li a',
			]
		);
        $this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'number_active_border',
				'selector' => '{{WRAPPER}} .td-history-navebar ul li.current a',
			]
		);
        $this->add_responsive_control(
			'number_radius',
			[
				'label'         => __( 'Border Radius', 'adina' ),
				'type'          => Controls_Manager::DIMENSIONS,
				'size_units'    => [ 'px', '%', 'em' ],
				'selectors'     => [
					'{{WRAPPER}} .td-history-navebar ul li a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );
		$this->end_controls_section();

	}

	protected function render() {
        $settings = $this->get_settings_for_display();

		?>
            <div class="td-history-wrapper p-relative">
                <div class="td-history-navebar d-none d-sm-block">
                    <ul id="section-time">
                        <?php foreach( $settings['history_list'] as $index => $item ) : ?>
                            <li class="<?php echo $index === 0 ? 'current' : ''; ?>">
                                <span></span>
                                <a href="#section-<?php echo esc_attr( $index + 1 ); ?>" title="">
                                    <?php echo esc_html( str_pad( $index + 1, 2, '0', STR_PAD_LEFT ) ); ?>
                                </a>
                            </li>
                        <?php endforeach; ?>
                    </ul>
                </div>
                <?php foreach( $settings['history_list'] as $index => $item ) : ?>
                    <div id="section-<?php echo esc_attr( $index + 1 ); ?>" class="td-history-item mb-80">
                        <h2 class="td-history-year mb-35">
                            <?php echo esc_html( $item['history_year'] ); ?>
                        </h2>
                        <h4 class="td-history-title mb-20">
                            <?php echo esc_html( $item['history_title'] ); ?>
                        </h4>
                        <p>
                            <?php echo esc_html( $item['history_text'] ); ?>
                        </p>
                    </div>
                <?php endforeach; ?>
            </div>
		<?php
	}
}
$widgets_manager->register( new \Adina_History_Section() );