<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Utils;
use \Elementor\Group_Control_Background;
use \Elementor\Repeater;
use \Elementor\Icons_Manager;
use \Elementor\Group_Control_Box_Shadow;
/**
 *
 * Iconbox Three Widget .
 *
 */
class Adina_Iconbox_Three extends Widget_Base {

	public function get_name() {
		return 'adina_iconbox_three';
	}

	public function get_title() {
		return __( 'Adina Iconbox Three', 'adina' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'adina' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'iconbox_section',
			[
				'label' 	=> __( 'Iconbox', 'adina' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			] 
        );
        $this->add_control(
            'iconbox_layout',
            [
                'label' => esc_html__('Select Layout', 'adina'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'layout-1' => esc_html__('Layout 1', 'adina'),
                    'layout-2' => esc_html__('Layout 2', 'adina'),
                ],
                'default' => 'layout-1',
            ]
        );
        $this->add_control(
            'iconbox_img',
            [
                'label' => __('Image', 'adina'),
                'type'  => Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
			'iconbox_title',
			[
				'label'   => esc_html__( 'Title', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( 'Estimations & planning for business decisions', 'adina' ),
                'label_block' => true,
			]
		);
        $this->add_control(
			'btn_text',
			[
				'label'   => esc_html__( 'Button Text', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( 'Estimate Market Size', 'adina' ),
                'label_block' => true,
			]
		);
        $this->add_control(
			'btn_link',
			[
				'label' => __( 'URL', 'adina' ),
				'type' => Controls_Manager::URL,
			]
		);
		$this->end_controls_section();

        // Title style
        $this->start_controls_section(
            'title_style',
            [
                'label' => __( 'Title', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'title_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-video-cta-title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'selector' => '{{WRAPPER}} .td-video-cta-title',
			]
		);
		$this->add_responsive_control(
            'title_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-video-cta-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

        // Button style
        $this->start_controls_section(
            'btn_style',
            [
                'label' => __( 'Button', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'btn_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-video-cta-btn a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'btn_typography',
				'selector' => '{{WRAPPER}} .td-video-cta-btn a',
			]
		);
        $this->add_control(
            'btn_icon_color',
            [
                'label' => __( 'Icon Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-arrow-svg-top-right' => 'fill: {{VALUE}}',
                ],
            ]
        );
		$this->end_controls_section();

        // Box style
        $this->start_controls_section(
            'box_style',
            [
                'label' => __( 'Box', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'box_bg_color',
            [
                'label' => __( 'Background Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-video-cta-wrap' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'video_box_shadow',
				'selector' => '{{WRAPPER}} .td-video-cta-wrap',
			]
		);
        $this->add_responsive_control(
            'box_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-video-cta-wrap' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'box_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-video-cta-wrap' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

	}

	protected function render() {
        $settings = $this->get_settings_for_display();

		?>
            <?php if ($settings['iconbox_layout'] === 'layout-1') : ?>
                <div class="td-video-cta-wrap p-relative">
                    <div class="row">
                        <div class="col-lg-5 col-md-5">
                            <div class="td-video-cta-thumb">
                                <img class="w-100" src="<?php echo esc_url( $settings[ 'iconbox_img' ]['url'] ); ?>" alt="cta">
                            </div>
                        </div>
                        <div class="col-lg-7 col-md-7">
                            <div class="td-video-cta-content">
                                <h3 class="td-video-cta-title mb-20">
                                    <?php echo esc_html( $settings[ 'iconbox_title' ]  ); ?>
                                </h3>
                                <div class="td-video-cta-btn">
                                <a class="mr-20 td-left-right" href="<?php echo esc_url($settings['btn_link']['url']); ?>">
                                    <?php echo esc_html( $settings[ 'btn_text' ]  ); ?>
                                    <span class="td-arrow-angle ml-10"> 
                                        <svg class="td-arrow-svg-top-right" xmlns="http://www.w3.org/2000/svg" width="10" height="10" viewBox="0 0 10.00 10.00">
                                            <path d="M1.018 10.009 0 8.991l7.569-7.582H1.723L1.737 0h8.26v8.274H8.574l.013-5.847Z" />
                                            <path d="M1.018 10.009 0 8.991l7.569-7.582H1.723L1.737 0h8.26v8.274H8.574l.013-5.847Z" />
                                        </svg> 
                                    </span>
                                </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

            <?php if ($settings['iconbox_layout'] === 'layout-2') : ?>
                <div class="td-video-cta-wrap p-relative">
                    <div class="row">
                        <div class="col-lg-7 col-md-7">
                            <div class="td-video-cta-content">
                                <h3 class="td-video-cta-title mb-20">
                                    <?php echo esc_html( $settings[ 'iconbox_title' ]  ); ?>
                                </h3>
                                <div class="td-video-cta-btn">
                                <a class="mr-20 td-left-right" href="<?php echo esc_url($settings['btn_link']['url']); ?>">
                                    <?php echo esc_html( $settings[ 'btn_text' ]  ); ?>
                                    <span class="td-arrow-angle ml-10"> 
                                        <svg class="td-arrow-svg-top-right" xmlns="http://www.w3.org/2000/svg" width="10" height="10" viewBox="0 0 10.00 10.00">
                                            <path d="M1.018 10.009 0 8.991l7.569-7.582H1.723L1.737 0h8.26v8.274H8.574l.013-5.847Z" />
                                            <path d="M1.018 10.009 0 8.991l7.569-7.582H1.723L1.737 0h8.26v8.274H8.574l.013-5.847Z" />
                                        </svg> 
                                    </span>
                                </a>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-5 col-md-6">
                            <div class="td-video-cta-thumb td-video-cta-thumb-2">
                                <img class="w-100" src="<?php echo esc_url( $settings[ 'iconbox_img' ]['url'] ); ?>" alt="cta">
                            </div>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
		<?php
	}
}
$widgets_manager->register( new \Adina_Iconbox_Three() );