<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Utils;
use \Elementor\Group_Control_Background;
use \Elementor\Repeater;
use \Elementor\Icons_Manager;
/**
 *
 * Iconbox Widget .
 *
 */
class Adina_Iconbox extends Widget_Base {

	public function get_name() {
		return 'adina_iconbox';
	}

	public function get_title() {
		return __( 'Adina Iconbox', 'adina' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'adina' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'iconbox_section',
			[
				'label' 	=> __( 'Iconbox', 'adina' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			] 
        );
		$repeater = new Repeater();

        $repeater->add_control(
			'order_nmbr',
			[
				'label'   => esc_html__( 'Order Number', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( 'Process 01', 'adina' ),
                'label_block' => true,
			]
		);
        $repeater->add_control(
			'iconbox_title',
			[
				'label'   => esc_html__( 'Title', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( 'Discuss about project', 'adina' ),
                'label_block' => true,
			]
		);
        $repeater->add_control(
            'adina_list_icon',
            [
                'label' => __('Icon', 'adina'),
                'type'  => Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
			'iconbox_list',
			[
				'label' => __( 'Item', 'adina' ),
				'type' 		=> Controls_Manager::REPEATER,
				'fields' 	=> $repeater->get_controls(),
			]
		);
		$this->end_controls_section();

        // Number style
        $this->start_controls_section(
            'nmbr_style',
            [
                'label' => __( 'Number', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'nmbr_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-about-3-order' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'nmbr_typography',
				'selector' => '{{WRAPPER}} .td-about-3-order',
			]
		);
		$this->add_responsive_control(
            'nmbr_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-about-3-order' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

        // Title style
        $this->start_controls_section(
            'title_style',
            [
                'label' => __( 'Title', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'title_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-about-3-title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'selector' => '{{WRAPPER}} .td-about-3-title',
			]
		);
		$this->add_responsive_control(
            'title_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-about-3-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

        // Image style
        $this->start_controls_section(
            'img_style',
            [
                'label' => __( 'Image', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
			'img_width',
			[
				'label' => esc_html__( 'Width', 'adina' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .td-about-3-icon img' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();

        // Box style
        $this->start_controls_section(
            'box_style',
            [
                'label' => __( 'Box', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'box_border',
				'selector' => '{{WRAPPER}} .td-about-3-list-item',
			]
		);
        $this->add_responsive_control(
            'box_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-about-3-list-item' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'box_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-about-3-list-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

	}

	protected function render() {
        $settings = $this->get_settings_for_display();

		?>
            <div class="td-about-3-list">
                <?php foreach( $settings['iconbox_list'] as $iconbox_list ) : ?>
                    <div class="td-about-3-list-item">
                        <div class="td-about-3-content">
                            <span class="td-about-3-order mb-5"><?php echo esc_html( $iconbox_list[ 'order_nmbr' ]  ); ?></span>
                            <h3 class="td-about-3-title"><?php echo esc_html( $iconbox_list[ 'iconbox_title' ]  ); ?></h3>
                        </div>
                        <div class="td-about-3-icon">
                            <span>
                                <img src="<?php echo esc_url( $iconbox_list[ 'adina_list_icon' ]['url'] ); ?>" alt="thumb">
                            </span>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
		<?php
	}
}
$widgets_manager->register( new \Adina_Iconbox() );