<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Utils;
use \Elementor\Group_Control_Background;
use \Elementor\Repeater;
/**
 *
 * Image Box Widget .
 *
 */
class Adina_Image_Box extends Widget_Base {

	public function get_name() {
		return 'image_box';
	}

	public function get_title() {
		return __( 'Adina Image Box', 'adina' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'adina' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'img_box_section',
			[
				'label' 	=> __( 'Images', 'adina' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			] 
        );
		$this->add_control(
            'image_layout',
            [
                'label' => esc_html__('Select Layout', 'adina'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'layout-1' => esc_html__('Layout 1', 'adina'),
                    'layout-2' => esc_html__('Layout 2', 'adina'),
                    'layout-3' => esc_html__('Layout 3', 'adina'),
                    'layout-4' => esc_html__('Layout 4', 'adina'),
                    'layout-5' => esc_html__('Layout 5', 'adina'),
                ],
                'default' => 'layout-1',
            ]
        );
        $this->add_control(
            'box_image_01',
            [
                'label' => __('Image 01', 'adina'),
                'type'  => Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
            'box_image_02',
            [
                'label' => __('Image 02', 'adina'),
                'type'  => Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
            'box_image_03',
            [
                'label' => __('Image 03', 'adina'),
                'type'  => Controls_Manager::MEDIA,
				'condition' => [
                    'image_layout' => ['layout-1', 'layout-2', 'layout-3', 'layout-4'],
                ]
            ]
        );
		$this->add_control(
            'box_image_04',
            [
                'label' => __('Image 04', 'adina'),
                'type'  => Controls_Manager::MEDIA,
				'condition' => [
                    'image_layout' => ['layout-3', 'layout-4'],
                ]
            ]
        );
		$this->add_control(
            'box_image_05',
            [
                'label' => __('Image 04', 'adina'),
                'type'  => Controls_Manager::MEDIA,
				'condition' => [
                    'image_layout' => 'layout-4',
                ]
            ]
        );
		$this->end_controls_section();

		// Main Image style
        $this->start_controls_section(
            'main_image_style',
            [
                'label' => __( 'Main Image', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
				'condition' => [
                    'image_layout' => 'layout-4',
                ]
            ]
        );
		$this->add_control(
            'img_bg_color',
            [
                'label' => __( 'Background Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-about-4-thumb img' => 'background-color: {{VALUE}}',
                ],
            ]
        );
		$this->add_responsive_control(
            'img_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-about-4-thumb img' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

        // Shape style
        $this->start_controls_section(
            'shape_style',
            [
                'label' => __( 'Shape', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
				'condition' => [
                    'image_layout' => 'layout-1',
                ]
            ]
        );
        $this->add_responsive_control(
			'shape_width',
			[
				'label' => esc_html__( 'Width', 'adina' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .td-about-2-shape' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);
        $this->add_responsive_control(
			'shape_height',
			[
				'label' => esc_html__( 'Height', 'adina' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .td-about-2-shape' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);
        $this->add_control(
            'shape_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-about-2-shape' => 'background-color: {{VALUE}}',
                ],
            ]
        );
		$this->end_controls_section();

	}

	protected function render() {
        $settings = $this->get_settings_for_display();
		$layout = $settings['image_layout'];

		?>
			<?php
                if ( $layout) {
                    include('imagebox/'.$layout.'.php');
                }
            ?> 
		<?php
	}
}
$widgets_manager->register( new \Adina_Image_Box() );