<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Utils;
use \Elementor\Group_Control_Background;
use \Elementor\Repeater;
/**
 *
 * Image Slider Widget .
 *
 */
class Adina_Image_Slider extends Widget_Base {

	public function get_name() {
		return 'adina_image_slider';
	}

	public function get_title() {
		return __( 'Adina Image Slider', 'adina' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'adina' ];
	}

	protected function register_controls() {

        // slider item
        $this->start_controls_section(
			'image_slider_section',
			[
				'label' 	=> __( 'Slider Content', 'adina' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			] 
        );
        $this->add_control(
            'rotate_image',
            [
                'label' => __('Rotate Image', 'adina'),
                'type'  => Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
            'quote_image',
            [
                'label' => __('Quote Image', 'adina'),
                'type'  => Controls_Manager::MEDIA,
            ]
        );
		$repeater = new Repeater();

        $repeater->add_control(
            'slider_image',
            [
                'label' => __('Image', 'adina'),
                'type'  => Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
			'Image_list',
			[
				'label' => __( 'Slider Item', 'adina' ),
				'type' 		=> Controls_Manager::REPEATER,
				'fields' 	=> $repeater->get_controls(),
			]
		);
		$this->end_controls_section();

        // Box style
        $this->start_controls_section(
            'box_style',
            [
                'label' => __( 'Box', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'box_bg_color',
            [
                'label' => __( 'Background Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-about-area' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'box_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-about-area' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

	}

	protected function render() {
        $settings = $this->get_settings_for_display();

		?>
            <div class="td-about-area fix p-relative pt-140 pb-110">
                <div class="td-about-5-position">
                    <div class="td-testimonial-qoute-thumb z-index-11 p-relative" data-parallax='{"x": -100, "smoothness": 10}'>
                        <img class="td-testimonial-qoute" src="<?php echo esc_url($settings['rotate_image']['url']); ?>" alt="badge">
                        <img class="td-testimonial-qoute-2" src="<?php echo esc_url($settings['quote_image']['url']); ?>" alt="badge">
                    </div>
                </div>
                <div class="container-fluid p-0">
                    <div class="row td-gx-80">
                        <div class="td-about-slider-active swiper-container">
                            <div class="swiper-wrapper">
                                <?php foreach( $settings['Image_list'] as $img_slider ) : ?>
                                    <div class="swiper-slide wow slideInDown" data-wow-delay=".3s" data-wow-duration="1s">
                                        <div class="td-portfolio-wrap">
                                            <div class="td-poerfolio-thumb mb-30">
                                                <img class="w-100" src="<?php echo esc_url($img_slider['slider_image']['url']); ?>" alt="thumb">
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
		<?php
	}
}
$widgets_manager->register( new \Adina_Image_Slider() );