<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Utils;
use \Elementor\Group_Control_Background;
use \Elementor\Repeater;
/**
 *
 * Logo Slider Widget .
 *
 */
class Adina_Logo_Slider extends Widget_Base {

	public function get_name() {
		return 'adina_Logo_slider';
	}

	public function get_title() {
		return __( 'Adina Logo Slider', 'adina' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'adina' ];
	}

	protected function register_controls() {

        // slider item
        $this->start_controls_section(
			'Logo_slider_section',
			[
				'label' 	=> __( 'Slider Content', 'adina' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			] 
        );
		$repeater = new Repeater();

        $repeater->add_control(
            'logo_image',
            [
                'label' => __('Logo Image', 'adina'),
                'type'  => Controls_Manager::MEDIA,
            ]
        );
        $repeater->add_control(
			'logo_link',
			[
				'label' => __( 'URL', 'adina' ),
				'type' => Controls_Manager::URL,
			]
		);
        $this->add_control(
			'logo_list',
			[
				'label' => __( 'Slider Item', 'adina' ),
				'type' 		=> Controls_Manager::REPEATER,
				'fields' 	=> $repeater->get_controls(),
			]
		);
		$this->end_controls_section();

        // logo style
        $this->start_controls_section(
            'logo_style',
            [
                'label' => __( 'Logo', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'logo_bg_color',
            [
                'label' => __( 'Background Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-brand-single-logo a' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'logo_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-brand-single-logo a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

        // Box style
        $this->start_controls_section(
            'box_style',
            [
                'label' => __( 'Box', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
            'box_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-brand-slide .swiper-wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

	}

	protected function render() {
        $settings = $this->get_settings_for_display();

		?>
            <div class="td-brands-area">
                <div class="container-fluid">
                    <div class="row gx-0">
                        <div class="col-12">
                            <div class="td-brands-wrap company-logo-slider-full">
                                <div class="swiper-container td-brand-slide">
                                    <div class="swiper-wrapper">
                                        <?php foreach( $settings['logo_list'] as $logo_slider ) : ?>
                                            <div class="swiper-slide">
                                                <div class="td-brand-single-logo text-center">
                                                    <a href="<?php echo esc_url($logo_slider['logo_link']['url']); ?>">
                                                        <img src="<?php echo esc_url($logo_slider['logo_image']['url']); ?>" alt="brands">
                                                    </a>
                                                </div> 
                                            </div>
                                        <?php endforeach; ?>
                                    </div>
                                </div>     
                            </div>
                        </div>
                    </div>
                </div>
            </div> 
		<?php
	}
}
$widgets_manager->register( new \Adina_Logo_Slider() );