<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Utils;
use \Elementor\Group_Control_Background;
use \Elementor\Repeater;
/**
 *
 * Map Widget .
 *
 */
class Adina_Map extends Widget_Base {

	public function get_name() {
		return 'adina_map';
	}

	public function get_title() {
		return __( 'Adina Map', 'adina' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'adina' ];
	}

	protected function register_controls() {
        $this->start_controls_section(
			'map_section',
			[
				'label' 	=> __( 'Map', 'adina' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			] 
        );
        $this->add_control(
            'map_img',
            [
                'label' => __('Map Image', 'adina'),
                'type'  => Controls_Manager::MEDIA,
            ]
        );
        $repeater = new Repeater();

        $repeater->add_control(
			'location_title',
			[
				'label'   => esc_html__( 'Location Text', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( 'London', 'adina' ),
                'label_block' => true,
			]
		);
        $repeater->add_responsive_control(
            'location_position_dimensions',
            [
                'label' => __( 'Location Position', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}}.td-map-lucation-dot' => 'position: absolute; top: {{TOP}}{{UNIT}}; right: {{RIGHT}}{{UNIT}}; bottom: {{BOTTOM}}{{UNIT}}; left: {{LEFT}}{{UNIT}};',
                ],
            ]
        );                          
        $this->add_control(
			'map_locations',
			[
				'label' => __( 'Locations', 'adina' ),
				'type' 		=> Controls_Manager::REPEATER,
				'fields' 	=> $repeater->get_controls(),
			]
		);
		$this->end_controls_section();

        // Location style
        $this->start_controls_section(
            'location_style',
            [
                'label' => __( 'Location', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'location_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .location-title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'location_bg_color',
            [
                'label' => __( 'Background Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .location-title' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'location_typography',
				'selector' => '{{WRAPPER}} .location-title',
			]
		);
        $this->add_responsive_control(
			'location_radius',
			[
				'label'         => __( 'Border Radius', 'adina' ),
				'type'          => Controls_Manager::DIMENSIONS,
				'size_units'    => [ 'px', '%', 'em' ],
				'selectors'     => [
					'{{WRAPPER}} .location-title' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );
        $this->add_responsive_control(
            'location_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .location-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

        // Dot style
        $this->start_controls_section(
            'dot_style',
            [
                'label' => __( 'Dot', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'dot_bg_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-map-lucation-dot' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
			'dot_size',
			[
				'label' => esc_html__( 'Size', 'adina' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .td-map-lucation-dot' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();
        
	}

	protected function render() {
        $settings = $this->get_settings_for_display();

		?>
            <div class="td-map-thumb p-relative">
                <img class="w-100" src="<?php echo esc_url( $settings[ 'map_img' ]['url'] ); ?>" alt="map">
                <?php
                    $number_words = array('one', 'two', 'three', 'four', 'five', 'six', 'seven', 'eight', 'nine', 'ten'); 
                    foreach( $settings['map_locations'] as $index => $map_item ) : 
                ?>
                    <span class="td-map-lucation-dot <?php echo $number_words[$index]; ?> td-pulse-border elementor-repeater-item-<?php echo esc_attr( $map_item['_id'] ) ?>">
                        <div class="location-title"><?php echo esc_html( $map_item['location_title'] ); ?></div>
                    </span>
                <?php endforeach; ?>
            </div>
		<?php
	}
}
$widgets_manager->register( new \Adina_Map() );