<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Utils;
use \Elementor\Group_Control_Background;
use \Elementor\Repeater;
use \Elementor\Group_Control_Box_Shadow;
/**
 *
 * Pricing Widget .
 *
 */
class Adina_Pricing extends Widget_Base {

	public function get_name() {
		return 'adina_pricing';
	}

	public function get_title() {
		return __( 'Adina Pricing', 'adina' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'adina' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'pricing_section',
			[
				'label' 	=> __( 'Pricing', 'adina' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			] 
        );
        $this->add_control(
			'subtitle_text',
			[
				'label'   => esc_html__( 'SubTitle', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( 'Best Deals', 'adina' ),
                'label_block' => true,
			]
		);
        $this->add_control(
			'title_text',
			[
				'label'   => esc_html__( 'Title', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( 'Price for everyone', 'adina' ),
                'label_block' => true,
			]
		);
        $this->add_control(
			'discount_percentage',
			[
				'label'   => esc_html__( 'Discount', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( '10%', 'adina' ),
                'label_block' => true,
			]
		);
        $this->add_control(
			'monthly_text',
			[
				'label'   => esc_html__( 'Monthly Text', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( 'Monthly billing', 'adina' ),
                'label_block' => true,
			]
		);
        $this->add_control(
			'yearly_text',
			[
				'label'   => esc_html__( 'Yearly Text', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( 'Yearly billing', 'adina' ),
                'label_block' => true,
			]
		);
		$this->end_controls_section();

        // Pricing Table
        $this->start_controls_section(
			'pricing_table_section',
			[
				'label' 	=> __( 'Pricing Table', 'adina' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			] 
        );
        $this->add_control(
            'want_price_tab',
            [
                'label' => __('Price Tab?', 'adina'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'adina'),
                'label_off' => __('No', 'adina'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
		$repeater = new Repeater();

        $repeater->add_control(
            'need_popular_plan',
            [
                'label' => __('Active', 'adina'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'adina'),
                'label_off' => __('No', 'adina'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $repeater->add_control(
			'popular_text',
			[
				'label'   => esc_html__( 'Popular Text', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( 'Best Choice', 'adina' ),
                'label_block' => true,
                'condition' => [
                    'need_popular_plan' => 'yes',
                ]
			]
		);
        $repeater->add_control(
            'pricing_image',
            [
                'label' => __('Pricing Image', 'adina'),
                'type'  => Controls_Manager::MEDIA,
            ]
        );
        $repeater->add_control(
			'pricing_tag',
			[
				'label'   => esc_html__( 'Tag', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( 'Professional', 'adina' ),
                'label_block' => true,
			]
		);
        $repeater->add_control(
			'pricing_feature',
			[
				'label'   => esc_html__( 'Feature', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( '1-19 Employees', 'adina' ),
                'label_block' => true,
			]
		);
        $repeater->add_control(
			'pricing_rate',
			[
				'label'   => esc_html__( 'Price', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( '$299', 'adina' ),
			]
		);
        $repeater->add_control(
			'yearly_pricing_rate',
			[
				'label'   => esc_html__( 'Yearly Price', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( '$699', 'adina' ),
			]
		);
        $repeater->add_control(
			'extra_facility',
			[
				'label'   => esc_html__( 'Facility', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( 'Plus Anual Financial Audit Free for One-Time', 'adina' ),
                'label_block' => true,
			]
		);
        $repeater->add_control(
			'btn_text',
			[
				'label'   => esc_html__( 'Button Text', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( 'Get Started', 'adina' ),
                'label_block' => true,
			]
		);
        $repeater->add_control(
			'btn_link',
			[
				'label' => __( 'URL', 'adina' ),
				'type' => Controls_Manager::URL,
			]
		);
        $this->add_control(
			'pricing_list',
			[
				'label' 		=> __( 'Item', 'adina' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
			]
		);
		$this->end_controls_section();

        // Section style
        $this->start_controls_section(
            'Section_style',
            [
                'label' => __( 'Section', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
            'section_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-pricing-area' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

        // SubTitle style
        $this->start_controls_section(
            'subtitle_style',
            [
                'label' => __( 'Sub Title', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'subtitle_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-section-title-pre' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'subtitle_typography',
				'selector' => '{{WRAPPER}} .td-section-title-pre',
			]
		);
		$this->add_responsive_control(
            'subtitle_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-section-title-pre' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

        // Title style
        $this->start_controls_section(
            'title_style',
            [
                'label' => __( 'Title', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'title_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-section-title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'selector' => '{{WRAPPER}} .td-section-title',
			]
		);
		$this->add_responsive_control(
            'title_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-section-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

        // tab style
        $this->start_controls_section(
            'tab_style',
            [
                'label' => __( 'tab', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'want_price_tab' => 'yes',
                ]
            ]
        );
        $this->add_control(
            'tab_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-pricing-btn-bg button' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'tab_typography',
				'selector' => '{{WRAPPER}} .td-pricing-btn-bg button',
			]
		);
		$this->add_responsive_control(
            'tab_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-pricing-btn-bg button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'tab_active_color',
            [
                'label' => __( 'Active Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-pricing-btn-bg button.active' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'tab_active_bg_color',
            [
                'label' => __( 'Active Background Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-pricing-btn-bg .test' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'tab_active_border',
				'selector' => '{{WRAPPER}} .td-pricing-btn-bg .test',
			]
		);
        $this->add_responsive_control(
			'tab_active_radius',
			[
				'label'         => __( 'Active Border Radius', 'adina' ),
				'type'          => Controls_Manager::DIMENSIONS,
				'size_units'    => [ 'px', '%', 'em' ],
				'selectors'     => [
					'{{WRAPPER}} .td-pricing-btn-bg .test' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );
        $this->add_control(
            'tab_full_bg_color',
            [
                'label' => __( 'Full Background Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-pricing-btn-bg' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'tab_full_border',
				'selector' => '{{WRAPPER}} .td-pricing-btn-bg',
			]
		);
        $this->add_responsive_control(
			'tab_full_radius',
			[
				'label'         => __( 'Full Border Radius', 'adina' ),
				'type'          => Controls_Manager::DIMENSIONS,
				'size_units'    => [ 'px', '%', 'em' ],
				'selectors'     => [
					'{{WRAPPER}} .td-pricing-btn-bg' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );
		$this->end_controls_section();

        // Table style
        $this->start_controls_section(
            'Table_style',
            [
                'label' => __( 'Table', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'table_bg_color',
            [
                'label' => __( 'Background Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-pricing-wrap' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'table_active_bg_color',
            [
                'label' => __( 'Active Background Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-pricing-wrap-2' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'table_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-pricing-wrap' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'table_shadow',
				'selector' => '{{WRAPPER}} .td-pricing-wrap'
			]
		);
        $this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'table_border',
				'selector' => '{{WRAPPER}} .td-pricing-btn-bg',
			]
		);
        $this->add_responsive_control(
			'table_radius',
			[
				'label'         => __( 'Full Border Radius', 'adina' ),
				'type'          => Controls_Manager::DIMENSIONS,
				'size_units'    => [ 'px', '%', 'em' ],
				'selectors'     => [
					'{{WRAPPER}} .td-pricing-btn-bg' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );
		$this->end_controls_section();

        // Image style
        $this->start_controls_section(
            'Image_style',
            [
                'label' => __( 'Image', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
			'img_width',
			[
				'label' => esc_html__( 'Width', 'adina' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .td-pricing-wrap img' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);
        $this->add_responsive_control(
			'active_img_width',
			[
				'label' => esc_html__( 'Active Image Width', 'adina' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .td-pricing-wrap-2 img' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);
        $this->add_responsive_control(
            'img_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-pricing-icon' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

        // tag style
        $this->start_controls_section(
            'tag_style',
            [
                'label' => __( 'Tag', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'tag_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-pricing-tag h5' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'tag_active_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-pricing-wrap-2 .td-pricing-tag h5' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'tag_typography',
				'selector' => '{{WRAPPER}} .td-pricing-tag h5',
			]
		);
		$this->add_responsive_control(
            'tag_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-pricing-tag h5' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

        // feature style
        $this->start_controls_section(
            'feature_style',
            [
                'label' => __( 'Feature', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'feature_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-pricing-tag span' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'feature_active_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-pricing-wrap-2 .td-pricing-tag span' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'feature_typography',
				'selector' => '{{WRAPPER}} .td-pricing-tag span',
			]
		);
		$this->add_responsive_control(
            'feature_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-pricing-tag' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

        // Pricing Rate style
        $this->start_controls_section(
            'pricing_rate_style',
            [
                'label' => __( 'Pricing Rate', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'rate_fill_color',
            [
                'label' => __( 'Fill Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-pricing-price h2' => '-webkit-text-fill-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'active_rate_fill_color',
            [
                'label' => __( 'Fill Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-pricing-wrap-2 .td-pricing-price h2' => '-webkit-text-fill-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'rate_stroke_color',
            [
                'label' => __( 'Stroke Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-pricing-price h2' => '-webkit-text-stroke-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'active_rate_stroke_color',
            [
                'label' => __( 'Stroke Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-pricing-wrap-2 .td-pricing-price h2' => '-webkit-text-stroke-color: {{VALUE}}',
                ],
            ]
        );
		$this->add_responsive_control(
			'rate_stroke_width',
			[
				'label' => esc_html__( 'Stroke Width', 'adina' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .td-pricing-price h2' => '-webkit-text-stroke-width: {{SIZE}}{{UNIT}};',
				],
			]
		);
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'pricing_rate_typography',
				'selector' => '{{WRAPPER}} .td-pricing-price h2',
			]
		);
		$this->add_responsive_control(
            'pricing_rate_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-pricing-price h2' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

        // Facility style
        $this->start_controls_section(
            'facility_style',
            [
                'label' => __( 'Facility', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'facility_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-pricing-price P' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'facility_active_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-pricing-wrap-2 .td-pricing-price P' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'facility_typography',
				'selector' => '{{WRAPPER}} .td-pricing-price P',
			]
		);
		$this->add_responsive_control(
            'facility_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-pricing-price' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

        // Button style
        $this->start_controls_section(
            'btn_style',
            [
                'label' => __( 'Button', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'btn_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-pricing-btn a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'btn_active_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-pricing-btn a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'btn_hover_color',
            [
                'label' => __( 'Hover Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-pricing-btn-2 a:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'btn_bg_color',
            [
                'label' => __( 'Background Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-pricing-btn a' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'btn_active_bg_color',
            [
                'label' => __( 'Background Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-pricing-btn a' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'btn_hover_bg_color',
            [
                'label' => __( 'Hover Background Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-pricing-btn-2 a:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'btn_typography',
				'selector' => '{{WRAPPER}} .td-pricing-btn a',
			]
		);
        $this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'btn_border',
				'selector' => '{{WRAPPER}} .td-pricing-btn a',
			]
		);
        $this->add_responsive_control(
			'btn_radius',
			[
				'label'         => __( 'Border Radius', 'adina' ),
				'type'          => Controls_Manager::DIMENSIONS,
				'size_units'    => [ 'px', '%', 'em' ],
				'selectors'     => [
					'{{WRAPPER}} .td-pricing-btn a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );
        $this->add_responsive_control(
            'btn_padding',
            [
                'label' => __( 'Image Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-pricing-btn a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

	}

	protected function render() {
        $settings = $this->get_settings_for_display();
        $prices = $settings[ 'pricing_list' ];

		?>
            <div class="td-pricing-area fix pt-145 pb-110">
                <div class="container">
                    <div class="row align-items-end">
                        <div class="col-lg-6 wow fadeInRight" data-wow-delay=".3s" data-wow-duration="1s">
                            <div class="td-pricing-title-wrap mb-85">
                                <span class="td-section-title-pre mb-5"><?php echo esc_html( $settings[ 'subtitle_text' ]  ); ?></span>
                                <h2 class="td-section-title"><?php echo esc_html( $settings[ 'title_text' ]  ); ?></h2>
                            </div>
                        </div>

			            <?php if($settings['want_price_tab'] == 'yes'): ?>
                            <div class="col-lg-6 wow fadeInLeft" data-wow-delay=".3s" data-wow-duration="1s">
                                <div class="td-pricing-btn-box mb-95 p-relative d-flex justify-content-end">
                                    <div class="td-pricing-btn-line tpswing">
                                        <svg width="109" height="44" viewBox="0 0 109 44" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M108.078 14.4936C108.351 14.4506 108.537 14.1945 108.494 13.9218L107.792 9.47684C107.749 9.20408 107.493 9.01787 107.22 9.06094C106.947 9.10401 106.761 9.36004 106.804 9.63281L107.428 13.5839L103.477 14.2077C103.204 14.2508 103.018 14.5068 103.061 14.7796C103.104 15.0523 103.36 15.2386 103.633 15.1955L108.078 14.4936ZM1.47803 43.1462C3.35934 37.0115 8.18807 30.1461 15.104 23.7897C22.0127 17.4399 30.9715 11.6288 41.0609 7.58896C61.2377 -0.490019 85.88 -1.46915 107.706 14.4041L108.294 13.5954C86.12 -2.53109 61.0956 -1.51029 40.6891 6.66061C30.4868 10.7457 21.4248 16.622 14.4273 23.0534C7.43693 29.4782 2.474 36.4877 0.521973 42.853L1.47803 43.1462Z" fill="black" />
                                        </svg>
                                    </div>
                                    <div class="td-pricing-btn-offer-tag tpupdown">
                                        <span><?php echo esc_html__( 'Save', 'adina' ); ?> <br> <b> <?php echo esc_html( $settings[ 'discount_percentage' ]  ); ?></b></span>
                                    </div>
                                    <nav>
                                        <div class="nav nav-tab td-pricing-btn-bg" id="nav-tab" role="tablist">
                                            <button class="nav-link active monthly" id="nav-home-tab" 
                                                data-bs-toggle="tab" data-bs-target="#nav-home" type="button" 
                                                role="tab" aria-controls="nav-home" aria-selected="true">
                                                <?php echo esc_html( $settings[ 'monthly_text' ]  ); ?>
                                            </button>
                                            <button class="nav-link yearly" id="nav-profile-tab" 
                                                data-bs-toggle="tab" data-bs-target="#nav-profile" type="button" 
                                                role="tab" aria-controls="nav-profile" aria-selected="false">
                                                <?php echo esc_html( $settings[ 'yearly_text' ]  ); ?>
                                            </button>
                                            <span class="test"></span>
                                        </div>
                                    </nav>
                                </div>
                            </div>
			            <?php endif; ?>

                    </div>
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="price-tab-content">
                                <div class="tab-content" id="nav-tabContent">
                                    <div class="tab-pane fade show active" id="nav-home" role="tabpanel" aria-labelledby="nav-home-tab" tabindex="0">
                                        <div class="row">
                                            <?php foreach( $prices as $price  ): ?>
                                                <div class="col-xl-4 col-lg-6 col-md-6 mb-30">
                                                    <div class="td-pricing-wrap <?php echo ($price['need_popular_plan'] === 'yes') ? 'td-pricing-wrap-2' : ''; ?> p-relative">
                                                        <?php if($price['need_popular_plan'] === 'yes'): ?>
                                                            <span class="td-pricing-badge"><?php echo esc_html( $price[ 'popular_text' ]  ); ?></span>
                                                        <?php endif; ?>
                                                        <div class="td-pricing-content text-center">
                                                            <div class="td-pricing-icon mb-40">
                                                                <span>
                                                                    <img src="<?php echo esc_url($price['pricing_image']['url']); ?>" alt="image">
                                                                </span>
                                                            </div>
                                                            <div class="td-pricing-tag mb-30">
                                                                <h5 class="mb-10"><?php echo esc_html( $price[ 'pricing_tag' ]  ); ?></h5>
                                                                <span><?php echo esc_html( $price[ 'pricing_feature' ]  ); ?></span>
                                                            </div>
                                                            <div class="td-pricing-price mb-50">
                                                                <h2 class="mb-30"><?php echo esc_html( $price[ 'pricing_rate' ]  ); ?></h2>
                                                                <p><?php echo adina_kses( $price[ 'extra_facility' ]  ); ?></p>
                                                            </div>
                                                            <?php if($price['need_popular_plan'] === 'yes'): ?>
                                                                <div class="td-pricing-btn">
                                                                    <a href="<?php echo esc_url($price['btn_link']['url']); ?>">
                                                                        <?php echo esc_html( $price[ 'btn_text' ]  ); ?>
                                                                    </a>
                                                                </div>  
                                                            <?php endif; ?>
                                                            <?php if($price['need_popular_plan'] === ''): ?>
                                                                <div class="td-pricing-btn td-pricing-btn-2">
                                                                    <a href="<?php echo esc_url($price['btn_link']['url']); ?>">
                                                                        <?php echo esc_html( $price[ 'btn_text' ]  ); ?>
                                                                    </a>
                                                                </div>  
                                                            <?php endif; ?>
                                                        </div>
                                                    </div>
                                                </div>
                                            <?php endforeach; ?>
                                        </div>
                                    </div>
                                    <div class="tab-pane fade" id="nav-profile" role="tabpanel" aria-labelledby="nav-profile-tab" tabindex="0">
                                        <div class="row">
                                            <?php foreach( $prices as $price  ): ?>
                                                <div class="col-xl-4 col-lg-6 col-md-6 mb-30">
                                                    <div class="td-pricing-wrap <?php echo ($price['need_popular_plan'] === 'yes') ? 'td-pricing-wrap-2' : ''; ?> p-relative">
                                                        <?php if($price['need_popular_plan'] === 'yes'): ?>
                                                            <span class="td-pricing-badge"><?php echo esc_html( $price[ 'popular_text' ]  ); ?></span>
                                                        <?php endif; ?>
                                                        <div class="td-pricing-content text-center">
                                                            <div class="td-pricing-icon mb-40">
                                                                <span>
                                                                    <img src="<?php echo esc_url($price['pricing_image']['url']); ?>" alt="image">
                                                                </span>
                                                            </div>
                                                            <div class="td-pricing-tag mb-30">
                                                                <h5 class="mb-10"><?php echo esc_html( $price[ 'pricing_tag' ]  ); ?></h5>
                                                                <span><?php echo esc_html( $price[ 'pricing_feature' ]  ); ?></span>
                                                            </div>
                                                            <div class="td-pricing-price mb-50">
                                                                <h2 class="mb-30"><?php echo esc_html( $price[ 'yearly_pricing_rate' ]  ); ?></h2>
                                                                <p><?php echo adina_kses( $price[ 'extra_facility' ]  ); ?></p>
                                                            </div>
                                                            <?php if($price['need_popular_plan'] === 'yes'): ?>
                                                                <div class="td-pricing-btn">
                                                                    <a href="<?php echo esc_url($price['btn_link']['url']); ?>">
                                                                        <?php echo esc_html( $price[ 'btn_text' ]  ); ?>
                                                                    </a>
                                                                </div>  
                                                            <?php endif; ?>
                                                            <?php if($price['need_popular_plan'] === ''): ?>
                                                                <div class="td-pricing-btn td-pricing-btn-2">
                                                                    <a href="<?php echo esc_url($price['btn_link']['url']); ?>">
                                                                        <?php echo esc_html( $price[ 'btn_text' ]  ); ?>
                                                                    </a>
                                                                </div>  
                                                            <?php endif; ?>   
                                                        </div>
                                                    </div>
                                                </div>
                                            <?php endforeach; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
		<?php
	}
}
$widgets_manager->register( new \Adina_Pricing() );