<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Utils;
use \Elementor\Group_Control_Background;
use \Elementor\Repeater;
/**
 *
 * Progress Bar Widget .
 *
 */
class Adina_Progress_Bar extends Widget_Base {

	public function get_name() {
		return 'progress_bar';
	}

	public function get_title() {
		return __( 'Progress Bar', 'adina' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'adina' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'progress_section',
			[
				'label' 	=> __( 'Content', 'adina' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			] 
        );
        $this->add_control(
            'progress_layout',
            [
                'label' => esc_html__('Select Layout', 'adina'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'layout-1' => esc_html__('Layout 1', 'adina'),
                    'layout-2' => esc_html__('Layout 2', 'adina'),
                ],
                'default' => 'layout-1',
            ]
        );
        $this->add_control(
			'title_text',
			[
				'label'   => esc_html__( 'Title', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( 'Human Resources', 'adina' ),
                'label_block' => true,
			]
		);
        $this->add_control(
			'progress_nmbr',
			[
				'label'   => esc_html__( 'Progress Number', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( '45', 'adina' ),
                'label_block' => true,
			]
		);
		$this->end_controls_section();

        // Title style
        $this->start_controls_section(
            'title_style',
            [
                'label' => __( 'Title', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'title_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-work-progress-title' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .td-service-quality-title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'selector' => '{{WRAPPER}} .td-work-progress-title, {{WRAPPER}} .td-service-quality-title',
			]
		);
		$this->add_responsive_control(
            'title_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-work-progress-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .td-service-details-pogress-quality' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

        // Number style
        $this->start_controls_section(
            'nmbr_style',
            [
                'label' => __( 'Number', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'progress_layout' => 'layout-1',
                ],
            ]
        );
        $this->add_control(
            'nmbr_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-work-progress-counter' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'nmbr_typography',
				'selector' => '{{WRAPPER}} .td-work-progress-counter',
			]
		);
		$this->add_responsive_control(
            'nmbr_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .td-work-progress-counter' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

        // Line style
        $this->start_controls_section(
            'line_style',
            [
                'label' => __( 'Line', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'progress_layout' => 'layout-1',
                ],
            ]
        );
        $this->add_responsive_control(
			'line_height',
			[
				'label' => esc_html__( 'Height', 'adina' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .td-work-progress-inner, .td-work-progress-bar' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);
        $this->add_control(
            'line_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-work-progress-inner' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'active_line_color',
            [
                'label' => __( 'Active Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .td-work-progress-bar' => 'background-color: {{VALUE}}',
                ],
            ]
        );
		$this->end_controls_section();

	}

	protected function render() {
        $settings = $this->get_settings_for_display();
        $layout = $settings['progress_layout'];

		?>
            <?php
                if ( $layout) {
                    include('progress-bar/'.$layout.'.php');
                }
            ?> 
		<?php
	}
}
$widgets_manager->register( new \Adina_Progress_Bar() );